/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss;

import java.util.Vector;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import org.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSLeaf;
import org.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSRootCalc;
import org.bouncycastle.pqc.crypto.gmss.GMSSRootSig;
import org.bouncycastle.pqc.crypto.gmss.Treehash;
import org.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import org.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import org.bouncycastle.util.Arrays;

public class GMSSPrivateKeyParameters
extends GMSSKeyParameters {
    private int[] index;
    private byte[][] currentSeeds;
    private byte[][] nextNextSeeds;
    private byte[][][] currentAuthPaths;
    private byte[][][] nextAuthPaths;
    private Treehash[][] currentTreehash;
    private Treehash[][] nextTreehash;
    private Vector[] currentStack;
    private Vector[] nextStack;
    private Vector[][] currentRetain;
    private Vector[][] nextRetain;
    private byte[][][] keep;
    private GMSSLeaf[] nextNextLeaf;
    private GMSSLeaf[] upperLeaf;
    private GMSSLeaf[] upperTreehashLeaf;
    private int[] minTreehash;
    private GMSSParameters gmssPS;
    private byte[][] nextRoot;
    private GMSSRootCalc[] nextNextRoot;
    private byte[][] currentRootSig;
    private GMSSRootSig[] nextRootSig;
    private GMSSDigestProvider digestProvider;
    private boolean used = false;
    private int[] heightOfTrees;
    private int[] otsIndex;
    private int[] K;
    private int numLayer;
    private Digest messDigestTrees;
    private int mdLength;
    private GMSSRandom gmssRandom;
    private int[] numLeafs;

    public GMSSPrivateKeyParameters(byte[][] byArray, byte[][] byArray2, byte[][][] byArray3, byte[][][] byArray4, Treehash[][] treehashArray, Treehash[][] treehashArray2, Vector[] vectorArray, Vector[] vectorArray2, Vector[][] vectorArray3, Vector[][] vectorArray4, byte[][] byArray5, byte[][] byArray6, GMSSParameters gMSSParameters, GMSSDigestProvider gMSSDigestProvider) {
        this(null, byArray, byArray2, byArray3, byArray4, null, treehashArray, treehashArray2, vectorArray, vectorArray2, vectorArray3, vectorArray4, null, null, null, null, byArray5, null, byArray6, null, gMSSParameters, gMSSDigestProvider);
    }

    public GMSSPrivateKeyParameters(int[] nArray, byte[][] byArray, byte[][] byArray2, byte[][][] byArray3, byte[][][] byArray4, byte[][][] byArray5, Treehash[][] treehashArray, Treehash[][] treehashArray2, Vector[] vectorArray, Vector[] vectorArray2, Vector[][] vectorArray3, Vector[][] vectorArray4, GMSSLeaf[] gMSSLeafArray, GMSSLeaf[] gMSSLeafArray2, GMSSLeaf[] gMSSLeafArray3, int[] nArray2, byte[][] byArray6, GMSSRootCalc[] gMSSRootCalcArray, byte[][] byArray7, GMSSRootSig[] gMSSRootSigArray, GMSSParameters gMSSParameters, GMSSDigestProvider gMSSDigestProvider) {
        super(true, gMSSParameters);
        int n4;
        this.messDigestTrees = gMSSDigestProvider.get();
        this.mdLength = this.messDigestTrees.getDigestSize();
        this.gmssPS = gMSSParameters;
        this.otsIndex = gMSSParameters.getWinternitzParameter();
        this.K = gMSSParameters.getK();
        this.heightOfTrees = gMSSParameters.getHeightOfTrees();
        this.numLayer = this.gmssPS.getNumOfLayers();
        if (nArray == null) {
            this.index = new int[this.numLayer];
            for (n4 = 0; n4 < this.numLayer; ++n4) {
                this.index[n4] = 0;
            }
        } else {
            this.index = nArray;
        }
        this.currentSeeds = byArray;
        this.nextNextSeeds = byArray2;
        this.currentAuthPaths = byArray3;
        this.nextAuthPaths = byArray4;
        if (byArray5 == null) {
            this.keep = new byte[this.numLayer][][];
            for (n4 = 0; n4 < this.numLayer; ++n4) {
                this.keep[n4] = new byte[(int)Math.floor(this.heightOfTrees[n4] / 2)][this.mdLength];
            }
        } else {
            this.keep = byArray5;
        }
        if (vectorArray == null) {
            this.currentStack = new Vector[this.numLayer];
            for (n4 = 0; n4 < this.numLayer; ++n4) {
                this.currentStack[n4] = new Vector();
            }
        } else {
            this.currentStack = vectorArray;
        }
        if (vectorArray2 == null) {
            this.nextStack = new Vector[this.numLayer - 1];
            for (n4 = 0; n4 < this.numLayer - 1; ++n4) {
                this.nextStack[n4] = new Vector();
            }
        } else {
            this.nextStack = vectorArray2;
        }
        this.currentTreehash = treehashArray;
        this.nextTreehash = treehashArray2;
        this.currentRetain = vectorArray3;
        this.nextRetain = vectorArray4;
        this.nextRoot = byArray6;
        this.digestProvider = gMSSDigestProvider;
        if (gMSSRootCalcArray == null) {
            this.nextNextRoot = new GMSSRootCalc[this.numLayer - 1];
            for (n4 = 0; n4 < this.numLayer - 1; ++n4) {
                this.nextNextRoot[n4] = new GMSSRootCalc(this.heightOfTrees[n4 + 1], this.K[n4 + 1], this.digestProvider);
            }
        } else {
            this.nextNextRoot = gMSSRootCalcArray;
        }
        this.currentRootSig = byArray7;
        this.numLeafs = new int[this.numLayer];
        for (n4 = 0; n4 < this.numLayer; ++n4) {
            this.numLeafs[n4] = 1 << this.heightOfTrees[n4];
        }
        this.gmssRandom = new GMSSRandom(this.messDigestTrees);
        if (this.numLayer > 1) {
            if (gMSSLeafArray == null) {
                this.nextNextLeaf = new GMSSLeaf[this.numLayer - 2];
                for (n4 = 0; n4 < this.numLayer - 2; ++n4) {
                    this.nextNextLeaf[n4] = new GMSSLeaf(gMSSDigestProvider.get(), this.otsIndex[n4 + 1], this.numLeafs[n4 + 2], this.nextNextSeeds[n4]);
                }
            } else {
                this.nextNextLeaf = gMSSLeafArray;
            }
        } else {
            this.nextNextLeaf = new GMSSLeaf[0];
        }
        if (gMSSLeafArray2 == null) {
            this.upperLeaf = new GMSSLeaf[this.numLayer - 1];
            for (n4 = 0; n4 < this.numLayer - 1; ++n4) {
                this.upperLeaf[n4] = new GMSSLeaf(gMSSDigestProvider.get(), this.otsIndex[n4], this.numLeafs[n4 + 1], this.currentSeeds[n4]);
            }
        } else {
            this.upperLeaf = gMSSLeafArray2;
        }
        if (gMSSLeafArray3 == null) {
            this.upperTreehashLeaf = new GMSSLeaf[this.numLayer - 1];
            for (n4 = 0; n4 < this.numLayer - 1; ++n4) {
                this.upperTreehashLeaf[n4] = new GMSSLeaf(gMSSDigestProvider.get(), this.otsIndex[n4], this.numLeafs[n4 + 1]);
            }
        } else {
            this.upperTreehashLeaf = gMSSLeafArray3;
        }
        if (nArray2 == null) {
            this.minTreehash = new int[this.numLayer - 1];
            for (n4 = 0; n4 < this.numLayer - 1; ++n4) {
                this.minTreehash[n4] = -1;
            }
        } else {
            this.minTreehash = nArray2;
        }
        byte[] byArray8 = new byte[this.mdLength];
        byte[] byArray9 = new byte[this.mdLength];
        if (gMSSRootSigArray == null) {
            this.nextRootSig = new GMSSRootSig[this.numLayer - 1];
            for (int i4 = 0; i4 < this.numLayer - 1; ++i4) {
                System.arraycopy(byArray[i4], 0, byArray8, 0, this.mdLength);
                this.gmssRandom.nextSeed(byArray8);
                byArray9 = this.gmssRandom.nextSeed(byArray8);
                this.nextRootSig[i4] = new GMSSRootSig(gMSSDigestProvider.get(), this.otsIndex[i4], this.heightOfTrees[i4 + 1]);
                this.nextRootSig[i4].initSign(byArray9, byArray6[i4]);
            }
        } else {
            this.nextRootSig = gMSSRootSigArray;
        }
    }

    private GMSSPrivateKeyParameters(GMSSPrivateKeyParameters gMSSPrivateKeyParameters) {
        super(true, gMSSPrivateKeyParameters.getParameters());
        this.index = Arrays.clone(gMSSPrivateKeyParameters.index);
        this.currentSeeds = Arrays.clone(gMSSPrivateKeyParameters.currentSeeds);
        this.nextNextSeeds = Arrays.clone(gMSSPrivateKeyParameters.nextNextSeeds);
        this.currentAuthPaths = Arrays.clone(gMSSPrivateKeyParameters.currentAuthPaths);
        this.nextAuthPaths = Arrays.clone(gMSSPrivateKeyParameters.nextAuthPaths);
        this.currentTreehash = gMSSPrivateKeyParameters.currentTreehash;
        this.nextTreehash = gMSSPrivateKeyParameters.nextTreehash;
        this.currentStack = gMSSPrivateKeyParameters.currentStack;
        this.nextStack = gMSSPrivateKeyParameters.nextStack;
        this.currentRetain = gMSSPrivateKeyParameters.currentRetain;
        this.nextRetain = gMSSPrivateKeyParameters.nextRetain;
        this.keep = Arrays.clone(gMSSPrivateKeyParameters.keep);
        this.nextNextLeaf = gMSSPrivateKeyParameters.nextNextLeaf;
        this.upperLeaf = gMSSPrivateKeyParameters.upperLeaf;
        this.upperTreehashLeaf = gMSSPrivateKeyParameters.upperTreehashLeaf;
        this.minTreehash = gMSSPrivateKeyParameters.minTreehash;
        this.gmssPS = gMSSPrivateKeyParameters.gmssPS;
        this.nextRoot = Arrays.clone(gMSSPrivateKeyParameters.nextRoot);
        this.nextNextRoot = gMSSPrivateKeyParameters.nextNextRoot;
        this.currentRootSig = gMSSPrivateKeyParameters.currentRootSig;
        this.nextRootSig = gMSSPrivateKeyParameters.nextRootSig;
        this.digestProvider = gMSSPrivateKeyParameters.digestProvider;
        this.heightOfTrees = gMSSPrivateKeyParameters.heightOfTrees;
        this.otsIndex = gMSSPrivateKeyParameters.otsIndex;
        this.K = gMSSPrivateKeyParameters.K;
        this.numLayer = gMSSPrivateKeyParameters.numLayer;
        this.messDigestTrees = gMSSPrivateKeyParameters.messDigestTrees;
        this.mdLength = gMSSPrivateKeyParameters.mdLength;
        this.gmssRandom = gMSSPrivateKeyParameters.gmssRandom;
        this.numLeafs = gMSSPrivateKeyParameters.numLeafs;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void markUsed() {
        this.used = true;
    }

    public GMSSPrivateKeyParameters nextKey() {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = new GMSSPrivateKeyParameters(this);
        gMSSPrivateKeyParameters.nextKey(this.gmssPS.getNumOfLayers() - 1);
        return gMSSPrivateKeyParameters;
    }

    private void nextKey(int n4) {
        if (n4 == this.numLayer - 1) {
            int n5 = n4;
            this.index[n5] = this.index[n5] + 1;
        }
        if (this.index[n4] == this.numLeafs[n4]) {
            if (this.numLayer != 1) {
                this.nextTree(n4);
                this.index[n4] = 0;
            }
        } else {
            this.updateKey(n4);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void nextTree(int n4) {
        if (n4 > 0) {
            int n5 = n4 - 1;
            this.index[n5] = this.index[n5] + 1;
            boolean bl = true;
            int n6 = n4;
            do {
                if (this.index[--n6] >= this.numLeafs[n6]) continue;
                bl = false;
            } while (bl && n6 > 0);
            if (!bl) {
                int n7;
                this.gmssRandom.nextSeed(this.currentSeeds[n4]);
                this.nextRootSig[n4 - 1].updateSign();
                if (n4 > 1) {
                    this.nextNextLeaf[n4 - 1 - 1] = this.nextNextLeaf[n4 - 1 - 1].nextLeaf();
                }
                this.upperLeaf[n4 - 1] = this.upperLeaf[n4 - 1].nextLeaf();
                if (this.minTreehash[n4 - 1] >= 0) {
                    this.upperTreehashLeaf[n4 - 1] = this.upperTreehashLeaf[n4 - 1].nextLeaf();
                    byte[] byArray = this.upperTreehashLeaf[n4 - 1].getLeaf();
                    try {
                        this.currentTreehash[n4 - 1][this.minTreehash[n4 - 1]].update(this.gmssRandom, byArray);
                        if (!this.currentTreehash[n4 - 1][this.minTreehash[n4 - 1]].wasFinished()) {
                            // empty if block
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
                this.updateNextNextAuthRoot(n4);
                this.currentRootSig[n4 - 1] = this.nextRootSig[n4 - 1].getSig();
                for (n7 = 0; n7 < this.heightOfTrees[n4] - this.K[n4]; ++n7) {
                    this.currentTreehash[n4][n7] = this.nextTreehash[n4 - 1][n7];
                    this.nextTreehash[n4 - 1][n7] = this.nextNextRoot[n4 - 1].getTreehash()[n7];
                }
                for (n7 = 0; n7 < this.heightOfTrees[n4]; ++n7) {
                    System.arraycopy(this.nextAuthPaths[n4 - 1][n7], 0, this.currentAuthPaths[n4][n7], 0, this.mdLength);
                    System.arraycopy(this.nextNextRoot[n4 - 1].getAuthPath()[n7], 0, this.nextAuthPaths[n4 - 1][n7], 0, this.mdLength);
                }
                for (n7 = 0; n7 < this.K[n4] - 1; ++n7) {
                    this.currentRetain[n4][n7] = this.nextRetain[n4 - 1][n7];
                    this.nextRetain[n4 - 1][n7] = this.nextNextRoot[n4 - 1].getRetain()[n7];
                }
                this.currentStack[n4] = this.nextStack[n4 - 1];
                this.nextStack[n4 - 1] = this.nextNextRoot[n4 - 1].getStack();
                this.nextRoot[n4 - 1] = this.nextNextRoot[n4 - 1].getRoot();
                byte[] byArray = new byte[this.mdLength];
                byte[] byArray2 = new byte[this.mdLength];
                System.arraycopy(this.currentSeeds[n4 - 1], 0, byArray2, 0, this.mdLength);
                byArray = this.gmssRandom.nextSeed(byArray2);
                byArray = this.gmssRandom.nextSeed(byArray2);
                byArray = this.gmssRandom.nextSeed(byArray2);
                this.nextRootSig[n4 - 1].initSign(byArray, this.nextRoot[n4 - 1]);
                this.nextKey(n4 - 1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateKey(int n4) {
        this.computeAuthPaths(n4);
        if (n4 > 0) {
            if (n4 > 1) {
                this.nextNextLeaf[n4 - 1 - 1] = this.nextNextLeaf[n4 - 1 - 1].nextLeaf();
            }
            this.upperLeaf[n4 - 1] = this.upperLeaf[n4 - 1].nextLeaf();
            int n5 = (int)Math.floor((double)(this.getNumLeafs(n4) * 2) / (double)(this.heightOfTrees[n4 - 1] - this.K[n4 - 1]));
            if (this.index[n4] % n5 == 1) {
                byte[] byArray;
                if (this.index[n4] > 1 && this.minTreehash[n4 - 1] >= 0) {
                    byArray = this.upperTreehashLeaf[n4 - 1].getLeaf();
                    try {
                        this.currentTreehash[n4 - 1][this.minTreehash[n4 - 1]].update(this.gmssRandom, byArray);
                        if (!this.currentTreehash[n4 - 1][this.minTreehash[n4 - 1]].wasFinished()) {
                            // empty if block
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
                this.minTreehash[n4 - 1] = this.getMinTreehashIndex(n4 - 1);
                if (this.minTreehash[n4 - 1] >= 0) {
                    byArray = this.currentTreehash[n4 - 1][this.minTreehash[n4 - 1]].getSeedActive();
                    this.upperTreehashLeaf[n4 - 1] = new GMSSLeaf(this.digestProvider.get(), this.otsIndex[n4 - 1], n5, byArray);
                    this.upperTreehashLeaf[n4 - 1] = this.upperTreehashLeaf[n4 - 1].nextLeaf();
                }
            } else if (this.minTreehash[n4 - 1] >= 0) {
                this.upperTreehashLeaf[n4 - 1] = this.upperTreehashLeaf[n4 - 1].nextLeaf();
            }
            this.nextRootSig[n4 - 1].updateSign();
            if (this.index[n4] == 1) {
                this.nextNextRoot[n4 - 1].initialize(new Vector());
            }
            this.updateNextNextAuthRoot(n4);
        }
    }

    private int getMinTreehashIndex(int n4) {
        int n5 = -1;
        for (int i4 = 0; i4 < this.heightOfTrees[n4] - this.K[n4]; ++i4) {
            if (!this.currentTreehash[n4][i4].wasInitialized() || this.currentTreehash[n4][i4].wasFinished()) continue;
            if (n5 == -1) {
                n5 = i4;
                continue;
            }
            if (this.currentTreehash[n4][i4].getLowestNodeHeight() >= this.currentTreehash[n4][n5].getLowestNodeHeight()) continue;
            n5 = i4;
        }
        return n5;
    }

    private void computeAuthPaths(int n4) {
        int n5;
        Object object;
        int n6;
        int n7 = this.index[n4];
        int n8 = this.heightOfTrees[n4];
        int n9 = this.K[n4];
        for (n6 = 0; n6 < n8 - n9; ++n6) {
            this.currentTreehash[n4][n6].updateNextSeed(this.gmssRandom);
        }
        n6 = this.heightOfPhi(n7);
        byte[] byArray = new byte[this.mdLength];
        byArray = this.gmssRandom.nextSeed(this.currentSeeds[n4]);
        int n10 = n7 >>> n6 + 1 & 1;
        byte[] byArray2 = new byte[this.mdLength];
        if (n6 < n8 - 1 && n10 == 0) {
            System.arraycopy(this.currentAuthPaths[n4][n6], 0, byArray2, 0, this.mdLength);
        }
        byte[] byArray3 = new byte[this.mdLength];
        if (n6 == 0) {
            if (n4 == this.numLayer - 1) {
                object = new WinternitzOTSignature(byArray, this.digestProvider.get(), this.otsIndex[n4]);
                byArray3 = ((WinternitzOTSignature)object).getPublicKey();
            } else {
                object = new byte[this.mdLength];
                System.arraycopy(this.currentSeeds[n4], 0, object, 0, this.mdLength);
                this.gmssRandom.nextSeed((byte[])object);
                byArray3 = this.upperLeaf[n4].getLeaf();
                this.upperLeaf[n4].initLeafCalc((byte[])object);
            }
            System.arraycopy(byArray3, 0, this.currentAuthPaths[n4][0], 0, this.mdLength);
        } else {
            object = new byte[this.mdLength << 1];
            System.arraycopy(this.currentAuthPaths[n4][n6 - 1], 0, object, 0, this.mdLength);
            System.arraycopy(this.keep[n4][(int)Math.floor((n6 - 1) / 2)], 0, object, this.mdLength, this.mdLength);
            this.messDigestTrees.update((byte[])object, 0, ((Object)object).length);
            this.currentAuthPaths[n4][n6] = new byte[this.messDigestTrees.getDigestSize()];
            this.messDigestTrees.doFinal(this.currentAuthPaths[n4][n6], 0);
            for (n5 = 0; n5 < n6; ++n5) {
                int n11;
                if (n5 < n8 - n9) {
                    if (this.currentTreehash[n4][n5].wasFinished()) {
                        System.arraycopy(this.currentTreehash[n4][n5].getFirstNode(), 0, this.currentAuthPaths[n4][n5], 0, this.mdLength);
                        this.currentTreehash[n4][n5].destroy();
                    } else {
                        System.err.println("Treehash (" + n4 + "," + n5 + ") not finished when needed in AuthPathComputation");
                    }
                }
                if (n5 < n8 - 1 && n5 >= n8 - n9 && this.currentRetain[n4][n5 - (n8 - n9)].size() > 0) {
                    System.arraycopy(this.currentRetain[n4][n5 - (n8 - n9)].lastElement(), 0, this.currentAuthPaths[n4][n5], 0, this.mdLength);
                    this.currentRetain[n4][n5 - (n8 - n9)].removeElementAt(this.currentRetain[n4][n5 - (n8 - n9)].size() - 1);
                }
                if (n5 >= n8 - n9 || (n11 = n7 + 3 * (1 << n5)) >= this.numLeafs[n4]) continue;
                this.currentTreehash[n4][n5].initialize();
            }
        }
        if (n6 < n8 - 1 && n10 == 0) {
            System.arraycopy(byArray2, 0, this.keep[n4][(int)Math.floor(n6 / 2)], 0, this.mdLength);
        }
        if (n4 == this.numLayer - 1) {
            for (int i4 = 1; i4 <= (n8 - n9) / 2; ++i4) {
                n5 = this.getMinTreehashIndex(n4);
                if (n5 < 0) continue;
                try {
                    byte[] byArray4 = new byte[this.mdLength];
                    System.arraycopy(this.currentTreehash[n4][n5].getSeedActive(), 0, byArray4, 0, this.mdLength);
                    byte[] byArray5 = this.gmssRandom.nextSeed(byArray4);
                    WinternitzOTSignature winternitzOTSignature = new WinternitzOTSignature(byArray5, this.digestProvider.get(), this.otsIndex[n4]);
                    byte[] byArray6 = winternitzOTSignature.getPublicKey();
                    this.currentTreehash[n4][n5].update(this.gmssRandom, byArray6);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        } else {
            this.minTreehash[n4] = this.getMinTreehashIndex(n4);
        }
    }

    private int heightOfPhi(int n4) {
        if (n4 == 0) {
            return -1;
        }
        int n5 = 0;
        int n6 = 1;
        while (n4 % n6 == 0) {
            n6 *= 2;
            ++n5;
        }
        return n5 - 1;
    }

    private void updateNextNextAuthRoot(int n4) {
        byte[] byArray = new byte[this.mdLength];
        byArray = this.gmssRandom.nextSeed(this.nextNextSeeds[n4 - 1]);
        if (n4 == this.numLayer - 1) {
            WinternitzOTSignature winternitzOTSignature = new WinternitzOTSignature(byArray, this.digestProvider.get(), this.otsIndex[n4]);
            this.nextNextRoot[n4 - 1].update(this.nextNextSeeds[n4 - 1], winternitzOTSignature.getPublicKey());
        } else {
            this.nextNextRoot[n4 - 1].update(this.nextNextSeeds[n4 - 1], this.nextNextLeaf[n4 - 1].getLeaf());
            this.nextNextLeaf[n4 - 1].initLeafCalc(this.nextNextSeeds[n4 - 1]);
        }
    }

    public int[] getIndex() {
        return this.index;
    }

    public int getIndex(int n4) {
        return this.index[n4];
    }

    public byte[][] getCurrentSeeds() {
        return Arrays.clone(this.currentSeeds);
    }

    public byte[][][] getCurrentAuthPaths() {
        return Arrays.clone(this.currentAuthPaths);
    }

    public byte[] getSubtreeRootSig(int n4) {
        return this.currentRootSig[n4];
    }

    public GMSSDigestProvider getName() {
        return this.digestProvider;
    }

    public int getNumLeafs(int n4) {
        return this.numLeafs[n4];
    }
}

