/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw;

import java.math.BigInteger;
import org.bouncycastle.util.Pack;

public abstract class Nat {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray3[i4] = (int)(l4 += ((long)nArray[i4] & 0xFFFFFFFFL) + ((long)nArray2[i4] & 0xFFFFFFFFL));
            l4 >>>= 32;
        }
        return (int)l4;
    }

    public static int add33At(int n4, int n5, int[] nArray, int n6) {
        long l4 = ((long)nArray[n6 + 0] & 0xFFFFFFFFL) + ((long)n5 & 0xFFFFFFFFL);
        nArray[n6 + 0] = (int)l4;
        l4 >>>= 32;
        nArray[n6 + 1] = (int)(l4 += ((long)nArray[n6 + 1] & 0xFFFFFFFFL) + 1L);
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, n6 + 2);
    }

    public static int add33At(int n4, int n5, int[] nArray, int n6, int n7) {
        long l4 = ((long)nArray[n6 + n7] & 0xFFFFFFFFL) + ((long)n5 & 0xFFFFFFFFL);
        nArray[n6 + n7] = (int)l4;
        l4 >>>= 32;
        nArray[n6 + n7 + 1] = (int)(l4 += ((long)nArray[n6 + n7 + 1] & 0xFFFFFFFFL) + 1L);
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, n6, n7 + 2);
    }

    public static int add33To(int n4, int n5, int[] nArray) {
        long l4 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)n5 & 0xFFFFFFFFL);
        nArray[0] = (int)l4;
        l4 >>>= 32;
        nArray[1] = (int)(l4 += ((long)nArray[1] & 0xFFFFFFFFL) + 1L);
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, 2);
    }

    public static int add33To(int n4, int n5, int[] nArray, int n6) {
        long l4 = ((long)nArray[n6 + 0] & 0xFFFFFFFFL) + ((long)n5 & 0xFFFFFFFFL);
        nArray[n6 + 0] = (int)l4;
        l4 >>>= 32;
        nArray[n6 + 1] = (int)(l4 += ((long)nArray[n6 + 1] & 0xFFFFFFFFL) + 1L);
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, n6, 2);
    }

    public static int addBothTo(int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray3[i4] = (int)(l4 += ((long)nArray[i4] & 0xFFFFFFFFL) + ((long)nArray2[i4] & 0xFFFFFFFFL) + ((long)nArray3[i4] & 0xFFFFFFFFL));
            l4 >>>= 32;
        }
        return (int)l4;
    }

    public static int addBothTo(int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray3[n7 + i4] = (int)(l4 += ((long)nArray[n5 + i4] & 0xFFFFFFFFL) + ((long)nArray2[n6 + i4] & 0xFFFFFFFFL) + ((long)nArray3[n7 + i4] & 0xFFFFFFFFL));
            l4 >>>= 32;
        }
        return (int)l4;
    }

    public static int addDWordAt(int n4, long l4, int[] nArray, int n5) {
        long l5 = ((long)nArray[n5 + 0] & 0xFFFFFFFFL) + (l4 & 0xFFFFFFFFL);
        nArray[n5 + 0] = (int)l5;
        l5 >>>= 32;
        nArray[n5 + 1] = (int)(l5 += ((long)nArray[n5 + 1] & 0xFFFFFFFFL) + (l4 >>> 32));
        return (l5 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, n5 + 2);
    }

    public static int addDWordAt(int n4, long l4, int[] nArray, int n5, int n6) {
        long l5 = ((long)nArray[n5 + n6] & 0xFFFFFFFFL) + (l4 & 0xFFFFFFFFL);
        nArray[n5 + n6] = (int)l5;
        l5 >>>= 32;
        nArray[n5 + n6 + 1] = (int)(l5 += ((long)nArray[n5 + n6 + 1] & 0xFFFFFFFFL) + (l4 >>> 32));
        return (l5 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, n5, n6 + 2);
    }

    public static int addDWordTo(int n4, long l4, int[] nArray) {
        long l5 = ((long)nArray[0] & 0xFFFFFFFFL) + (l4 & 0xFFFFFFFFL);
        nArray[0] = (int)l5;
        l5 >>>= 32;
        nArray[1] = (int)(l5 += ((long)nArray[1] & 0xFFFFFFFFL) + (l4 >>> 32));
        return (l5 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, 2);
    }

    public static int addDWordTo(int n4, long l4, int[] nArray, int n5) {
        long l5 = ((long)nArray[n5 + 0] & 0xFFFFFFFFL) + (l4 & 0xFFFFFFFFL);
        nArray[n5 + 0] = (int)l5;
        l5 >>>= 32;
        nArray[n5 + 1] = (int)(l5 += ((long)nArray[n5 + 1] & 0xFFFFFFFFL) + (l4 >>> 32));
        return (l5 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, n5, 2);
    }

    public static int addTo(int n4, int[] nArray, int[] nArray2) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray2[i4] = (int)(l4 += ((long)nArray[i4] & 0xFFFFFFFFL) + ((long)nArray2[i4] & 0xFFFFFFFFL));
            l4 >>>= 32;
        }
        return (int)l4;
    }

    public static int addTo(int n4, int[] nArray, int n5, int[] nArray2, int n6) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray2[n6 + i4] = (int)(l4 += ((long)nArray[n5 + i4] & 0xFFFFFFFFL) + ((long)nArray2[n6 + i4] & 0xFFFFFFFFL));
            l4 >>>= 32;
        }
        return (int)l4;
    }

    public static int addWordAt(int n4, int n5, int[] nArray, int n6) {
        long l4 = ((long)n5 & 0xFFFFFFFFL) + ((long)nArray[n6] & 0xFFFFFFFFL);
        nArray[n6] = (int)l4;
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, n6 + 1);
    }

    public static int addWordAt(int n4, int n5, int[] nArray, int n6, int n7) {
        long l4 = ((long)n5 & 0xFFFFFFFFL) + ((long)nArray[n6 + n7] & 0xFFFFFFFFL);
        nArray[n6 + n7] = (int)l4;
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, n6, n7 + 1);
    }

    public static int addWordTo(int n4, int n5, int[] nArray) {
        long l4 = ((long)n5 & 0xFFFFFFFFL) + ((long)nArray[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l4;
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, 1);
    }

    public static int addWordTo(int n4, int n5, int[] nArray, int n6) {
        long l4 = ((long)n5 & 0xFFFFFFFFL) + ((long)nArray[n6] & 0xFFFFFFFFL);
        nArray[n6] = (int)l4;
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, n6, 1);
    }

    public static int[] copy(int n4, int[] nArray) {
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    public static void copy(int n4, int[] nArray, int[] nArray2) {
        System.arraycopy(nArray, 0, nArray2, 0, n4);
    }

    public static int[] create(int n4) {
        return new int[n4];
    }

    public static long[] create64(int n4) {
        return new long[n4];
    }

    public static int dec(int n4, int[] nArray) {
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5++;
            nArray[n6] = nArray[n6] - 1;
            if (nArray[n6] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int dec(int n4, int[] nArray, int[] nArray2) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n5;
            nArray2[i4] = n5 = nArray[i4] - 1;
            if (n5 == -1) continue;
            while (i4 < n4) {
                nArray2[i4] = nArray[i4];
                ++i4;
            }
            return 0;
        }
        return -1;
    }

    public static int decAt(int n4, int[] nArray, int n5) {
        int n6 = n5;
        while (n6 < n4) {
            int n7 = n6++;
            nArray[n7] = nArray[n7] - 1;
            if (nArray[n7] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int decAt(int n4, int[] nArray, int n5, int n6) {
        for (int i4 = n6; i4 < n4; ++i4) {
            int n7 = n5 + i4;
            nArray[n7] = nArray[n7] - 1;
            if (nArray[n7] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static boolean eq(int n4, int[] nArray, int[] nArray2) {
        for (int i4 = n4 - 1; i4 >= 0; --i4) {
            if (nArray[i4] == nArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(int n4, BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > n4) {
            throw new IllegalArgumentException();
        }
        int n5 = n4 + 31 >> 5;
        int[] nArray = Nat.create(n5);
        int n6 = 0;
        while (bigInteger.signum() != 0) {
            nArray[n6++] = bigInteger.intValue();
            bigInteger = bigInteger.shiftRight(32);
        }
        return nArray;
    }

    public static int getBit(int[] nArray, int n4) {
        if (n4 == 0) {
            return nArray[0] & 1;
        }
        int n5 = n4 >> 5;
        if (n5 < 0 || n5 >= nArray.length) {
            return 0;
        }
        int n6 = n4 & 0x1F;
        return nArray[n5] >>> n6 & 1;
    }

    public static boolean gte(int n4, int[] nArray, int[] nArray2) {
        for (int i4 = n4 - 1; i4 >= 0; --i4) {
            int n5 = nArray[i4] ^ Integer.MIN_VALUE;
            int n6 = nArray2[i4] ^ Integer.MIN_VALUE;
            if (n5 < n6) {
                return false;
            }
            if (n5 <= n6) continue;
            return true;
        }
        return true;
    }

    public static int inc(int n4, int[] nArray) {
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5++;
            nArray[n6] = nArray[n6] + 1;
            if (nArray[n6] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int inc(int n4, int[] nArray, int[] nArray2) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n5;
            nArray2[i4] = n5 = nArray[i4] + 1;
            if (n5 == 0) continue;
            while (i4 < n4) {
                nArray2[i4] = nArray[i4];
                ++i4;
            }
            return 0;
        }
        return 1;
    }

    public static int incAt(int n4, int[] nArray, int n5) {
        int n6 = n5;
        while (n6 < n4) {
            int n7 = n6++;
            nArray[n7] = nArray[n7] + 1;
            if (nArray[n7] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int incAt(int n4, int[] nArray, int n5, int n6) {
        for (int i4 = n6; i4 < n4; ++i4) {
            int n7 = n5 + i4;
            nArray[n7] = nArray[n7] + 1;
            if (nArray[n7] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static boolean isOne(int n4, int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int i4 = 1; i4 < n4; ++i4) {
            if (nArray[i4] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int n4, int[] nArray) {
        for (int i4 = 0; i4 < n4; ++i4) {
            if (nArray[i4] == 0) continue;
            return false;
        }
        return true;
    }

    public static void mul(int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        nArray3[n4] = Nat.mulWord(n4, nArray[0], nArray2, nArray3);
        for (int i4 = 1; i4 < n4; ++i4) {
            nArray3[i4 + n4] = Nat.mulWordAddTo(n4, nArray[i4], nArray2, 0, nArray3, i4);
        }
    }

    public static void mul(int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7) {
        nArray3[n7 + n4] = Nat.mulWord(n4, nArray[n5], nArray2, n6, nArray3, n7);
        for (int i4 = 1; i4 < n4; ++i4) {
            nArray3[n7 + i4 + n4] = Nat.mulWordAddTo(n4, nArray[n5 + i4], nArray2, n6, nArray3, n7 + i4);
        }
    }

    public static int mulAddTo(int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            long l5 = (long)Nat.mulWordAddTo(n4, nArray[i4], nArray2, 0, nArray3, i4) & 0xFFFFFFFFL;
            nArray3[i4 + n4] = (int)(l5 += l4 + ((long)nArray3[i4 + n4] & 0xFFFFFFFFL));
            l4 = l5 >>> 32;
        }
        return (int)l4;
    }

    public static int mulAddTo(int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            long l5 = (long)Nat.mulWordAddTo(n4, nArray[n5 + i4], nArray2, n6, nArray3, n7) & 0xFFFFFFFFL;
            nArray3[n7 + n4] = (int)(l5 += l4 + ((long)nArray3[n7 + n4] & 0xFFFFFFFFL));
            l4 = l5 >>> 32;
            ++n7;
        }
        return (int)l4;
    }

    public static int mul31BothAdd(int n4, int n5, int[] nArray, int n6, int[] nArray2, int[] nArray3, int n7) {
        long l4 = 0L;
        long l5 = (long)n5 & 0xFFFFFFFFL;
        long l6 = (long)n6 & 0xFFFFFFFFL;
        int n8 = 0;
        do {
            nArray3[n7 + n8] = (int)(l4 += l5 * ((long)nArray[n8] & 0xFFFFFFFFL) + l6 * ((long)nArray2[n8] & 0xFFFFFFFFL) + ((long)nArray3[n7 + n8] & 0xFFFFFFFFL));
            l4 >>>= 32;
        } while (++n8 < n4);
        return (int)l4;
    }

    public static int mulWord(int n4, int n5, int[] nArray, int[] nArray2) {
        long l4 = 0L;
        long l5 = (long)n5 & 0xFFFFFFFFL;
        int n6 = 0;
        do {
            nArray2[n6] = (int)(l4 += l5 * ((long)nArray[n6] & 0xFFFFFFFFL));
            l4 >>>= 32;
        } while (++n6 < n4);
        return (int)l4;
    }

    public static int mulWord(int n4, int n5, int[] nArray, int n6, int[] nArray2, int n7) {
        long l4 = 0L;
        long l5 = (long)n5 & 0xFFFFFFFFL;
        int n8 = 0;
        do {
            nArray2[n7 + n8] = (int)(l4 += l5 * ((long)nArray[n6 + n8] & 0xFFFFFFFFL));
            l4 >>>= 32;
        } while (++n8 < n4);
        return (int)l4;
    }

    public static int mulWordAddTo(int n4, int n5, int[] nArray, int n6, int[] nArray2, int n7) {
        long l4 = 0L;
        long l5 = (long)n5 & 0xFFFFFFFFL;
        int n8 = 0;
        do {
            nArray2[n7 + n8] = (int)(l4 += l5 * ((long)nArray[n6 + n8] & 0xFFFFFFFFL) + ((long)nArray2[n7 + n8] & 0xFFFFFFFFL));
            l4 >>>= 32;
        } while (++n8 < n4);
        return (int)l4;
    }

    public static int mulWordDwordAddAt(int n4, int n5, long l4, int[] nArray, int n6) {
        long l5 = 0L;
        long l6 = (long)n5 & 0xFFFFFFFFL;
        nArray[n6 + 0] = (int)(l5 += l6 * (l4 & 0xFFFFFFFFL) + ((long)nArray[n6 + 0] & 0xFFFFFFFFL));
        l5 >>>= 32;
        nArray[n6 + 1] = (int)(l5 += l6 * (l4 >>> 32) + ((long)nArray[n6 + 1] & 0xFFFFFFFFL));
        l5 >>>= 32;
        nArray[n6 + 2] = (int)(l5 += (long)nArray[n6 + 2] & 0xFFFFFFFFL);
        return (l5 >>>= 32) == 0L ? 0 : Nat.incAt(n4, nArray, n6 + 3);
    }

    public static int shiftDownBit(int n4, int[] nArray, int n5) {
        int n6 = n4;
        while (--n6 >= 0) {
            int n7 = nArray[n6];
            nArray[n6] = n7 >>> 1 | n5 << 31;
            n5 = n7;
        }
        return n5 << 31;
    }

    public static int shiftDownBit(int n4, int[] nArray, int n5, int n6) {
        int n7 = n4;
        while (--n7 >= 0) {
            int n8 = nArray[n5 + n7];
            nArray[n5 + n7] = n8 >>> 1 | n6 << 31;
            n6 = n8;
        }
        return n6 << 31;
    }

    public static int shiftDownBit(int n4, int[] nArray, int n5, int[] nArray2) {
        int n6 = n4;
        while (--n6 >= 0) {
            int n7 = nArray[n6];
            nArray2[n6] = n7 >>> 1 | n5 << 31;
            n5 = n7;
        }
        return n5 << 31;
    }

    public static int shiftDownBit(int n4, int[] nArray, int n5, int n6, int[] nArray2, int n7) {
        int n8 = n4;
        while (--n8 >= 0) {
            int n9 = nArray[n5 + n8];
            nArray2[n7 + n8] = n9 >>> 1 | n6 << 31;
            n6 = n9;
        }
        return n6 << 31;
    }

    public static int shiftDownBits(int n4, int[] nArray, int n5, int n6) {
        int n7 = n4;
        while (--n7 >= 0) {
            int n8 = nArray[n7];
            nArray[n7] = n8 >>> n5 | n6 << -n5;
            n6 = n8;
        }
        return n6 << -n5;
    }

    public static int shiftDownBits(int n4, int[] nArray, int n5, int n6, int n7) {
        int n8 = n4;
        while (--n8 >= 0) {
            int n9 = nArray[n5 + n8];
            nArray[n5 + n8] = n9 >>> n6 | n7 << -n6;
            n7 = n9;
        }
        return n7 << -n6;
    }

    public static int shiftDownBits(int n4, int[] nArray, int n5, int n6, int[] nArray2) {
        int n7 = n4;
        while (--n7 >= 0) {
            int n8 = nArray[n7];
            nArray2[n7] = n8 >>> n5 | n6 << -n5;
            n6 = n8;
        }
        return n6 << -n5;
    }

    public static int shiftDownBits(int n4, int[] nArray, int n5, int n6, int n7, int[] nArray2, int n8) {
        int n9 = n4;
        while (--n9 >= 0) {
            int n10 = nArray[n5 + n9];
            nArray2[n8 + n9] = n10 >>> n6 | n7 << -n6;
            n7 = n10;
        }
        return n7 << -n6;
    }

    public static int shiftDownWord(int n4, int[] nArray, int n5) {
        int n6 = n4;
        while (--n6 >= 0) {
            int n7 = nArray[n6];
            nArray[n6] = n5;
            n5 = n7;
        }
        return n5;
    }

    public static int shiftUpBit(int n4, int[] nArray, int n5) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n6 = nArray[i4];
            nArray[i4] = n6 << 1 | n5 >>> 31;
            n5 = n6;
        }
        return n5 >>> 31;
    }

    public static int shiftUpBit(int n4, int[] nArray, int n5, int n6) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n7 = nArray[n5 + i4];
            nArray[n5 + i4] = n7 << 1 | n6 >>> 31;
            n6 = n7;
        }
        return n6 >>> 31;
    }

    public static int shiftUpBit(int n4, int[] nArray, int n5, int[] nArray2) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n6 = nArray[i4];
            nArray2[i4] = n6 << 1 | n5 >>> 31;
            n5 = n6;
        }
        return n5 >>> 31;
    }

    public static int shiftUpBit(int n4, int[] nArray, int n5, int n6, int[] nArray2, int n7) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n8 = nArray[n5 + i4];
            nArray2[n7 + i4] = n8 << 1 | n6 >>> 31;
            n6 = n8;
        }
        return n6 >>> 31;
    }

    public static long shiftUpBit64(int n4, long[] lArray, int n5, long l4, long[] lArray2, int n6) {
        for (int i4 = 0; i4 < n4; ++i4) {
            long l5 = lArray[n5 + i4];
            lArray2[n6 + i4] = l5 << 1 | l4 >>> 63;
            l4 = l5;
        }
        return l4 >>> 63;
    }

    public static int shiftUpBits(int n4, int[] nArray, int n5, int n6) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n7 = nArray[i4];
            nArray[i4] = n7 << n5 | n6 >>> -n5;
            n6 = n7;
        }
        return n6 >>> -n5;
    }

    public static int shiftUpBits(int n4, int[] nArray, int n5, int n6, int n7) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n8 = nArray[n5 + i4];
            nArray[n5 + i4] = n8 << n6 | n7 >>> -n6;
            n7 = n8;
        }
        return n7 >>> -n6;
    }

    public static long shiftUpBits64(int n4, long[] lArray, int n5, int n6, long l4) {
        for (int i4 = 0; i4 < n4; ++i4) {
            long l5 = lArray[n5 + i4];
            lArray[n5 + i4] = l5 << n6 | l4 >>> -n6;
            l4 = l5;
        }
        return l4 >>> -n6;
    }

    public static int shiftUpBits(int n4, int[] nArray, int n5, int n6, int[] nArray2) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n7 = nArray[i4];
            nArray2[i4] = n7 << n5 | n6 >>> -n5;
            n6 = n7;
        }
        return n6 >>> -n5;
    }

    public static int shiftUpBits(int n4, int[] nArray, int n5, int n6, int n7, int[] nArray2, int n8) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n9 = nArray[n5 + i4];
            nArray2[n8 + i4] = n9 << n6 | n7 >>> -n6;
            n7 = n9;
        }
        return n7 >>> -n6;
    }

    public static long shiftUpBits64(int n4, long[] lArray, int n5, int n6, long l4, long[] lArray2, int n7) {
        for (int i4 = 0; i4 < n4; ++i4) {
            long l5 = lArray[n5 + i4];
            lArray2[n7 + i4] = l5 << n6 | l4 >>> -n6;
            l4 = l5;
        }
        return l4 >>> -n6;
    }

    public static void square(int n4, int[] nArray, int[] nArray2) {
        int n5 = n4 << 1;
        int n6 = 0;
        int n7 = n4;
        int n8 = n5;
        do {
            long l4 = (long)nArray[--n7] & 0xFFFFFFFFL;
            long l5 = l4 * l4;
            nArray2[--n8] = n6 << 31 | (int)(l5 >>> 33);
            nArray2[--n8] = (int)(l5 >>> 1);
            n6 = (int)l5;
        } while (n7 > 0);
        for (int i4 = 1; i4 < n4; ++i4) {
            n6 = Nat.squareWordAdd(nArray, i4, nArray2);
            Nat.addWordAt(n5, n6, nArray2, i4 << 1);
        }
        Nat.shiftUpBit(n5, nArray2, nArray[0] << 31);
    }

    public static void square(int n4, int[] nArray, int n5, int[] nArray2, int n6) {
        int n7 = n4 << 1;
        int n8 = 0;
        int n9 = n4;
        int n10 = n7;
        do {
            long l4 = (long)nArray[n5 + --n9] & 0xFFFFFFFFL;
            long l5 = l4 * l4;
            nArray2[n6 + --n10] = n8 << 31 | (int)(l5 >>> 33);
            nArray2[n6 + --n10] = (int)(l5 >>> 1);
            n8 = (int)l5;
        } while (n9 > 0);
        for (int i4 = 1; i4 < n4; ++i4) {
            n8 = Nat.squareWordAdd(nArray, n5, i4, nArray2, n6);
            Nat.addWordAt(n7, n8, nArray2, n6, i4 << 1);
        }
        Nat.shiftUpBit(n7, nArray2, n6, nArray[n5] << 31);
    }

    public static int squareWordAdd(int[] nArray, int n4, int[] nArray2) {
        long l4 = 0L;
        long l5 = (long)nArray[n4] & 0xFFFFFFFFL;
        int n5 = 0;
        do {
            nArray2[n4 + n5] = (int)(l4 += l5 * ((long)nArray[n5] & 0xFFFFFFFFL) + ((long)nArray2[n4 + n5] & 0xFFFFFFFFL));
            l4 >>>= 32;
        } while (++n5 < n4);
        return (int)l4;
    }

    public static int squareWordAdd(int[] nArray, int n4, int n5, int[] nArray2, int n6) {
        long l4 = 0L;
        long l5 = (long)nArray[n4 + n5] & 0xFFFFFFFFL;
        int n7 = 0;
        do {
            nArray2[n5 + n6] = (int)(l4 += l5 * ((long)nArray[n4 + n7] & 0xFFFFFFFFL) + ((long)nArray2[n5 + n6] & 0xFFFFFFFFL));
            l4 >>>= 32;
            ++n6;
        } while (++n7 < n5);
        return (int)l4;
    }

    public static int sub(int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray3[i4] = (int)(l4 += ((long)nArray[i4] & 0xFFFFFFFFL) - ((long)nArray2[i4] & 0xFFFFFFFFL));
            l4 >>= 32;
        }
        return (int)l4;
    }

    public static int sub(int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray3[n7 + i4] = (int)(l4 += ((long)nArray[n5 + i4] & 0xFFFFFFFFL) - ((long)nArray2[n6 + i4] & 0xFFFFFFFFL));
            l4 >>= 32;
        }
        return (int)l4;
    }

    public static int sub33At(int n4, int n5, int[] nArray, int n6) {
        long l4 = ((long)nArray[n6 + 0] & 0xFFFFFFFFL) - ((long)n5 & 0xFFFFFFFFL);
        nArray[n6 + 0] = (int)l4;
        l4 >>= 32;
        nArray[n6 + 1] = (int)(l4 += ((long)nArray[n6 + 1] & 0xFFFFFFFFL) - 1L);
        return (l4 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, n6 + 2);
    }

    public static int sub33At(int n4, int n5, int[] nArray, int n6, int n7) {
        long l4 = ((long)nArray[n6 + n7] & 0xFFFFFFFFL) - ((long)n5 & 0xFFFFFFFFL);
        nArray[n6 + n7] = (int)l4;
        l4 >>= 32;
        nArray[n6 + n7 + 1] = (int)(l4 += ((long)nArray[n6 + n7 + 1] & 0xFFFFFFFFL) - 1L);
        return (l4 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, n6, n7 + 2);
    }

    public static int sub33From(int n4, int n5, int[] nArray) {
        long l4 = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)n5 & 0xFFFFFFFFL);
        nArray[0] = (int)l4;
        l4 >>= 32;
        nArray[1] = (int)(l4 += ((long)nArray[1] & 0xFFFFFFFFL) - 1L);
        return (l4 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, 2);
    }

    public static int sub33From(int n4, int n5, int[] nArray, int n6) {
        long l4 = ((long)nArray[n6 + 0] & 0xFFFFFFFFL) - ((long)n5 & 0xFFFFFFFFL);
        nArray[n6 + 0] = (int)l4;
        l4 >>= 32;
        nArray[n6 + 1] = (int)(l4 += ((long)nArray[n6 + 1] & 0xFFFFFFFFL) - 1L);
        return (l4 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, n6, 2);
    }

    public static int subBothFrom(int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray3[i4] = (int)(l4 += ((long)nArray3[i4] & 0xFFFFFFFFL) - ((long)nArray[i4] & 0xFFFFFFFFL) - ((long)nArray2[i4] & 0xFFFFFFFFL));
            l4 >>= 32;
        }
        return (int)l4;
    }

    public static int subBothFrom(int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray3[n7 + i4] = (int)(l4 += ((long)nArray3[n7 + i4] & 0xFFFFFFFFL) - ((long)nArray[n5 + i4] & 0xFFFFFFFFL) - ((long)nArray2[n6 + i4] & 0xFFFFFFFFL));
            l4 >>= 32;
        }
        return (int)l4;
    }

    public static int subDWordAt(int n4, long l4, int[] nArray, int n5) {
        long l5 = ((long)nArray[n5 + 0] & 0xFFFFFFFFL) - (l4 & 0xFFFFFFFFL);
        nArray[n5 + 0] = (int)l5;
        l5 >>= 32;
        nArray[n5 + 1] = (int)(l5 += ((long)nArray[n5 + 1] & 0xFFFFFFFFL) - (l4 >>> 32));
        return (l5 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, n5 + 2);
    }

    public static int subDWordAt(int n4, long l4, int[] nArray, int n5, int n6) {
        long l5 = ((long)nArray[n5 + n6] & 0xFFFFFFFFL) - (l4 & 0xFFFFFFFFL);
        nArray[n5 + n6] = (int)l5;
        l5 >>= 32;
        nArray[n5 + n6 + 1] = (int)(l5 += ((long)nArray[n5 + n6 + 1] & 0xFFFFFFFFL) - (l4 >>> 32));
        return (l5 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, n5, n6 + 2);
    }

    public static int subDWordFrom(int n4, long l4, int[] nArray) {
        long l5 = ((long)nArray[0] & 0xFFFFFFFFL) - (l4 & 0xFFFFFFFFL);
        nArray[0] = (int)l5;
        l5 >>= 32;
        nArray[1] = (int)(l5 += ((long)nArray[1] & 0xFFFFFFFFL) - (l4 >>> 32));
        return (l5 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, 2);
    }

    public static int subDWordFrom(int n4, long l4, int[] nArray, int n5) {
        long l5 = ((long)nArray[n5 + 0] & 0xFFFFFFFFL) - (l4 & 0xFFFFFFFFL);
        nArray[n5 + 0] = (int)l5;
        l5 >>= 32;
        nArray[n5 + 1] = (int)(l5 += ((long)nArray[n5 + 1] & 0xFFFFFFFFL) - (l4 >>> 32));
        return (l5 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, n5, 2);
    }

    public static int subFrom(int n4, int[] nArray, int[] nArray2) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray2[i4] = (int)(l4 += ((long)nArray2[i4] & 0xFFFFFFFFL) - ((long)nArray[i4] & 0xFFFFFFFFL));
            l4 >>= 32;
        }
        return (int)l4;
    }

    public static int subFrom(int n4, int[] nArray, int n5, int[] nArray2, int n6) {
        long l4 = 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray2[n6 + i4] = (int)(l4 += ((long)nArray2[n6 + i4] & 0xFFFFFFFFL) - ((long)nArray[n5 + i4] & 0xFFFFFFFFL));
            l4 >>= 32;
        }
        return (int)l4;
    }

    public static int subWordAt(int n4, int n5, int[] nArray, int n6) {
        long l4 = ((long)nArray[n6] & 0xFFFFFFFFL) - ((long)n5 & 0xFFFFFFFFL);
        nArray[n6] = (int)l4;
        return (l4 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, n6 + 1);
    }

    public static int subWordAt(int n4, int n5, int[] nArray, int n6, int n7) {
        long l4 = ((long)nArray[n6 + n7] & 0xFFFFFFFFL) - ((long)n5 & 0xFFFFFFFFL);
        nArray[n6 + n7] = (int)l4;
        return (l4 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, n6, n7 + 1);
    }

    public static int subWordFrom(int n4, int n5, int[] nArray) {
        long l4 = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)n5 & 0xFFFFFFFFL);
        nArray[0] = (int)l4;
        return (l4 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, 1);
    }

    public static int subWordFrom(int n4, int n5, int[] nArray, int n6) {
        long l4 = ((long)nArray[n6 + 0] & 0xFFFFFFFFL) - ((long)n5 & 0xFFFFFFFFL);
        nArray[n6 + 0] = (int)l4;
        return (l4 >>= 32) == 0L ? 0 : Nat.decAt(n4, nArray, n6, 1);
    }

    public static BigInteger toBigInteger(int n4, int[] nArray) {
        byte[] byArray = new byte[n4 << 2];
        for (int i4 = 0; i4 < n4; ++i4) {
            int n5 = nArray[i4];
            if (n5 == 0) continue;
            Pack.intToBigEndian(n5, byArray, n4 - 1 - i4 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int n4, int[] nArray) {
        for (int i4 = 0; i4 < n4; ++i4) {
            nArray[i4] = 0;
        }
    }
}

