/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECMultiplier;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.WNafUtil;

public class MixedNafR2LMultiplier
extends AbstractECMultiplier {
    protected int additionCoord;
    protected int doublingCoord;

    public MixedNafR2LMultiplier() {
        this(2, 4);
    }

    public MixedNafR2LMultiplier(int n4, int n5) {
        this.additionCoord = n4;
        this.doublingCoord = n5;
    }

    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECCurve eCCurve = eCPoint.getCurve();
        ECCurve eCCurve2 = this.configureCurve(eCCurve, this.additionCoord);
        ECCurve eCCurve3 = this.configureCurve(eCCurve, this.doublingCoord);
        int[] nArray = WNafUtil.generateCompactNaf(bigInteger);
        ECPoint eCPoint2 = eCCurve2.getInfinity();
        ECPoint eCPoint3 = eCCurve3.importPoint(eCPoint);
        int n4 = 0;
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            int n5 = nArray[i4];
            int n6 = n5 >> 16;
            eCPoint3 = eCPoint3.timesPow2(n4 += n5 & 0xFFFF);
            ECPoint eCPoint4 = eCCurve2.importPoint(eCPoint3);
            if (n6 < 0) {
                eCPoint4 = eCPoint4.negate();
            }
            eCPoint2 = eCPoint2.add(eCPoint4);
            n4 = 1;
        }
        return eCCurve.importPoint(eCPoint2);
    }

    protected ECCurve configureCurve(ECCurve eCCurve, int n4) {
        if (eCCurve.getCoordinateSystem() == n4) {
            return eCCurve;
        }
        if (!eCCurve.supportsCoordinateSystem(n4)) {
            throw new IllegalArgumentException("Coordinate system " + n4 + " not supported by this curve");
        }
        return eCCurve.configure().setCoordinateSystem(n4).create();
    }
}

