/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jcajce.PKIXExtendedBuilderParameters;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jcajce.util.BCJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jce.exception.ExtCertPathValidatorException;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jce.provider.PKIXNameConstraintValidator;
import org.bouncycastle.jce.provider.PKIXPolicyNode;
import org.bouncycastle.jce.provider.PrincipalUtils;
import org.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import org.bouncycastle.x509.ExtendedPKIXParameters;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private final JcaJceHelper helper = new BCJcaJceHelper();

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        PublicKey publicKey;
        X500Name x500Name;
        TrustAnchor trustAnchor;
        PKIXExtendedParameters pKIXExtendedParameters;
        Object object;
        if (certPathParameters instanceof PKIXParameters) {
            object = new PKIXExtendedParameters.Builder((PKIXParameters)certPathParameters);
            if (certPathParameters instanceof ExtendedPKIXParameters) {
                ExtendedPKIXParameters extendedPKIXParameters = (ExtendedPKIXParameters)certPathParameters;
                ((PKIXExtendedParameters.Builder)object).setUseDeltasEnabled(extendedPKIXParameters.isUseDeltasEnabled());
                ((PKIXExtendedParameters.Builder)object).setValidityModel(extendedPKIXParameters.getValidityModel());
            }
            pKIXExtendedParameters = ((PKIXExtendedParameters.Builder)object).build();
        } else if (certPathParameters instanceof PKIXExtendedBuilderParameters) {
            pKIXExtendedParameters = ((PKIXExtendedBuilderParameters)certPathParameters).getBaseParameters();
        } else if (certPathParameters instanceof PKIXExtendedParameters) {
            pKIXExtendedParameters = (PKIXExtendedParameters)certPathParameters;
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be a " + PKIXParameters.class.getName() + " instance.");
        }
        if (pKIXExtendedParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        object = certPath.getCertificates();
        int n4 = object.size();
        if (object.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = pKIXExtendedParameters.getInitialPolicies();
        try {
            trustAnchor = CertPathValidatorUtilities.findTrustAnchor((X509Certificate)object.get(object.size() - 1), pKIXExtendedParameters.getTrustAnchors(), pKIXExtendedParameters.getSigProvider());
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException(annotatedException.getMessage(), (Throwable)annotatedException, certPath, object.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        pKIXExtendedParameters = new PKIXExtendedParameters.Builder(pKIXExtendedParameters).setTrustAnchor(trustAnchor).build();
        int n5 = 0;
        List[] listArray = new ArrayList[n4 + 1];
        for (int i4 = 0; i4 < listArray.length; ++i4) {
            listArray[i4] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(pKIXPolicyNode);
        PKIXNameConstraintValidator pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
        HashSet hashSet3 = new HashSet();
        int n6 = pKIXExtendedParameters.isExplicitPolicyRequired() ? 0 : n4 + 1;
        int n7 = pKIXExtendedParameters.isAnyPolicyInhibited() ? 0 : n4 + 1;
        int n8 = pKIXExtendedParameters.isPolicyMappingInhibited() ? 0 : n4 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Name = PrincipalUtils.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Name = PrincipalUtils.getCA(trustAnchor);
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExtCertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        AlgorithmIdentifier algorithmIdentifier = null;
        try {
            algorithmIdentifier = CertPathValidatorUtilities.getAlgorithmIdentifier(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new ExtCertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        int n9 = n4;
        if (pKIXExtendedParameters.getTargetConstraints() != null && !pKIXExtendedParameters.getTargetConstraints().match((X509Certificate)object.get(0))) {
            throw new ExtCertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list2 = pKIXExtendedParameters.getCertPathCheckers();
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            ((PKIXCertPathChecker)iterator2.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n5 = object.size() - 1; n5 >= 0; --n5) {
            int n10 = n4 - n5;
            x509Certificate2 = (X509Certificate)object.get(n5);
            boolean bl = n5 == object.size() - 1;
            RFC3280CertPathUtilities.processCertA(certPath, pKIXExtendedParameters, n5, publicKey, bl, x500Name, x509Certificate, this.helper);
            RFC3280CertPathUtilities.processCertBC(certPath, n5, pKIXNameConstraintValidator);
            pKIXPolicyNode = RFC3280CertPathUtilities.processCertD(certPath, n5, hashSet3, pKIXPolicyNode, listArray, n7);
            pKIXPolicyNode = RFC3280CertPathUtilities.processCertE(certPath, n5, pKIXPolicyNode);
            RFC3280CertPathUtilities.processCertF(certPath, n5, pKIXPolicyNode, n6);
            if (n10 == n4) continue;
            if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n5);
            }
            RFC3280CertPathUtilities.prepareNextCertA(certPath, n5);
            pKIXPolicyNode = RFC3280CertPathUtilities.prepareCertB(certPath, n5, listArray, pKIXPolicyNode, n8);
            RFC3280CertPathUtilities.prepareNextCertG(certPath, n5, pKIXNameConstraintValidator);
            n6 = RFC3280CertPathUtilities.prepareNextCertH1(certPath, n5, n6);
            n8 = RFC3280CertPathUtilities.prepareNextCertH2(certPath, n5, n8);
            n7 = RFC3280CertPathUtilities.prepareNextCertH3(certPath, n5, n7);
            n6 = RFC3280CertPathUtilities.prepareNextCertI1(certPath, n5, n6);
            n8 = RFC3280CertPathUtilities.prepareNextCertI2(certPath, n5, n8);
            n7 = RFC3280CertPathUtilities.prepareNextCertJ(certPath, n5, n7);
            RFC3280CertPathUtilities.prepareNextCertK(certPath, n5);
            n9 = RFC3280CertPathUtilities.prepareNextCertL(certPath, n5, n9);
            n9 = RFC3280CertPathUtilities.prepareNextCertM(certPath, n5, n9);
            RFC3280CertPathUtilities.prepareNextCertN(certPath, n5);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.remove(RFC3280CertPathUtilities.KEY_USAGE);
                hashSet.remove(RFC3280CertPathUtilities.CERTIFICATE_POLICIES);
                hashSet.remove(RFC3280CertPathUtilities.POLICY_MAPPINGS);
                hashSet.remove(RFC3280CertPathUtilities.INHIBIT_ANY_POLICY);
                hashSet.remove(RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT);
                hashSet.remove(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
                hashSet.remove(RFC3280CertPathUtilities.POLICY_CONSTRAINTS);
                hashSet.remove(RFC3280CertPathUtilities.BASIC_CONSTRAINTS);
                hashSet.remove(RFC3280CertPathUtilities.SUBJECT_ALTERNATIVE_NAME);
                hashSet.remove(RFC3280CertPathUtilities.NAME_CONSTRAINTS);
            } else {
                hashSet = new HashSet();
            }
            RFC3280CertPathUtilities.prepareNextCertO(certPath, n5, hashSet, list2);
            x509Certificate = x509Certificate2;
            x500Name = PrincipalUtils.getSubjectPrincipal(x509Certificate);
            try {
                publicKey = CertPathValidatorUtilities.getNextWorkingKey(certPath.getCertificates(), n5, this.helper);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n5);
            }
            algorithmIdentifier = CertPathValidatorUtilities.getAlgorithmIdentifier(publicKey);
            aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
            aSN1Encodable = algorithmIdentifier.getParameters();
        }
        n6 = RFC3280CertPathUtilities.wrapupCertA(n6, x509Certificate2);
        n6 = RFC3280CertPathUtilities.wrapupCertB(certPath, n5 + 1, n6);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.remove(RFC3280CertPathUtilities.KEY_USAGE);
            set2.remove(RFC3280CertPathUtilities.CERTIFICATE_POLICIES);
            set2.remove(RFC3280CertPathUtilities.POLICY_MAPPINGS);
            set2.remove(RFC3280CertPathUtilities.INHIBIT_ANY_POLICY);
            set2.remove(RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT);
            set2.remove(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
            set2.remove(RFC3280CertPathUtilities.POLICY_CONSTRAINTS);
            set2.remove(RFC3280CertPathUtilities.BASIC_CONSTRAINTS);
            set2.remove(RFC3280CertPathUtilities.SUBJECT_ALTERNATIVE_NAME);
            set2.remove(RFC3280CertPathUtilities.NAME_CONSTRAINTS);
            set2.remove(RFC3280CertPathUtilities.CRL_DISTRIBUTION_POINTS);
            set2.remove(Extension.extendedKeyUsage.getId());
        } else {
            set2 = new HashSet<String>();
        }
        RFC3280CertPathUtilities.wrapupCertF(certPath, n5 + 1, list2, set2);
        hashSet = RFC3280CertPathUtilities.wrapupCertG(certPath, pKIXExtendedParameters, set, n5 + 1, listArray, pKIXPolicyNode, hashSet3);
        if (n6 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n5);
    }
}

