/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

class OldPKCS12ParametersGenerator
extends PBEParametersGenerator {
    public static final int KEY_MATERIAL = 1;
    public static final int IV_MATERIAL = 2;
    public static final int MAC_MATERIAL = 3;
    private Digest digest;
    private int u;
    private int v;

    public OldPKCS12ParametersGenerator(Digest digest) {
        this.digest = digest;
        if (digest instanceof MD5Digest) {
            this.u = 16;
            this.v = 64;
        } else if (digest instanceof SHA1Digest) {
            this.u = 20;
            this.v = 64;
        } else if (digest instanceof RIPEMD160Digest) {
            this.u = 20;
            this.v = 64;
        } else {
            throw new IllegalArgumentException("Digest " + digest.getAlgorithmName() + " unsupported");
        }
    }

    private void adjust(byte[] byArray, int n4, byte[] byArray2) {
        int n5 = (byArray2[byArray2.length - 1] & 0xFF) + (byArray[n4 + byArray2.length - 1] & 0xFF) + 1;
        byArray[n4 + byArray2.length - 1] = (byte)n5;
        n5 >>>= 8;
        for (int i4 = byArray2.length - 2; i4 >= 0; --i4) {
            byArray[n4 + i4] = (byte)(n5 += (byArray2[i4] & 0xFF) + (byArray[n4 + i4] & 0xFF));
            n5 >>>= 8;
        }
    }

    private byte[] generateDerivedKey(int n4, int n5) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = new byte[this.v];
        byte[] byArray4 = new byte[n5];
        for (int i4 = 0; i4 != byArray3.length; ++i4) {
            byArray3[i4] = (byte)n4;
        }
        if (this.salt != null && this.salt.length != 0) {
            byArray2 = new byte[this.v * ((this.salt.length + this.v - 1) / this.v)];
            for (int i5 = 0; i5 != byArray2.length; ++i5) {
                byArray2[i5] = this.salt[i5 % this.salt.length];
            }
        } else {
            byArray2 = new byte[]{};
        }
        if (this.password != null && this.password.length != 0) {
            byArray = new byte[this.v * ((this.password.length + this.v - 1) / this.v)];
            for (int i6 = 0; i6 != byArray.length; ++i6) {
                byArray[i6] = this.password[i6 % this.password.length];
            }
        } else {
            byArray = new byte[]{};
        }
        byte[] byArray5 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray5, byArray2.length, byArray.length);
        byte[] byArray6 = new byte[this.v];
        int n6 = (n5 + this.u - 1) / this.u;
        for (int i7 = 1; i7 <= n6; ++i7) {
            int n7;
            byte[] byArray7 = new byte[this.u];
            this.digest.update(byArray3, 0, byArray3.length);
            this.digest.update(byArray5, 0, byArray5.length);
            this.digest.doFinal(byArray7, 0);
            for (n7 = 1; n7 != this.iterationCount; ++n7) {
                this.digest.update(byArray7, 0, byArray7.length);
                this.digest.doFinal(byArray7, 0);
            }
            for (n7 = 0; n7 != byArray6.length; ++n7) {
                byArray6[i7] = byArray7[n7 % byArray7.length];
            }
            for (n7 = 0; n7 != byArray5.length / this.v; ++n7) {
                this.adjust(byArray5, n7 * this.v, byArray6);
            }
            if (i7 == n6) {
                System.arraycopy(byArray7, 0, byArray4, (i7 - 1) * this.u, byArray4.length - (i7 - 1) * this.u);
                continue;
            }
            System.arraycopy(byArray7, 0, byArray4, (i7 - 1) * this.u, byArray7.length);
        }
        return byArray4;
    }

    public CipherParameters generateDerivedParameters(int n4) {
        byte[] byArray = this.generateDerivedKey(1, n4 /= 8);
        return new KeyParameter(byArray, 0, n4);
    }

    public CipherParameters generateDerivedParameters(int n4, int n5) {
        byte[] byArray = this.generateDerivedKey(1, n4 /= 8);
        byte[] byArray2 = this.generateDerivedKey(2, n5 /= 8);
        return new ParametersWithIV(new KeyParameter(byArray, 0, n4), byArray2, 0, n5);
    }

    public CipherParameters generateDerivedMacParameters(int n4) {
        byte[] byArray = this.generateDerivedKey(3, n4 /= 8);
        return new KeyParameter(byArray, 0, n4);
    }
}

