/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsNullCipher
implements TlsCipher {
    protected TlsContext context;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsNullCipher(TlsContext tlsContext) {
        this.context = tlsContext;
        this.writeMac = null;
        this.readMac = null;
    }

    public TlsNullCipher(TlsContext tlsContext, Digest digest, Digest digest2) throws IOException {
        if (digest == null != (digest2 == null)) {
            throw new TlsFatalAlert(80);
        }
        this.context = tlsContext;
        TlsMac tlsMac = null;
        TlsMac tlsMac2 = null;
        if (digest != null) {
            int n4 = digest.getDigestSize() + digest2.getDigestSize();
            byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, n4);
            int n5 = 0;
            tlsMac = new TlsMac(tlsContext, digest, byArray, n5, digest.getDigestSize());
            tlsMac2 = new TlsMac(tlsContext, digest2, byArray, n5 += digest.getDigestSize(), digest2.getDigestSize());
            if ((n5 += digest2.getDigestSize()) != n4) {
                throw new TlsFatalAlert(80);
            }
        }
        if (tlsContext.isServer()) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
        }
    }

    public int getPlaintextLimit(int n4) {
        int n5 = n4;
        if (this.writeMac != null) {
            n5 -= this.writeMac.getSize();
        }
        return n5;
    }

    public byte[] encodePlaintext(long l4, short s4, byte[] byArray, int n4, int n5) throws IOException {
        if (this.writeMac == null) {
            return Arrays.copyOfRange(byArray, n4, n4 + n5);
        }
        byte[] byArray2 = this.writeMac.calculateMac(l4, s4, byArray, n4, n5);
        byte[] byArray3 = new byte[n5 + byArray2.length];
        System.arraycopy(byArray, n4, byArray3, 0, n5);
        System.arraycopy(byArray2, 0, byArray3, n5, byArray2.length);
        return byArray3;
    }

    public byte[] decodeCiphertext(long l4, short s4, byte[] byArray, int n4, int n5) throws IOException {
        byte[] byArray2;
        if (this.readMac == null) {
            return Arrays.copyOfRange(byArray, n4, n4 + n5);
        }
        int n6 = this.readMac.getSize();
        if (n5 < n6) {
            throw new TlsFatalAlert(50);
        }
        int n7 = n5 - n6;
        byte[] byArray3 = Arrays.copyOfRange(byArray, n4 + n7, n4 + n5);
        if (!Arrays.constantTimeAreEqual(byArray3, byArray2 = this.readMac.calculateMac(l4, s4, byArray, n4, n7))) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(byArray, n4, n4 + n7);
    }
}

