/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.ChaCha7539Engine;
import org.bouncycastle.crypto.macs.Poly1305;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class Chacha20Poly1305
implements TlsCipher {
    private static final byte[] ZEROES = new byte[15];
    protected TlsContext context;
    protected ChaCha7539Engine encryptCipher;
    protected ChaCha7539Engine decryptCipher;
    protected byte[] encryptIV;
    protected byte[] decryptIV;

    public Chacha20Poly1305(TlsContext tlsContext) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        if (!TlsUtils.isTLSv12(tlsContext)) {
            throw new TlsFatalAlert(80);
        }
        this.context = tlsContext;
        int n4 = 32;
        int n5 = 12;
        int n6 = 2 * n4 + 2 * n5;
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, n6);
        int n7 = 0;
        KeyParameter keyParameter3 = new KeyParameter(byArray, n7, n4);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n7 += n4, n4);
        byte[] byArray2 = Arrays.copyOfRange(byArray, n7 += n4, n7 + n5);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n7 += n5, n7 + n5);
        if ((n7 += n5) != n6) {
            throw new TlsFatalAlert(80);
        }
        this.encryptCipher = new ChaCha7539Engine();
        this.decryptCipher = new ChaCha7539Engine();
        if (tlsContext.isServer()) {
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
            this.encryptIV = byArray3;
            this.decryptIV = byArray2;
        } else {
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
            this.encryptIV = byArray2;
            this.decryptIV = byArray3;
        }
        this.encryptCipher.init(true, new ParametersWithIV(keyParameter2, this.encryptIV));
        this.decryptCipher.init(false, new ParametersWithIV(keyParameter, this.decryptIV));
    }

    public int getPlaintextLimit(int n4) {
        return n4 - 16;
    }

    public byte[] encodePlaintext(long l4, short s4, byte[] byArray, int n4, int n5) throws IOException {
        KeyParameter keyParameter = this.initRecord(this.encryptCipher, true, l4, this.encryptIV);
        byte[] byArray2 = new byte[n5 + 16];
        this.encryptCipher.processBytes(byArray, n4, n5, byArray2, 0);
        byte[] byArray3 = this.getAdditionalData(l4, s4, n5);
        byte[] byArray4 = this.calculateRecordMAC(keyParameter, byArray3, byArray2, 0, n5);
        System.arraycopy(byArray4, 0, byArray2, n5, byArray4.length);
        return byArray2;
    }

    public byte[] decodeCiphertext(long l4, short s4, byte[] byArray, int n4, int n5) throws IOException {
        byte[] byArray2;
        int n6;
        byte[] byArray3;
        if (this.getPlaintextLimit(n5) < 0) {
            throw new TlsFatalAlert(50);
        }
        KeyParameter keyParameter = this.initRecord(this.decryptCipher, false, l4, this.decryptIV);
        byte[] byArray4 = this.calculateRecordMAC(keyParameter, byArray3 = this.getAdditionalData(l4, s4, n6 = n5 - 16), byArray, n4, n6);
        if (!Arrays.constantTimeAreEqual(byArray4, byArray2 = Arrays.copyOfRange(byArray, n4 + n6, n4 + n5))) {
            throw new TlsFatalAlert(20);
        }
        byte[] byArray5 = new byte[n6];
        this.decryptCipher.processBytes(byArray, n4, n6, byArray5, 0);
        return byArray5;
    }

    protected KeyParameter initRecord(StreamCipher streamCipher, boolean bl, long l4, byte[] byArray) {
        byte[] byArray2 = this.calculateNonce(l4, byArray);
        streamCipher.init(bl, new ParametersWithIV(null, byArray2));
        return this.generateRecordMACKey(streamCipher);
    }

    protected byte[] calculateNonce(long l4, byte[] byArray) {
        byte[] byArray2 = new byte[12];
        TlsUtils.writeUint64(l4, byArray2, 4);
        for (int i4 = 0; i4 < 12; ++i4) {
            int n4 = i4;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray[i4]);
        }
        return byArray2;
    }

    protected KeyParameter generateRecordMACKey(StreamCipher streamCipher) {
        byte[] byArray = new byte[64];
        streamCipher.processBytes(byArray, 0, byArray.length, byArray, 0);
        KeyParameter keyParameter = new KeyParameter(byArray, 0, 32);
        Arrays.fill(byArray, (byte)0);
        return keyParameter;
    }

    protected byte[] calculateRecordMAC(KeyParameter keyParameter, byte[] byArray, byte[] byArray2, int n4, int n5) {
        Poly1305 poly1305 = new Poly1305();
        poly1305.init(keyParameter);
        this.updateRecordMACText(poly1305, byArray, 0, byArray.length);
        this.updateRecordMACText(poly1305, byArray2, n4, n5);
        this.updateRecordMACLength(poly1305, byArray.length);
        this.updateRecordMACLength(poly1305, n5);
        byte[] byArray3 = new byte[poly1305.getMacSize()];
        poly1305.doFinal(byArray3, 0);
        return byArray3;
    }

    protected void updateRecordMACLength(Mac mac, int n4) {
        byte[] byArray = Pack.longToLittleEndian((long)n4 & 0xFFFFFFFFL);
        mac.update(byArray, 0, byArray.length);
    }

    protected void updateRecordMACText(Mac mac, byte[] byArray, int n4, int n5) {
        mac.update(byArray, n4, n5);
        int n6 = n5 % 16;
        if (n6 != 0) {
            mac.update(ZEROES, 0, 16 - n6);
        }
    }

    protected byte[] getAdditionalData(long l4, short s4, int n4) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(l4, byArray, 0);
        TlsUtils.writeUint8(s4, byArray, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(n4, byArray, 11);
        return byArray;
    }
}

