/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.paddings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class TBCPadding
implements BlockCipherPadding {
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
    }

    public String getPaddingName() {
        return "TBC";
    }

    public int addPadding(byte[] byArray, int n4) {
        int n5 = byArray.length - n4;
        byte by = n4 > 0 ? (byte)((byArray[n4 - 1] & 1) == 0 ? 255 : 0) : (byte)((byArray[byArray.length - 1] & 1) == 0 ? 255 : 0);
        while (n4 < byArray.length) {
            byArray[n4] = by;
            ++n4;
        }
        return n5;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n4;
        byte by = byArray[byArray.length - 1];
        for (n4 = byArray.length - 1; n4 > 0 && byArray[n4 - 1] == by; --n4) {
        }
        return byArray.length - n4;
    }
}

