/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.bouncycastle.crypto.StreamBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class SICBlockCipher
extends StreamBlockCipher
implements SkippingStreamCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;
    private int byteCount;

    public SICBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.cipher = blockCipher;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
        this.byteCount = 0;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof ParametersWithIV) {
            int n4;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            this.IV = Arrays.clone(parametersWithIV.getIV());
            if (this.blockSize < this.IV.length) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV no greater than: " + this.blockSize + " bytes.");
            }
            int n5 = n4 = 8 > this.blockSize / 2 ? this.blockSize / 2 : 8;
            if (this.blockSize - this.IV.length > n4) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV of at least: " + (this.blockSize - n4) + " bytes.");
            }
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
        }
        this.reset();
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n4, this.blockSize, byArray2, n5);
        return this.blockSize;
    }

    protected byte calculateByte(byte by) throws DataLengthException, IllegalStateException {
        if (this.byteCount == 0) {
            this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
            return (byte)(this.counterOut[this.byteCount++] ^ by);
        }
        byte by2 = (byte)(this.counterOut[this.byteCount++] ^ by);
        if (this.byteCount == this.counter.length) {
            this.byteCount = 0;
            this.incrementCounterAt(0);
            this.checkCounter();
        }
        return by2;
    }

    private void checkCounter() {
        if (this.IV.length < this.blockSize) {
            for (int i4 = 0; i4 != this.IV.length; ++i4) {
                if (this.counter[i4] == this.IV[i4]) continue;
                throw new IllegalStateException("Counter in CTR/SIC mode out of range.");
            }
        }
    }

    private void incrementCounterAt(int n4) {
        int n5 = this.counter.length - n4;
        while (--n5 >= 0) {
            int n6 = n5;
            this.counter[n6] = (byte)(this.counter[n6] + 1);
            if (this.counter[n6] == 0) continue;
            break;
        }
    }

    private void incrementCounter(int n4) {
        byte by = this.counter[this.counter.length - 1];
        int n5 = this.counter.length - 1;
        this.counter[n5] = (byte)(this.counter[n5] + n4);
        if (by != 0 && this.counter[this.counter.length - 1] < by) {
            this.incrementCounterAt(1);
        }
    }

    private void decrementCounterAt(int n4) {
        int n5 = this.counter.length - n4;
        while (--n5 >= 0) {
            int n6 = n5;
            this.counter[n6] = (byte)(this.counter[n6] - 1);
            if (this.counter[n6] == -1) continue;
            return;
        }
    }

    private void adjustCounter(long l4) {
        if (l4 >= 0L) {
            long l5 = (l4 + (long)this.byteCount) / (long)this.blockSize;
            long l6 = l5;
            if (l6 > 255L) {
                for (int i4 = 5; i4 >= 1; --i4) {
                    long l7 = 1L << 8 * i4;
                    while (l6 >= l7) {
                        this.incrementCounterAt(i4);
                        l6 -= l7;
                    }
                }
            }
            this.incrementCounter((int)l6);
            this.byteCount = (int)(l4 + (long)this.byteCount - (long)this.blockSize * l5);
        } else {
            long l8 = (-l4 - (long)this.byteCount) / (long)this.blockSize;
            long l9 = l8;
            if (l9 > 255L) {
                for (int i5 = 5; i5 >= 1; --i5) {
                    long l10 = 1L << 8 * i5;
                    while (l9 > l10) {
                        this.decrementCounterAt(i5);
                        l9 -= l10;
                    }
                }
            }
            for (long i6 = 0L; i6 != l9; ++i6) {
                this.decrementCounterAt(0);
            }
            int n4 = (int)((long)this.byteCount + l4 + (long)this.blockSize * l8);
            if (n4 >= 0) {
                this.byteCount = 0;
            } else {
                this.decrementCounterAt(0);
                this.byteCount = this.blockSize + n4;
            }
        }
    }

    public void reset() {
        Arrays.fill(this.counter, (byte)0);
        System.arraycopy(this.IV, 0, this.counter, 0, this.IV.length);
        this.cipher.reset();
        this.byteCount = 0;
    }

    public long skip(long l4) {
        this.adjustCounter(l4);
        this.checkCounter();
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        return l4;
    }

    public long seekTo(long l4) {
        this.reset();
        return this.skip(l4);
    }

    public long getPosition() {
        byte[] byArray = new byte[this.counter.length];
        System.arraycopy(this.counter, 0, byArray, 0, byArray.length);
        for (int i4 = byArray.length - 1; i4 >= 1; --i4) {
            int n4 = i4 < this.IV.length ? (byArray[i4] & 0xFF) - (this.IV[i4] & 0xFF) : byArray[i4] & 0xFF;
            if (n4 < 0) {
                int n5 = i4 - 1;
                byArray[n5] = (byte)(byArray[n5] - 1);
                n4 += 256;
            }
            byArray[i4] = (byte)n4;
        }
        return Pack.bigEndianToLong(byArray, byArray.length - 8) * (long)this.blockSize + (long)this.byteCount;
    }
}

