/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;

public class OpenPGPCFBBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] FR;
    private byte[] FRE;
    private BlockCipher cipher;
    private int count;
    private int blockSize;
    private boolean forEncryption;

    public OpenPGPCFBBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.FR = new byte[this.blockSize];
        this.FRE = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/OpenPGPCFB";
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) throws DataLengthException, IllegalStateException {
        return this.forEncryption ? this.encryptBlock(byArray, n4, byArray2, n5) : this.decryptBlock(byArray, n4, byArray2, n5);
    }

    public void reset() {
        this.count = 0;
        System.arraycopy(this.IV, 0, this.FR, 0, this.FR.length);
        this.cipher.reset();
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        this.reset();
        this.cipher.init(true, cipherParameters);
    }

    private byte encryptByte(byte by, int n4) {
        return (byte)(this.FRE[n4] ^ by);
    }

    private int encryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) throws DataLengthException, IllegalStateException {
        if (n4 + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.count > this.blockSize) {
            this.FR[this.blockSize - 2] = byArray2[n5] = this.encryptByte(byArray[n4], this.blockSize - 2);
            byte by = this.encryptByte(byArray[n4 + 1], this.blockSize - 1);
            byArray2[n5 + 1] = by;
            this.FR[this.blockSize - 1] = by;
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (int i4 = 2; i4 < this.blockSize; ++i4) {
                byte by2 = this.encryptByte(byArray[n4 + i4], i4 - 2);
                byArray2[n5 + i4] = by2;
                this.FR[i4 - 2] = by2;
            }
        } else if (this.count == 0) {
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (int i5 = 0; i5 < this.blockSize; ++i5) {
                byte by = this.encryptByte(byArray[n4 + i5], i5);
                byArray2[n5 + i5] = by;
                this.FR[i5] = by;
            }
            this.count += this.blockSize;
        } else if (this.count == this.blockSize) {
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            byArray2[n5] = this.encryptByte(byArray[n4], 0);
            byArray2[n5 + 1] = this.encryptByte(byArray[n4 + 1], 1);
            System.arraycopy(this.FR, 2, this.FR, 0, this.blockSize - 2);
            System.arraycopy(byArray2, n5, this.FR, this.blockSize - 2, 2);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (int i6 = 2; i6 < this.blockSize; ++i6) {
                byte by = this.encryptByte(byArray[n4 + i6], i6 - 2);
                byArray2[n5 + i6] = by;
                this.FR[i6 - 2] = by;
            }
            this.count += this.blockSize;
        }
        return this.blockSize;
    }

    private int decryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) throws DataLengthException, IllegalStateException {
        if (n4 + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.count > this.blockSize) {
            byte by;
            this.FR[this.blockSize - 2] = by = byArray[n4];
            byArray2[n5] = this.encryptByte(by, this.blockSize - 2);
            this.FR[this.blockSize - 1] = by = byArray[n4 + 1];
            byArray2[n5 + 1] = this.encryptByte(by, this.blockSize - 1);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (int i4 = 2; i4 < this.blockSize; ++i4) {
                this.FR[i4 - 2] = by = byArray[n4 + i4];
                byArray2[n5 + i4] = this.encryptByte(by, i4 - 2);
            }
        } else if (this.count == 0) {
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (int i5 = 0; i5 < this.blockSize; ++i5) {
                this.FR[i5] = byArray[n4 + i5];
                byArray2[i5] = this.encryptByte(byArray[n4 + i5], i5);
            }
            this.count += this.blockSize;
        } else if (this.count == this.blockSize) {
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            byte by = byArray[n4];
            byte by2 = byArray[n4 + 1];
            byArray2[n5] = this.encryptByte(by, 0);
            byArray2[n5 + 1] = this.encryptByte(by2, 1);
            System.arraycopy(this.FR, 2, this.FR, 0, this.blockSize - 2);
            this.FR[this.blockSize - 2] = by;
            this.FR[this.blockSize - 1] = by2;
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            for (int i6 = 2; i6 < this.blockSize; ++i6) {
                byte by3;
                this.FR[i6 - 2] = by3 = byArray[n4 + i6];
                byArray2[n5 + i6] = this.encryptByte(by3, i6 - 2);
            }
            this.count += this.blockSize;
        }
        return this.blockSize;
    }
}

