/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;

public class OldCTSBlockCipher
extends BufferedBlockCipher {
    private int blockSize;

    public OldCTSBlockCipher(BlockCipher blockCipher) {
        if (blockCipher instanceof OFBBlockCipher || blockCipher instanceof CFBBlockCipher) {
            throw new IllegalArgumentException("CTSBlockCipher can only accept ECB, or CBC ciphers");
        }
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.buf = new byte[this.blockSize * 2];
        this.bufOff = 0;
    }

    public int getUpdateOutputSize(int n4) {
        int n5 = n4 + this.bufOff;
        int n6 = n5 % this.buf.length;
        if (n6 == 0) {
            return n5 - this.buf.length;
        }
        return n5 - n6;
    }

    public int getOutputSize(int n4) {
        return n4 + this.bufOff;
    }

    public int processByte(byte by, byte[] byArray, int n4) throws DataLengthException, IllegalStateException {
        int n5 = 0;
        if (this.bufOff == this.buf.length) {
            n5 = this.cipher.processBlock(this.buf, 0, byArray, n4);
            System.arraycopy(this.buf, this.blockSize, this.buf, 0, this.blockSize);
            this.bufOff = this.blockSize;
        }
        this.buf[this.bufOff++] = by;
        return n5;
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) throws DataLengthException, IllegalStateException {
        if (n5 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n7 = this.getBlockSize();
        int n8 = this.getUpdateOutputSize(n5);
        if (n8 > 0 && n6 + n8 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        int n9 = 0;
        int n10 = this.buf.length - this.bufOff;
        if (n5 > n10) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n10);
            n9 += this.cipher.processBlock(this.buf, 0, byArray2, n6);
            System.arraycopy(this.buf, n7, this.buf, 0, n7);
            this.bufOff = n7;
            n5 -= n10;
            n4 += n10;
            while (n5 > n7) {
                System.arraycopy(byArray, n4, this.buf, this.bufOff, n7);
                n9 += this.cipher.processBlock(this.buf, 0, byArray2, n6 + n9);
                System.arraycopy(this.buf, n7, this.buf, 0, n7);
                n5 -= n7;
                n4 += n7;
            }
        }
        System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
        this.bufOff += n5;
        return n9;
    }

    public int doFinal(byte[] byArray, int n4) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        if (this.bufOff + n4 > byArray.length) {
            throw new DataLengthException("output buffer to small in doFinal");
        }
        int n5 = this.cipher.getBlockSize();
        int n6 = this.bufOff - n5;
        byte[] byArray2 = new byte[n5];
        if (this.forEncryption) {
            int n7;
            this.cipher.processBlock(this.buf, 0, byArray2, 0);
            if (this.bufOff < n5) {
                throw new DataLengthException("need at least one block of input for CTS");
            }
            for (n7 = this.bufOff; n7 != this.buf.length; ++n7) {
                this.buf[n7] = byArray2[n7 - n5];
            }
            for (n7 = n5; n7 != this.bufOff; ++n7) {
                int n8 = n7;
                this.buf[n8] = (byte)(this.buf[n8] ^ byArray2[n7 - n5]);
            }
            if (this.cipher instanceof CBCBlockCipher) {
                BlockCipher blockCipher = ((CBCBlockCipher)this.cipher).getUnderlyingCipher();
                blockCipher.processBlock(this.buf, n5, byArray, n4);
            } else {
                this.cipher.processBlock(this.buf, n5, byArray, n4);
            }
            System.arraycopy(byArray2, 0, byArray, n4 + n5, n6);
        } else {
            byte[] byArray3 = new byte[n5];
            if (this.cipher instanceof CBCBlockCipher) {
                BlockCipher blockCipher = ((CBCBlockCipher)this.cipher).getUnderlyingCipher();
                blockCipher.processBlock(this.buf, 0, byArray2, 0);
            } else {
                this.cipher.processBlock(this.buf, 0, byArray2, 0);
            }
            for (int i4 = n5; i4 != this.bufOff; ++i4) {
                byArray3[i4 - n5] = (byte)(byArray2[i4 - n5] ^ this.buf[i4]);
            }
            System.arraycopy(this.buf, n5, byArray2, 0, n6);
            this.cipher.processBlock(byArray2, 0, byArray, n4);
            System.arraycopy(byArray3, 0, byArray, n4 + n5, n6);
        }
        int n9 = this.bufOff;
        this.reset();
        return n9;
    }
}

