/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.CBCBlockCipher;

public class NISTCTSBlockCipher
extends BufferedBlockCipher {
    public static final int CS1 = 1;
    public static final int CS2 = 2;
    public static final int CS3 = 3;
    private final int type;
    private final int blockSize;

    public NISTCTSBlockCipher(int n4, BlockCipher blockCipher) {
        this.type = n4;
        this.cipher = new CBCBlockCipher(blockCipher);
        this.blockSize = blockCipher.getBlockSize();
        this.buf = new byte[this.blockSize * 2];
        this.bufOff = 0;
    }

    public int getUpdateOutputSize(int n4) {
        int n5 = n4 + this.bufOff;
        int n6 = n5 % this.buf.length;
        if (n6 == 0) {
            return n5 - this.buf.length;
        }
        return n5 - n6;
    }

    public int getOutputSize(int n4) {
        return n4 + this.bufOff;
    }

    public int processByte(byte by, byte[] byArray, int n4) throws DataLengthException, IllegalStateException {
        int n5 = 0;
        if (this.bufOff == this.buf.length) {
            n5 = this.cipher.processBlock(this.buf, 0, byArray, n4);
            System.arraycopy(this.buf, this.blockSize, this.buf, 0, this.blockSize);
            this.bufOff = this.blockSize;
        }
        this.buf[this.bufOff++] = by;
        return n5;
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) throws DataLengthException, IllegalStateException {
        if (n5 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n7 = this.getBlockSize();
        int n8 = this.getUpdateOutputSize(n5);
        if (n8 > 0 && n6 + n8 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        int n9 = 0;
        int n10 = this.buf.length - this.bufOff;
        if (n5 > n10) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n10);
            n9 += this.cipher.processBlock(this.buf, 0, byArray2, n6);
            System.arraycopy(this.buf, n7, this.buf, 0, n7);
            this.bufOff = n7;
            n5 -= n10;
            n4 += n10;
            while (n5 > n7) {
                System.arraycopy(byArray, n4, this.buf, this.bufOff, n7);
                n9 += this.cipher.processBlock(this.buf, 0, byArray2, n6 + n9);
                System.arraycopy(this.buf, n7, this.buf, 0, n7);
                n5 -= n7;
                n4 += n7;
            }
        }
        System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
        this.bufOff += n5;
        return n9;
    }

    public int doFinal(byte[] byArray, int n4) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        byte[] byArray2;
        if (this.bufOff + n4 > byArray.length) {
            throw new DataLengthException("output buffer to small in doFinal");
        }
        int n5 = this.cipher.getBlockSize();
        int n6 = this.bufOff - n5;
        byte[] byArray3 = new byte[n5];
        if (this.forEncryption) {
            if (this.bufOff < n5) {
                throw new DataLengthException("need at least one block of input for NISTCTS");
            }
            if (this.bufOff > n5) {
                byArray2 = new byte[n5];
                if (this.type == 2 || this.type == 3) {
                    this.cipher.processBlock(this.buf, 0, byArray3, 0);
                    System.arraycopy(this.buf, n5, byArray2, 0, n6);
                    this.cipher.processBlock(byArray2, 0, byArray2, 0);
                    if (this.type == 2 && n6 == n5) {
                        System.arraycopy(byArray3, 0, byArray, n4, n5);
                        System.arraycopy(byArray2, 0, byArray, n4 + n5, n6);
                    } else {
                        System.arraycopy(byArray2, 0, byArray, n4, n5);
                        System.arraycopy(byArray3, 0, byArray, n4 + n5, n6);
                    }
                } else {
                    System.arraycopy(this.buf, 0, byArray3, 0, n5);
                    this.cipher.processBlock(byArray3, 0, byArray3, 0);
                    System.arraycopy(byArray3, 0, byArray, n4, n6);
                    System.arraycopy(this.buf, this.bufOff - n6, byArray2, 0, n6);
                    this.cipher.processBlock(byArray2, 0, byArray2, 0);
                    System.arraycopy(byArray2, 0, byArray, n4 + n6, n5);
                }
            } else {
                this.cipher.processBlock(this.buf, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray, n4, n5);
            }
        } else {
            if (this.bufOff < n5) {
                throw new DataLengthException("need at least one block of input for CTS");
            }
            byArray2 = new byte[n5];
            if (this.bufOff > n5) {
                if (this.type == 3 || this.type == 2 && (this.buf.length - this.bufOff) % n5 != 0) {
                    if (this.cipher instanceof CBCBlockCipher) {
                        BlockCipher blockCipher = ((CBCBlockCipher)this.cipher).getUnderlyingCipher();
                        blockCipher.processBlock(this.buf, 0, byArray3, 0);
                    } else {
                        this.cipher.processBlock(this.buf, 0, byArray3, 0);
                    }
                    for (int i4 = n5; i4 != this.bufOff; ++i4) {
                        byArray2[i4 - n5] = (byte)(byArray3[i4 - n5] ^ this.buf[i4]);
                    }
                    System.arraycopy(this.buf, n5, byArray3, 0, n6);
                    this.cipher.processBlock(byArray3, 0, byArray, n4);
                    System.arraycopy(byArray2, 0, byArray, n4 + n5, n6);
                } else {
                    BlockCipher blockCipher = ((CBCBlockCipher)this.cipher).getUnderlyingCipher();
                    blockCipher.processBlock(this.buf, this.bufOff - n5, byArray2, 0);
                    System.arraycopy(this.buf, 0, byArray3, 0, n5);
                    if (n6 != n5) {
                        System.arraycopy(byArray2, n6, byArray3, n6, n5 - n6);
                    }
                    this.cipher.processBlock(byArray3, 0, byArray3, 0);
                    System.arraycopy(byArray3, 0, byArray, n4, n5);
                    for (int i5 = 0; i5 != n6; ++i5) {
                        int n7 = i5;
                        byArray2[n7] = (byte)(byArray2[n7] ^ this.buf[i5]);
                    }
                    System.arraycopy(byArray2, 0, byArray, n4 + n5, n6);
                }
            } else {
                this.cipher.processBlock(this.buf, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray, n4, n5);
            }
        }
        int n8 = this.bufOff;
        this.reset();
        return n8;
    }
}

