/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

public class CCMBlockCipher
implements AEADBlockCipher {
    private BlockCipher cipher;
    private int blockSize;
    private boolean forEncryption;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private int macSize;
    private CipherParameters keyParam;
    private byte[] macBlock;
    private ExposedByteArrayOutputStream associatedText = new ExposedByteArrayOutputStream();
    private ExposedByteArrayOutputStream data = new ExposedByteArrayOutputStream();

    public CCMBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.macBlock = new byte[this.blockSize];
        if (this.blockSize != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2;
        this.forEncryption = bl;
        if (cipherParameters instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)cipherParameters;
            this.nonce = aEADParameters.getNonce();
            this.initialAssociatedText = aEADParameters.getAssociatedText();
            this.macSize = aEADParameters.getMacSize() / 8;
            cipherParameters2 = aEADParameters.getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            this.nonce = parametersWithIV.getIV();
            this.initialAssociatedText = null;
            this.macSize = this.macBlock.length / 2;
            cipherParameters2 = parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM: " + cipherParameters.getClass().getName());
        }
        if (cipherParameters2 != null) {
            this.keyParam = cipherParameters2;
        }
        if (this.nonce == null || this.nonce.length < 7 || this.nonce.length > 13) {
            throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
        }
        this.reset();
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CCM";
    }

    public void processAADByte(byte by) {
        this.associatedText.write(by);
    }

    public void processAADBytes(byte[] byArray, int n4, int n5) {
        this.associatedText.write(byArray, n4, n5);
    }

    public int processByte(byte by, byte[] byArray, int n4) throws DataLengthException, IllegalStateException {
        this.data.write(by);
        return 0;
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) throws DataLengthException, IllegalStateException {
        if (byArray.length < n4 + n5) {
            throw new DataLengthException("Input buffer too short");
        }
        this.data.write(byArray, n4, n5);
        return 0;
    }

    public int doFinal(byte[] byArray, int n4) throws IllegalStateException, InvalidCipherTextException {
        int n5 = this.processPacket(this.data.getBuffer(), 0, this.data.size(), byArray, n4);
        this.reset();
        return n5;
    }

    public void reset() {
        this.cipher.reset();
        this.associatedText.reset();
        this.data.reset();
    }

    public byte[] getMac() {
        byte[] byArray = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int getUpdateOutputSize(int n4) {
        return 0;
    }

    public int getOutputSize(int n4) {
        int n5 = n4 + this.data.size();
        if (this.forEncryption) {
            return n5 + this.macSize;
        }
        return n5 < this.macSize ? 0 : n5 - this.macSize;
    }

    public byte[] processPacket(byte[] byArray, int n4, int n5) throws IllegalStateException, InvalidCipherTextException {
        byte[] byArray2;
        if (this.forEncryption) {
            byArray2 = new byte[n5 + this.macSize];
        } else {
            if (n5 < this.macSize) {
                throw new InvalidCipherTextException("data too short");
            }
            byArray2 = new byte[n5 - this.macSize];
        }
        this.processPacket(byArray, n4, n5, byArray2, 0);
        return byArray2;
    }

    public int processPacket(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) throws IllegalStateException, InvalidCipherTextException, DataLengthException {
        int n7;
        int n8;
        int n9;
        if (this.keyParam == null) {
            throw new IllegalStateException("CCM cipher unitialized.");
        }
        int n10 = this.nonce.length;
        int n11 = 15 - n10;
        if (n11 < 4 && n5 >= (n9 = 1 << 8 * n11)) {
            throw new IllegalStateException("CCM packet too large for choice of q.");
        }
        byte[] byArray3 = new byte[this.blockSize];
        byArray3[0] = (byte)(n11 - 1 & 7);
        System.arraycopy(this.nonce, 0, byArray3, 1, this.nonce.length);
        SICBlockCipher sICBlockCipher = new SICBlockCipher(this.cipher);
        sICBlockCipher.init(this.forEncryption, new ParametersWithIV(this.keyParam, byArray3));
        int n12 = n6;
        if (this.forEncryption) {
            n8 = n5 + this.macSize;
            if (byArray2.length < n8 + n6) {
                throw new OutputLengthException("Output buffer too short.");
            }
            this.calculateMac(byArray, n4, n5, this.macBlock);
            byte[] byArray4 = new byte[this.blockSize];
            sICBlockCipher.processBlock(this.macBlock, 0, byArray4, 0);
            for (n7 = n4; n7 < n4 + n5 - this.blockSize; n7 += this.blockSize) {
                sICBlockCipher.processBlock(byArray, n7, byArray2, n12);
                n12 += this.blockSize;
            }
            byte[] byArray5 = new byte[this.blockSize];
            System.arraycopy(byArray, n7, byArray5, 0, n5 + n4 - n7);
            sICBlockCipher.processBlock(byArray5, 0, byArray5, 0);
            System.arraycopy(byArray5, 0, byArray2, n12, n5 + n4 - n7);
            System.arraycopy(byArray4, 0, byArray2, n6 + n5, this.macSize);
        } else {
            if (n5 < this.macSize) {
                throw new InvalidCipherTextException("data too short");
            }
            n8 = n5 - this.macSize;
            if (byArray2.length < n8 + n6) {
                throw new OutputLengthException("Output buffer too short.");
            }
            System.arraycopy(byArray, n4 + n8, this.macBlock, 0, this.macSize);
            sICBlockCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (int i4 = this.macSize; i4 != this.macBlock.length; ++i4) {
                this.macBlock[i4] = 0;
            }
            while (n7 < n4 + n8 - this.blockSize) {
                sICBlockCipher.processBlock(byArray, n7, byArray2, n12);
                n12 += this.blockSize;
                n7 += this.blockSize;
            }
            byte[] byArray6 = new byte[this.blockSize];
            System.arraycopy(byArray, n7, byArray6, 0, n8 - (n7 - n4));
            sICBlockCipher.processBlock(byArray6, 0, byArray6, 0);
            System.arraycopy(byArray6, 0, byArray2, n12, n8 - (n7 - n4));
            byte[] byArray7 = new byte[this.blockSize];
            this.calculateMac(byArray2, n6, n8, byArray7);
            if (!Arrays.constantTimeAreEqual(this.macBlock, byArray7)) {
                throw new InvalidCipherTextException("mac check in CCM failed");
            }
        }
        return n8;
    }

    private int calculateMac(byte[] byArray, int n4, int n5, byte[] byArray2) {
        CBCBlockCipherMac cBCBlockCipherMac = new CBCBlockCipherMac(this.cipher, this.macSize * 8);
        cBCBlockCipherMac.init(this.keyParam);
        byte[] byArray3 = new byte[16];
        if (this.hasAssociatedText()) {
            byArray3[0] = (byte)(byArray3[0] | 0x40);
        }
        byArray3[0] = (byte)(byArray3[0] | ((cBCBlockCipherMac.getMacSize() - 2) / 2 & 7) << 3);
        byArray3[0] = (byte)(byArray3[0] | 15 - this.nonce.length - 1 & 7);
        System.arraycopy(this.nonce, 0, byArray3, 1, this.nonce.length);
        int n6 = n5;
        int n7 = 1;
        while (n6 > 0) {
            byArray3[byArray3.length - n7] = (byte)(n6 & 0xFF);
            n6 >>>= 8;
            ++n7;
        }
        cBCBlockCipherMac.update(byArray3, 0, byArray3.length);
        if (this.hasAssociatedText()) {
            int n8;
            int n9 = this.getAssociatedTextLength();
            if (n9 < 65280) {
                cBCBlockCipherMac.update((byte)(n9 >> 8));
                cBCBlockCipherMac.update((byte)n9);
                n8 = 2;
            } else {
                cBCBlockCipherMac.update((byte)-1);
                cBCBlockCipherMac.update((byte)-2);
                cBCBlockCipherMac.update((byte)(n9 >> 24));
                cBCBlockCipherMac.update((byte)(n9 >> 16));
                cBCBlockCipherMac.update((byte)(n9 >> 8));
                cBCBlockCipherMac.update((byte)n9);
                n8 = 6;
            }
            if (this.initialAssociatedText != null) {
                cBCBlockCipherMac.update(this.initialAssociatedText, 0, this.initialAssociatedText.length);
            }
            if (this.associatedText.size() > 0) {
                cBCBlockCipherMac.update(this.associatedText.getBuffer(), 0, this.associatedText.size());
            }
            if ((n8 = (n8 + n9) % 16) != 0) {
                for (int i4 = n8; i4 != 16; ++i4) {
                    cBCBlockCipherMac.update((byte)0);
                }
            }
        }
        cBCBlockCipherMac.update(byArray, n4, n5);
        return cBCBlockCipherMac.doFinal(byArray2, 0);
    }

    private int getAssociatedTextLength() {
        return this.associatedText.size() + (this.initialAssociatedText == null ? 0 : this.initialAssociatedText.length);
    }

    private boolean hasAssociatedText() {
        return this.getAssociatedTextLength() > 0;
    }

    private class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

