/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Pack;

public class CMac
implements Mac {
    private byte[] poly;
    private byte[] ZEROES;
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private int macSize;
    private byte[] Lu;
    private byte[] Lu2;

    public CMac(BlockCipher blockCipher) {
        this(blockCipher, blockCipher.getBlockSize() * 8);
    }

    public CMac(BlockCipher blockCipher, int n4) {
        if (n4 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (n4 > blockCipher.getBlockSize() * 8) {
            throw new IllegalArgumentException("MAC size must be less or equal to " + blockCipher.getBlockSize() * 8);
        }
        this.cipher = new CBCBlockCipher(blockCipher);
        this.macSize = n4 / 8;
        this.poly = CMac.lookupPoly(blockCipher.getBlockSize());
        this.mac = new byte[blockCipher.getBlockSize()];
        this.buf = new byte[blockCipher.getBlockSize()];
        this.ZEROES = new byte[blockCipher.getBlockSize()];
        this.bufOff = 0;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    private static int shiftLeft(byte[] byArray, byte[] byArray2) {
        int n4 = byArray.length;
        int n5 = 0;
        while (--n4 >= 0) {
            int n6 = byArray[n4] & 0xFF;
            byArray2[n4] = (byte)(n6 << 1 | n5);
            n5 = n6 >>> 7 & 1;
        }
        return n5;
    }

    private byte[] doubleLu(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n4 = CMac.shiftLeft(byArray, byArray2);
        int n5 = -n4 & 0xFF;
        int n6 = byArray.length - 3;
        byArray2[n6] = (byte)(byArray2[n6] ^ this.poly[1] & n5);
        int n7 = byArray.length - 2;
        byArray2[n7] = (byte)(byArray2[n7] ^ this.poly[2] & n5);
        int n8 = byArray.length - 1;
        byArray2[n8] = (byte)(byArray2[n8] ^ this.poly[3] & n5);
        return byArray2;
    }

    private static byte[] lookupPoly(int n4) {
        int n5;
        switch (n4 * 8) {
            case 64: {
                n5 = 27;
                break;
            }
            case 128: {
                n5 = 135;
                break;
            }
            case 160: {
                n5 = 45;
                break;
            }
            case 192: {
                n5 = 135;
                break;
            }
            case 224: {
                n5 = 777;
                break;
            }
            case 256: {
                n5 = 1061;
                break;
            }
            case 320: {
                n5 = 27;
                break;
            }
            case 384: {
                n5 = 4109;
                break;
            }
            case 448: {
                n5 = 2129;
                break;
            }
            case 512: {
                n5 = 293;
                break;
            }
            case 768: {
                n5 = 655377;
                break;
            }
            case 1024: {
                n5 = 524355;
                break;
            }
            case 2048: {
                n5 = 548865;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown block size for CMAC: " + n4 * 8);
            }
        }
        return Pack.intToBigEndian(n5);
    }

    public void init(CipherParameters cipherParameters) {
        this.validate(cipherParameters);
        this.cipher.init(true, cipherParameters);
        byte[] byArray = new byte[this.ZEROES.length];
        this.cipher.processBlock(this.ZEROES, 0, byArray, 0);
        this.Lu = this.doubleLu(byArray);
        this.Lu2 = this.doubleLu(this.Lu);
        this.reset();
    }

    void validate(CipherParameters cipherParameters) {
        if (cipherParameters != null && !(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("CMac mode only permits key to be set.");
        }
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void update(byte by) {
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by;
    }

    public void update(byte[] byArray, int n4, int n5) {
        if (n5 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n6 = this.cipher.getBlockSize();
        int n7 = n6 - this.bufOff;
        if (n5 > n7) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n7);
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            n5 -= n7;
            n4 += n7;
            while (n5 > n6) {
                this.cipher.processBlock(byArray, n4, this.mac, 0);
                n5 -= n6;
                n4 += n6;
            }
        }
        System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
        this.bufOff += n5;
    }

    public int doFinal(byte[] byArray, int n4) {
        byte[] byArray2;
        int n5 = this.cipher.getBlockSize();
        if (this.bufOff == n5) {
            byArray2 = this.Lu;
        } else {
            new ISO7816d4Padding().addPadding(this.buf, this.bufOff);
            byArray2 = this.Lu2;
        }
        for (int i4 = 0; i4 < this.mac.length; ++i4) {
            int n6 = i4;
            this.buf[n6] = (byte)(this.buf[n6] ^ byArray2[i4]);
        }
        this.cipher.processBlock(this.buf, 0, this.mac, 0);
        System.arraycopy(this.mac, 0, byArray, n4, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i4 = 0; i4 < this.buf.length; ++i4) {
            this.buf[i4] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

