/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.SkippingCipher;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.io.CipherIOException;
import org.bouncycastle.crypto.io.InvalidCipherTextIOException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.util.Arrays;

public class CipherInputStream
extends FilterInputStream {
    private static final int INPUT_BUF_SIZE = 2048;
    private SkippingCipher skippingCipher;
    private byte[] inBuf;
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADBlockCipher aeadBlockCipher;
    private byte[] buf;
    private byte[] markBuf;
    private int bufOff;
    private int maxBuf;
    private boolean finalized;
    private long markPosition;
    private int markBufOff;

    public CipherInputStream(InputStream inputStream, BufferedBlockCipher bufferedBlockCipher) {
        this(inputStream, bufferedBlockCipher, 2048);
    }

    public CipherInputStream(InputStream inputStream, StreamCipher streamCipher) {
        this(inputStream, streamCipher, 2048);
    }

    public CipherInputStream(InputStream inputStream, AEADBlockCipher aEADBlockCipher) {
        this(inputStream, aEADBlockCipher, 2048);
    }

    public CipherInputStream(InputStream inputStream, BufferedBlockCipher bufferedBlockCipher, int n4) {
        super(inputStream);
        this.bufferedBlockCipher = bufferedBlockCipher;
        this.inBuf = new byte[n4];
        this.skippingCipher = bufferedBlockCipher instanceof SkippingCipher ? (SkippingCipher)((Object)bufferedBlockCipher) : null;
    }

    public CipherInputStream(InputStream inputStream, StreamCipher streamCipher, int n4) {
        super(inputStream);
        this.streamCipher = streamCipher;
        this.inBuf = new byte[n4];
        this.skippingCipher = streamCipher instanceof SkippingCipher ? (SkippingCipher)((Object)streamCipher) : null;
    }

    public CipherInputStream(InputStream inputStream, AEADBlockCipher aEADBlockCipher, int n4) {
        super(inputStream);
        this.aeadBlockCipher = aEADBlockCipher;
        this.inBuf = new byte[n4];
        this.skippingCipher = aEADBlockCipher instanceof SkippingCipher ? (SkippingCipher)((Object)aEADBlockCipher) : null;
    }

    private int nextChunk() throws IOException {
        if (this.finalized) {
            return -1;
        }
        this.bufOff = 0;
        this.maxBuf = 0;
        while (this.maxBuf == 0) {
            int n4 = this.in.read(this.inBuf);
            if (n4 == -1) {
                this.finaliseCipher();
                if (this.maxBuf == 0) {
                    return -1;
                }
                return this.maxBuf;
            }
            try {
                this.ensureCapacity(n4, false);
                if (this.bufferedBlockCipher != null) {
                    this.maxBuf = this.bufferedBlockCipher.processBytes(this.inBuf, 0, n4, this.buf, 0);
                    continue;
                }
                if (this.aeadBlockCipher != null) {
                    this.maxBuf = this.aeadBlockCipher.processBytes(this.inBuf, 0, n4, this.buf, 0);
                    continue;
                }
                this.streamCipher.processBytes(this.inBuf, 0, n4, this.buf, 0);
                this.maxBuf = n4;
            }
            catch (Exception exception) {
                throw new CipherIOException("Error processing stream ", exception);
            }
        }
        return this.maxBuf;
    }

    private void finaliseCipher() throws IOException {
        try {
            this.finalized = true;
            this.ensureCapacity(0, true);
            this.maxBuf = this.bufferedBlockCipher != null ? this.bufferedBlockCipher.doFinal(this.buf, 0) : (this.aeadBlockCipher != null ? this.aeadBlockCipher.doFinal(this.buf, 0) : 0);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new InvalidCipherTextIOException("Error finalising cipher", invalidCipherTextException);
        }
        catch (Exception exception) {
            throw new IOException("Error finalising cipher " + exception);
        }
    }

    public int read() throws IOException {
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        return this.buf[this.bufOff++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n4, int n5) throws IOException {
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        int n6 = Math.min(n5, this.available());
        System.arraycopy(this.buf, this.bufOff, byArray, n4, n6);
        this.bufOff += n6;
        return n6;
    }

    public long skip(long l4) throws IOException {
        if (l4 <= 0L) {
            return 0L;
        }
        if (this.skippingCipher != null) {
            long l5;
            int n4 = this.available();
            if (l4 <= (long)n4) {
                this.bufOff = (int)((long)this.bufOff + l4);
                return l4;
            }
            this.bufOff = this.maxBuf;
            long l6 = this.in.skip(l4 - (long)n4);
            if (l6 != (l5 = this.skippingCipher.skip(l6))) {
                throw new IOException("Unable to skip cipher " + l6 + " bytes.");
            }
            return l6 + (long)n4;
        }
        int n5 = (int)Math.min(l4, (long)this.available());
        this.bufOff += n5;
        return n5;
    }

    public int available() throws IOException {
        return this.maxBuf - this.bufOff;
    }

    private void ensureCapacity(int n4, boolean bl) {
        int n5 = n4;
        if (bl) {
            if (this.bufferedBlockCipher != null) {
                n5 = this.bufferedBlockCipher.getOutputSize(n4);
            } else if (this.aeadBlockCipher != null) {
                n5 = this.aeadBlockCipher.getOutputSize(n4);
            }
        } else if (this.bufferedBlockCipher != null) {
            n5 = this.bufferedBlockCipher.getUpdateOutputSize(n4);
        } else if (this.aeadBlockCipher != null) {
            n5 = this.aeadBlockCipher.getUpdateOutputSize(n4);
        }
        if (this.buf == null || this.buf.length < n5) {
            this.buf = new byte[n5];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            if (!this.finalized) {
                this.finaliseCipher();
            }
        }
        this.bufOff = 0;
        this.maxBuf = 0;
        this.markBufOff = 0;
        this.markPosition = 0L;
        if (this.markBuf != null) {
            Arrays.fill(this.markBuf, (byte)0);
            this.markBuf = null;
        }
        if (this.buf != null) {
            Arrays.fill(this.buf, (byte)0);
            this.buf = null;
        }
        Arrays.fill(this.inBuf, (byte)0);
    }

    public void mark(int n4) {
        this.in.mark(n4);
        if (this.skippingCipher != null) {
            this.markPosition = this.skippingCipher.getPosition();
        }
        if (this.buf != null) {
            this.markBuf = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, this.markBuf, 0, this.buf.length);
        }
        this.markBufOff = this.bufOff;
    }

    public void reset() throws IOException {
        if (this.skippingCipher == null) {
            throw new IOException("cipher must implement SkippingCipher to be used with reset()");
        }
        this.in.reset();
        this.skippingCipher.seekTo(this.markPosition);
        if (this.markBuf != null) {
            this.buf = this.markBuf;
        }
        this.bufOff = this.markBufOff;
    }

    public boolean markSupported() {
        if (this.skippingCipher != null) {
            return this.in.markSupported();
        }
        return false;
    }
}

