/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class TEAEngine
implements BlockCipher {
    private static final int rounds = 32;
    private static final int block_size = 8;
    private static final int delta = -1640531527;
    private static final int d_sum = -957401312;
    private int _a;
    private int _b;
    private int _c;
    private int _d;
    private boolean _initialised = false;
    private boolean _forEncryption;

    public String getAlgorithmName() {
        return "TEA";
    }

    public int getBlockSize() {
        return 8;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to TEA init - " + cipherParameters.getClass().getName());
        }
        this._forEncryption = bl;
        this._initialised = true;
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        this.setKey(keyParameter.getKey());
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        if (!this._initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n4 + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        return this._forEncryption ? this.encryptBlock(byArray, n4, byArray2, n5) : this.decryptBlock(byArray, n4, byArray2, n5);
    }

    public void reset() {
    }

    private void setKey(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Key size must be 128 bits.");
        }
        this._a = this.bytesToInt(byArray, 0);
        this._b = this.bytesToInt(byArray, 4);
        this._c = this.bytesToInt(byArray, 8);
        this._d = this.bytesToInt(byArray, 12);
    }

    private int encryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = this.bytesToInt(byArray, n4);
        int n7 = this.bytesToInt(byArray, n4 + 4);
        int n8 = 0;
        for (int i4 = 0; i4 != 32; ++i4) {
            n7 += ((n6 += (n7 << 4) + this._a ^ n7 + (n8 -= 1640531527) ^ (n7 >>> 5) + this._b) << 4) + this._c ^ n6 + n8 ^ (n6 >>> 5) + this._d;
        }
        this.unpackInt(n6, byArray2, n5);
        this.unpackInt(n7, byArray2, n5 + 4);
        return 8;
    }

    private int decryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = this.bytesToInt(byArray, n4);
        int n7 = this.bytesToInt(byArray, n4 + 4);
        int n8 = -957401312;
        for (int i4 = 0; i4 != 32; ++i4) {
            n6 -= ((n7 -= (n6 << 4) + this._c ^ n6 + n8 ^ (n6 >>> 5) + this._d) << 4) + this._a ^ n7 + n8 ^ (n7 >>> 5) + this._b;
            n8 += 1640531527;
        }
        this.unpackInt(n6, byArray2, n5);
        this.unpackInt(n7, byArray2, n5 + 4);
        return 8;
    }

    private int bytesToInt(byte[] byArray, int n4) {
        return byArray[n4++] << 24 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4] & 0xFF;
    }

    private void unpackInt(int n4, byte[] byArray, int n5) {
        byArray[n5++] = (byte)(n4 >>> 24);
        byArray[n5++] = (byte)(n4 >>> 16);
        byArray[n5++] = (byte)(n4 >>> 8);
        byArray[n5] = (byte)n4;
    }
}

