/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RC5Parameters;

public class RC532Engine
implements BlockCipher {
    private int _noRounds = 12;
    private int[] _S = null;
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;
    private boolean forEncryption;

    public String getAlgorithmName() {
        return "RC5-32";
    }

    public int getBlockSize() {
        return 8;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof RC5Parameters) {
            RC5Parameters rC5Parameters = (RC5Parameters)cipherParameters;
            this._noRounds = rC5Parameters.getRounds();
            this.setKey(rC5Parameters.getKey());
        } else if (cipherParameters instanceof KeyParameter) {
            KeyParameter keyParameter = (KeyParameter)cipherParameters;
            this.setKey(keyParameter.getKey());
        } else {
            throw new IllegalArgumentException("invalid parameter passed to RC532 init - " + cipherParameters.getClass().getName());
        }
        this.forEncryption = bl;
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        return this.forEncryption ? this.encryptBlock(byArray, n4, byArray2, n5) : this.decryptBlock(byArray, n4, byArray2, n5);
    }

    public void reset() {
    }

    private void setKey(byte[] byArray) {
        int n4;
        int[] nArray = new int[(byArray.length + 3) / 4];
        for (n4 = 0; n4 != byArray.length; ++n4) {
            int n5 = n4 / 4;
            nArray[n5] = nArray[n5] + ((byArray[n4] & 0xFF) << 8 * (n4 % 4));
        }
        this._S = new int[2 * (this._noRounds + 1)];
        this._S[0] = -1209970333;
        for (n4 = 1; n4 < this._S.length; ++n4) {
            this._S[n4] = this._S[n4 - 1] + -1640531527;
        }
        n4 = nArray.length > this._S.length ? 3 * nArray.length : 3 * this._S.length;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i4 = 0; i4 < n4; ++i4) {
            n6 = this._S[n8] = this.rotateLeft(this._S[n8] + n6 + n7, 3);
            n7 = nArray[n9] = this.rotateLeft(nArray[n9] + n6 + n7, n6 + n7);
            n8 = (n8 + 1) % this._S.length;
            n9 = (n9 + 1) % nArray.length;
        }
    }

    private int encryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = this.bytesToWord(byArray, n4) + this._S[0];
        int n7 = this.bytesToWord(byArray, n4 + 4) + this._S[1];
        for (int i4 = 1; i4 <= this._noRounds; ++i4) {
            n6 = this.rotateLeft(n6 ^ n7, n7) + this._S[2 * i4];
            n7 = this.rotateLeft(n7 ^ n6, n6) + this._S[2 * i4 + 1];
        }
        this.wordToBytes(n6, byArray2, n5);
        this.wordToBytes(n7, byArray2, n5 + 4);
        return 8;
    }

    private int decryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = this.bytesToWord(byArray, n4);
        int n7 = this.bytesToWord(byArray, n4 + 4);
        for (int i4 = this._noRounds; i4 >= 1; --i4) {
            n7 = this.rotateRight(n7 - this._S[2 * i4 + 1], n6) ^ n6;
            n6 = this.rotateRight(n6 - this._S[2 * i4], n7) ^ n7;
        }
        this.wordToBytes(n6 - this._S[0], byArray2, n5);
        this.wordToBytes(n7 - this._S[1], byArray2, n5 + 4);
        return 8;
    }

    private int rotateLeft(int n4, int n5) {
        return n4 << (n5 & 0x1F) | n4 >>> 32 - (n5 & 0x1F);
    }

    private int rotateRight(int n4, int n5) {
        return n4 >>> (n5 & 0x1F) | n4 << 32 - (n5 & 0x1F);
    }

    private int bytesToWord(byte[] byArray, int n4) {
        return byArray[n4] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8 | (byArray[n4 + 2] & 0xFF) << 16 | (byArray[n4 + 3] & 0xFF) << 24;
    }

    private void wordToBytes(int n4, byte[] byArray, int n5) {
        byArray[n5] = (byte)n4;
        byArray[n5 + 1] = (byte)(n4 >> 8);
        byArray[n5 + 2] = (byte)(n4 >> 16);
        byArray[n5 + 3] = (byte)(n4 >> 24);
    }
}

