/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import org.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;

public class NaccacheSternEngine
implements AsymmetricBlockCipher {
    private boolean forEncryption;
    private NaccacheSternKeyParameters key;
    private Vector[] lookup = null;
    private boolean debug = false;
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forEncryption = bl;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        this.key = (NaccacheSternKeyParameters)cipherParameters;
        if (!this.forEncryption) {
            if (this.debug) {
                System.out.println("Constructing lookup Array");
            }
            NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = (NaccacheSternPrivateKeyParameters)this.key;
            Vector vector = naccacheSternPrivateKeyParameters.getSmallPrimes();
            this.lookup = new Vector[vector.size()];
            for (int i4 = 0; i4 < vector.size(); ++i4) {
                BigInteger bigInteger = (BigInteger)vector.elementAt(i4);
                int n4 = bigInteger.intValue();
                this.lookup[i4] = new Vector();
                this.lookup[i4].addElement(ONE);
                if (this.debug) {
                    System.out.println("Constructing lookup ArrayList for " + n4);
                }
                BigInteger bigInteger2 = ZERO;
                for (int i5 = 1; i5 < n4; ++i5) {
                    bigInteger2 = bigInteger2.add(naccacheSternPrivateKeyParameters.getPhi_n());
                    BigInteger bigInteger3 = bigInteger2.divide(bigInteger);
                    this.lookup[i4].addElement(naccacheSternPrivateKeyParameters.getG().modPow(bigInteger3, naccacheSternPrivateKeyParameters.getModulus()));
                }
            }
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public int getInputBlockSize() {
        if (this.forEncryption) {
            return (this.key.getLowerSigmaBound() + 7) / 8 - 1;
        }
        return this.key.getModulus().toByteArray().length;
    }

    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return this.key.getModulus().toByteArray().length;
        }
        return (this.key.getLowerSigmaBound() + 7) / 8 - 1;
    }

    public byte[] processBlock(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        byte[] byArray2;
        byte[] byArray3;
        if (this.key == null) {
            throw new IllegalStateException("NaccacheStern engine not initialised");
        }
        if (n5 > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for Naccache-Stern cipher.\n");
        }
        if (!this.forEncryption && n5 < this.getInputBlockSize()) {
            throw new InvalidCipherTextException("BlockLength does not match modulus for Naccache-Stern cipher.\n");
        }
        if (n4 != 0 || n5 != byArray.length) {
            byArray3 = new byte[n5];
            System.arraycopy(byArray, n4, byArray3, 0, n5);
        } else {
            byArray3 = byArray;
        }
        BigInteger bigInteger = new BigInteger(1, byArray3);
        if (this.debug) {
            System.out.println("input as BigInteger: " + bigInteger);
        }
        if (this.forEncryption) {
            byArray2 = this.encrypt(bigInteger);
        } else {
            Vector<BigInteger> vector = new Vector<BigInteger>();
            NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = (NaccacheSternPrivateKeyParameters)this.key;
            Vector vector2 = naccacheSternPrivateKeyParameters.getSmallPrimes();
            for (int i4 = 0; i4 < vector2.size(); ++i4) {
                BigInteger bigInteger2 = bigInteger.modPow(naccacheSternPrivateKeyParameters.getPhi_n().divide((BigInteger)vector2.elementAt(i4)), naccacheSternPrivateKeyParameters.getModulus());
                Vector vector3 = this.lookup[i4];
                if (this.lookup[i4].size() != ((BigInteger)vector2.elementAt(i4)).intValue()) {
                    if (this.debug) {
                        System.out.println("Prime is " + vector2.elementAt(i4) + ", lookup table has size " + vector3.size());
                    }
                    throw new InvalidCipherTextException("Error in lookup Array for " + ((BigInteger)vector2.elementAt(i4)).intValue() + ": Size mismatch. Expected ArrayList with length " + ((BigInteger)vector2.elementAt(i4)).intValue() + " but found ArrayList of length " + this.lookup[i4].size());
                }
                int n6 = vector3.indexOf(bigInteger2);
                if (n6 == -1) {
                    if (this.debug) {
                        System.out.println("Actual prime is " + vector2.elementAt(i4));
                        System.out.println("Decrypted value is " + bigInteger2);
                        System.out.println("LookupList for " + vector2.elementAt(i4) + " with size " + this.lookup[i4].size() + " is: ");
                        for (int i5 = 0; i5 < this.lookup[i4].size(); ++i5) {
                            System.out.println(this.lookup[i4].elementAt(i5));
                        }
                    }
                    throw new InvalidCipherTextException("Lookup failed");
                }
                vector.addElement(BigInteger.valueOf(n6));
            }
            BigInteger bigInteger3 = NaccacheSternEngine.chineseRemainder(vector, vector2);
            byArray2 = bigInteger3.toByteArray();
        }
        return byArray2;
    }

    public byte[] encrypt(BigInteger bigInteger) {
        byte[] byArray = this.key.getModulus().toByteArray();
        Arrays.fill(byArray, (byte)0);
        byte[] byArray2 = this.key.getG().modPow(bigInteger, this.key.getModulus()).toByteArray();
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        if (this.debug) {
            System.out.println("Encrypted value is:  " + new BigInteger(byArray));
        }
        return byArray;
    }

    public byte[] addCryptedBlocks(byte[] byArray, byte[] byArray2) throws InvalidCipherTextException {
        if (this.forEncryption ? byArray.length > this.getOutputBlockSize() || byArray2.length > this.getOutputBlockSize() : byArray.length > this.getInputBlockSize() || byArray2.length > this.getInputBlockSize()) {
            throw new InvalidCipherTextException("BlockLength too large for simple addition.\n");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        bigInteger3 = bigInteger3.mod(this.key.getModulus());
        if (this.debug) {
            System.out.println("c(m1) as BigInteger:....... " + bigInteger);
            System.out.println("c(m2) as BigInteger:....... " + bigInteger2);
            System.out.println("c(m1)*c(m2)%n = c(m1+m2)%n: " + bigInteger3);
        }
        byte[] byArray3 = this.key.getModulus().toByteArray();
        Arrays.fill(byArray3, (byte)0);
        System.arraycopy(bigInteger3.toByteArray(), 0, byArray3, byArray3.length - bigInteger3.toByteArray().length, bigInteger3.toByteArray().length);
        return byArray3;
    }

    public byte[] processData(byte[] byArray) throws InvalidCipherTextException {
        if (this.debug) {
            System.out.println();
        }
        if (byArray.length > this.getInputBlockSize()) {
            byte[] byArray2;
            int n4 = this.getInputBlockSize();
            int n5 = this.getOutputBlockSize();
            if (this.debug) {
                System.out.println("Input blocksize is:  " + n4 + " bytes");
                System.out.println("Output blocksize is: " + n5 + " bytes");
                System.out.println("Data has length:.... " + byArray.length + " bytes");
            }
            int n6 = 0;
            int n7 = 0;
            byte[] byArray3 = new byte[(byArray.length / n4 + 1) * n5];
            while (n6 < byArray.length) {
                if (n6 + n4 < byArray.length) {
                    byArray2 = this.processBlock(byArray, n6, n4);
                    n6 += n4;
                } else {
                    byArray2 = this.processBlock(byArray, n6, byArray.length - n6);
                    n6 += byArray.length - n6;
                }
                if (this.debug) {
                    System.out.println("new datapos is " + n6);
                }
                if (byArray2 != null) {
                    System.arraycopy(byArray2, 0, byArray3, n7, byArray2.length);
                    n7 += byArray2.length;
                    continue;
                }
                if (this.debug) {
                    System.out.println("cipher returned null");
                }
                throw new InvalidCipherTextException("cipher returned null");
            }
            byArray2 = new byte[n7];
            System.arraycopy(byArray3, 0, byArray2, 0, n7);
            if (this.debug) {
                System.out.println("returning " + byArray2.length + " bytes");
            }
            return byArray2;
        }
        if (this.debug) {
            System.out.println("data size is less then input block size, processing directly");
        }
        return this.processBlock(byArray, 0, byArray.length);
    }

    private static BigInteger chineseRemainder(Vector vector, Vector vector2) {
        int n4;
        BigInteger bigInteger = ZERO;
        BigInteger bigInteger2 = ONE;
        for (n4 = 0; n4 < vector2.size(); ++n4) {
            bigInteger2 = bigInteger2.multiply((BigInteger)vector2.elementAt(n4));
        }
        for (n4 = 0; n4 < vector2.size(); ++n4) {
            BigInteger bigInteger3 = (BigInteger)vector2.elementAt(n4);
            BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
            BigInteger bigInteger5 = bigInteger4.modInverse(bigInteger3);
            BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5);
            bigInteger6 = bigInteger6.multiply((BigInteger)vector.elementAt(n4));
            bigInteger = bigInteger.add(bigInteger6);
        }
        return bigInteger.mod(bigInteger2);
    }
}

