/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "org.bouncycastle.pkcs1.strict";
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "org.bouncycastle.pkcs1.not_strict";
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private int pLen = -1;
    private byte[] fallback = null;
    private byte[] blockBuffer;

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, int n4) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
        this.pLen = n4;
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, byte[] byArray) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
        this.fallback = byArray;
        this.pLen = byArray.length;
    }

    private boolean useStrict() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(PKCS1Encoding.STRICT_LENGTH_ENABLED_PROPERTY);
            }
        });
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(PKCS1Encoding.NOT_STRICT_LENGTH_ENABLED_PROPERTY);
            }
        });
        if (string2 != null) {
            return !string2.equals("true");
        }
        return string == null || string.equals("true");
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
            if (!asymmetricKeyParameter.isPrivate() && bl) {
                this.random = new SecureRandom();
            }
        }
        this.engine.init(bl, cipherParameters);
        this.forPrivateKey = asymmetricKeyParameter.isPrivate();
        this.forEncryption = bl;
        this.blockBuffer = new byte[this.engine.getOutputBlockSize()];
        if (this.pLen > 0 && this.fallback == null && this.random == null) {
            throw new IllegalArgumentException("encoder requires random");
        }
    }

    public int getInputBlockSize() {
        int n4 = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n4 - 10;
        }
        return n4;
    }

    public int getOutputBlockSize() {
        int n4 = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n4;
        }
        return n4 - 10;
    }

    public byte[] processBlock(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n4, n5);
        }
        return this.decodeBlock(byArray, n4, n5);
    }

    private byte[] encodeBlock(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        if (n5 > this.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        byte[] byArray2 = new byte[this.engine.getInputBlockSize()];
        if (this.forPrivateKey) {
            byArray2[0] = 1;
            for (int i4 = 1; i4 != byArray2.length - n5 - 1; ++i4) {
                byArray2[i4] = -1;
            }
        } else {
            this.random.nextBytes(byArray2);
            byArray2[0] = 2;
            for (int i5 = 1; i5 != byArray2.length - n5 - 1; ++i5) {
                while (byArray2[i5] == 0) {
                    byArray2[i5] = (byte)this.random.nextInt();
                }
            }
        }
        byArray2[byArray2.length - n5 - 1] = 0;
        System.arraycopy(byArray, n4, byArray2, byArray2.length - n5, n5);
        return this.engine.processBlock(byArray2, 0, byArray2.length);
    }

    private static int checkPkcs1Encoding(byte[] byArray, int n4) {
        int n5 = 0;
        n5 |= byArray[0] ^ 2;
        int n6 = byArray.length - (n4 + 1);
        for (int i4 = 1; i4 < n6; ++i4) {
            int n7 = byArray[i4];
            n7 |= n7 >> 1;
            n7 |= n7 >> 2;
            n7 |= n7 >> 4;
            n5 |= (n7 & 1) - 1;
        }
        n5 |= byArray[byArray.length - (n4 + 1)];
        n5 |= n5 >> 1;
        n5 |= n5 >> 2;
        n5 |= n5 >> 4;
        return ~((n5 & 1) - 1);
    }

    private byte[] decodeBlockOrRandom(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        byte[] byArray2;
        if (!this.forPrivateKey) {
            throw new InvalidCipherTextException("sorry, this method is only for decryption, not for signing");
        }
        byte[] byArray3 = this.engine.processBlock(byArray, n4, n5);
        if (this.fallback == null) {
            byArray2 = new byte[this.pLen];
            this.random.nextBytes(byArray2);
        } else {
            byArray2 = this.fallback;
        }
        byte[] byArray4 = this.useStrictLength & byArray3.length != this.engine.getOutputBlockSize() ? this.blockBuffer : byArray3;
        int n6 = PKCS1Encoding.checkPkcs1Encoding(byArray4, this.pLen);
        byte[] byArray5 = new byte[this.pLen];
        for (int i4 = 0; i4 < this.pLen; ++i4) {
            byArray5[i4] = (byte)(byArray4[i4 + (byArray4.length - this.pLen)] & ~n6 | byArray2[i4] & n6);
        }
        Arrays.fill(byArray4, (byte)0);
        return byArray5;
    }

    private byte[] decodeBlock(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        if (this.pLen != -1) {
            return this.decodeBlockOrRandom(byArray, n4, n5);
        }
        byte[] byArray2 = this.engine.processBlock(byArray, n4, n5);
        boolean bl = this.useStrictLength & byArray2.length != this.engine.getOutputBlockSize();
        byte[] byArray3 = byArray2.length < this.getOutputBlockSize() ? this.blockBuffer : byArray2;
        byte by = byArray3[0];
        boolean bl2 = this.forPrivateKey ? by != 2 : by != 1;
        int n6 = this.findStart(by, byArray3);
        if (bl2 | ++n6 < 10) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("block incorrect");
        }
        if (bl) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("block incorrect size");
        }
        byte[] byArray4 = new byte[byArray3.length - n6];
        System.arraycopy(byArray3, n6, byArray4, 0, byArray4.length);
        return byArray4;
    }

    private int findStart(byte by, byte[] byArray) throws InvalidCipherTextException {
        int n4 = -1;
        boolean bl = false;
        for (int i4 = 1; i4 != byArray.length; ++i4) {
            byte by2 = byArray[i4];
            if (by2 == 0 & n4 < 0) {
                n4 = i4;
            }
            bl |= by == 1 & n4 < 0 & by2 != -1;
        }
        if (bl) {
            return -1;
        }
        return n4;
    }
}

