/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.GeneralNames;

public class IetfAttrSyntax
extends ASN1Object {
    public static final int VALUE_OCTETS = 1;
    public static final int VALUE_OID = 2;
    public static final int VALUE_UTF8 = 3;
    GeneralNames policyAuthority = null;
    Vector values = new Vector();
    int valueChoice = -1;

    public static IetfAttrSyntax getInstance(Object object) {
        if (object instanceof IetfAttrSyntax) {
            return (IetfAttrSyntax)object;
        }
        if (object != null) {
            return new IetfAttrSyntax(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private IetfAttrSyntax(ASN1Sequence aSN1Sequence) {
        int n4 = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.policyAuthority = GeneralNames.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(0), false);
            ++n4;
        } else if (aSN1Sequence.size() == 2) {
            this.policyAuthority = GeneralNames.getInstance(aSN1Sequence.getObjectAt(0));
            ++n4;
        }
        if (!(aSN1Sequence.getObjectAt(n4) instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Non-IetfAttrSyntax encoding");
        }
        aSN1Sequence = (ASN1Sequence)aSN1Sequence.getObjectAt(n4);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            int n5;
            ASN1Primitive aSN1Primitive = (ASN1Primitive)enumeration.nextElement();
            if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
                n5 = 2;
            } else if (aSN1Primitive instanceof DERUTF8String) {
                n5 = 3;
            } else if (aSN1Primitive instanceof DEROctetString) {
                n5 = 1;
            } else {
                throw new IllegalArgumentException("Bad value type encoding IetfAttrSyntax");
            }
            if (this.valueChoice < 0) {
                this.valueChoice = n5;
            }
            if (n5 != this.valueChoice) {
                throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
            }
            this.values.addElement(aSN1Primitive);
        }
    }

    public GeneralNames getPolicyAuthority() {
        return this.policyAuthority;
    }

    public int getValueType() {
        return this.valueChoice;
    }

    public Object[] getValues() {
        if (this.getValueType() == 1) {
            Object[] objectArray = new ASN1OctetString[this.values.size()];
            for (int i4 = 0; i4 != objectArray.length; ++i4) {
                objectArray[i4] = (ASN1OctetString)this.values.elementAt(i4);
            }
            return objectArray;
        }
        if (this.getValueType() == 2) {
            Object[] objectArray = new ASN1ObjectIdentifier[this.values.size()];
            for (int i5 = 0; i5 != objectArray.length; ++i5) {
                objectArray[i5] = (ASN1ObjectIdentifier)this.values.elementAt(i5);
            }
            return objectArray;
        }
        Object[] objectArray = new DERUTF8String[this.values.size()];
        for (int i6 = 0; i6 != objectArray.length; ++i6) {
            objectArray[i6] = (DERUTF8String)this.values.elementAt(i6);
        }
        return objectArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.policyAuthority != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.policyAuthority));
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        Enumeration enumeration = this.values.elements();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector2.add((ASN1Encodable)enumeration.nextElement());
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        return new DERSequence(aSN1EncodableVector);
    }
}

