/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.RevDetails;

public class RevReqContent
extends ASN1Object {
    private ASN1Sequence content;

    private RevReqContent(ASN1Sequence aSN1Sequence) {
        this.content = aSN1Sequence;
    }

    public static RevReqContent getInstance(Object object) {
        if (object instanceof RevReqContent) {
            return (RevReqContent)object;
        }
        if (object != null) {
            return new RevReqContent(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RevReqContent(RevDetails revDetails) {
        this.content = new DERSequence(revDetails);
    }

    public RevReqContent(RevDetails[] revDetailsArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i4 = 0; i4 != revDetailsArray.length; ++i4) {
            aSN1EncodableVector.add(revDetailsArray[i4]);
        }
        this.content = new DERSequence(aSN1EncodableVector);
    }

    public RevDetails[] toRevDetailsArray() {
        RevDetails[] revDetailsArray = new RevDetails[this.content.size()];
        for (int i4 = 0; i4 != revDetailsArray.length; ++i4) {
            revDetailsArray[i4] = RevDetails.getInstance(this.content.getObjectAt(i4));
        }
        return revDetailsArray;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.content;
    }
}

