/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.LimitedInputStream;

class StreamUtil {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();

    StreamUtil() {
    }

    static int findLimit(InputStream inputStream) {
        if (inputStream instanceof LimitedInputStream) {
            return ((LimitedInputStream)inputStream).getRemaining();
        }
        if (inputStream instanceof ASN1InputStream) {
            return ((ASN1InputStream)inputStream).getLimit();
        }
        if (inputStream instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)inputStream).available();
        }
        if (inputStream instanceof FileInputStream) {
            try {
                long l4;
                FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
                long l5 = l4 = fileChannel != null ? fileChannel.size() : Integer.MAX_VALUE;
                if (l4 < Integer.MAX_VALUE) {
                    return (int)l4;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }

    static int calculateBodyLength(int n4) {
        int n5 = 1;
        if (n4 > 127) {
            int n6 = 1;
            int n7 = n4;
            while ((n7 >>>= 8) != 0) {
                ++n6;
            }
            for (int i4 = (n6 - 1) * 8; i4 >= 0; i4 -= 8) {
                ++n5;
            }
        }
        return n5;
    }

    static int calculateTagLength(int n4) throws IOException {
        int n5 = 1;
        if (n4 >= 31) {
            if (n4 < 128) {
                ++n5;
            } else {
                byte[] byArray = new byte[5];
                int n6 = byArray.length;
                byArray[--n6] = (byte)(n4 & 0x7F);
                do {
                    byArray[--n6] = (byte)((n4 >>= 7) & 0x7F | 0x80);
                } while (n4 > 127);
                n5 += byArray.length - n6;
            }
        }
        return n5;
    }
}

