/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1ParsingException;

public class BERApplicationSpecific
extends ASN1ApplicationSpecific {
    BERApplicationSpecific(boolean bl, int n4, byte[] byArray) {
        super(bl, n4, byArray);
    }

    public BERApplicationSpecific(int n4, ASN1Encodable aSN1Encodable) throws IOException {
        this(true, n4, aSN1Encodable);
    }

    public BERApplicationSpecific(boolean bl, int n4, ASN1Encodable aSN1Encodable) throws IOException {
        super(bl || aSN1Encodable.toASN1Primitive().isConstructed(), n4, BERApplicationSpecific.getEncoding(bl, aSN1Encodable));
    }

    private static byte[] getEncoding(boolean bl, ASN1Encodable aSN1Encodable) throws IOException {
        byte[] byArray = aSN1Encodable.toASN1Primitive().getEncoded("BER");
        if (bl) {
            return byArray;
        }
        int n4 = BERApplicationSpecific.getLengthOfHeader(byArray);
        byte[] byArray2 = new byte[byArray.length - n4];
        System.arraycopy(byArray, n4, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public BERApplicationSpecific(int n4, ASN1EncodableVector aSN1EncodableVector) {
        super(true, n4, BERApplicationSpecific.getEncodedVector(aSN1EncodableVector));
    }

    private static byte[] getEncodedVector(ASN1EncodableVector aSN1EncodableVector) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i4 = 0; i4 != aSN1EncodableVector.size(); ++i4) {
            try {
                byteArrayOutputStream.write(((ASN1Object)aSN1EncodableVector.get(i4)).getEncoded("BER"));
                continue;
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("malformed object: " + iOException, iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        int n4 = 64;
        if (this.isConstructed) {
            n4 |= 0x20;
        }
        aSN1OutputStream.writeTag(n4, this.tag);
        aSN1OutputStream.write(128);
        aSN1OutputStream.write(this.octets);
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }
}

