/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DLOutputStream;

public class ASN1OutputStream {
    private OutputStream os;

    public ASN1OutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    void writeLength(int n4) throws IOException {
        if (n4 > 127) {
            int n5 = 1;
            int n6 = n4;
            while ((n6 >>>= 8) != 0) {
                ++n5;
            }
            this.write((byte)(n5 | 0x80));
            for (int i4 = (n5 - 1) * 8; i4 >= 0; i4 -= 8) {
                this.write((byte)(n4 >> i4));
            }
        } else {
            this.write((byte)n4);
        }
    }

    void write(int n4) throws IOException {
        this.os.write(n4);
    }

    void write(byte[] byArray) throws IOException {
        this.os.write(byArray);
    }

    void write(byte[] byArray, int n4, int n5) throws IOException {
        this.os.write(byArray, n4, n5);
    }

    void writeEncoded(int n4, byte[] byArray) throws IOException {
        this.write(n4);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    void writeTag(int n4, int n5) throws IOException {
        if (n5 < 31) {
            this.write(n4 | n5);
        } else {
            this.write(n4 | 0x1F);
            if (n5 < 128) {
                this.write(n5);
            } else {
                byte[] byArray = new byte[5];
                int n6 = byArray.length;
                byArray[--n6] = (byte)(n5 & 0x7F);
                do {
                    byArray[--n6] = (byte)((n5 >>= 7) & 0x7F | 0x80);
                } while (n5 > 127);
                this.write(byArray, n6, byArray.length - n6);
            }
        }
    }

    void writeEncoded(int n4, int n5, byte[] byArray) throws IOException {
        this.writeTag(n4, n5);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    protected void writeNull() throws IOException {
        this.os.write(5);
        this.os.write(0);
    }

    public void writeObject(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable == null) {
            throw new IOException("null object detected");
        }
        aSN1Encodable.toASN1Primitive().encode(this);
    }

    void writeImplicitObject(ASN1Primitive aSN1Primitive) throws IOException {
        if (aSN1Primitive == null) {
            throw new IOException("null object detected");
        }
        aSN1Primitive.encode(new ImplicitOutputStream(this.os));
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    ASN1OutputStream getDERSubStream() {
        return new DEROutputStream(this.os);
    }

    ASN1OutputStream getDLSubStream() {
        return new DLOutputStream(this.os);
    }

    private class ImplicitOutputStream
    extends ASN1OutputStream {
        private boolean first;

        public ImplicitOutputStream(OutputStream outputStream) {
            super(outputStream);
            this.first = true;
        }

        public void write(int n4) throws IOException {
            if (this.first) {
                this.first = false;
            } else {
                super.write(n4);
            }
        }
    }
}

