/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Exception;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.BERApplicationSpecificParser;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.BERTags;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERExternal;
import org.bouncycastle.asn1.DERExternalParser;
import org.bouncycastle.asn1.DERFactory;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGraphicString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVideotexString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;
import org.bouncycastle.asn1.LazyEncodedSequence;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.io.Streams;

public class ASN1InputStream
extends FilterInputStream
implements BERTags {
    private final int limit;
    private final boolean lazyEvaluate;
    private final byte[][] tmpBuffers;

    public ASN1InputStream(InputStream inputStream) {
        this(inputStream, StreamUtil.findLimit(inputStream));
    }

    public ASN1InputStream(byte[] byArray) {
        this((InputStream)new ByteArrayInputStream(byArray), byArray.length);
    }

    public ASN1InputStream(byte[] byArray, boolean bl) {
        this(new ByteArrayInputStream(byArray), byArray.length, bl);
    }

    public ASN1InputStream(InputStream inputStream, int n4) {
        this(inputStream, n4, false);
    }

    public ASN1InputStream(InputStream inputStream, boolean bl) {
        this(inputStream, StreamUtil.findLimit(inputStream), bl);
    }

    public ASN1InputStream(InputStream inputStream, int n4, boolean bl) {
        super(inputStream);
        this.limit = n4;
        this.lazyEvaluate = bl;
        this.tmpBuffers = new byte[11][];
    }

    int getLimit() {
        return this.limit;
    }

    protected int readLength() throws IOException {
        return ASN1InputStream.readLength(this, this.limit);
    }

    protected void readFully(byte[] byArray) throws IOException {
        if (Streams.readFully(this, byArray) != byArray.length) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected ASN1Primitive buildObject(int n4, int n5, int n6) throws IOException {
        boolean bl = (n4 & 0x20) != 0;
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this, n6);
        if ((n4 & 0x40) != 0) {
            return new DERApplicationSpecific(bl, n5, definiteLengthInputStream.toByteArray());
        }
        if ((n4 & 0x80) != 0) {
            return new ASN1StreamParser(definiteLengthInputStream).readTaggedObject(bl, n5);
        }
        if (bl) {
            switch (n5) {
                case 4: {
                    ASN1EncodableVector aSN1EncodableVector = this.buildDEREncodableVector(definiteLengthInputStream);
                    ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[aSN1EncodableVector.size()];
                    for (int i4 = 0; i4 != aSN1OctetStringArray.length; ++i4) {
                        aSN1OctetStringArray[i4] = (ASN1OctetString)aSN1EncodableVector.get(i4);
                    }
                    return new BEROctetString(aSN1OctetStringArray);
                }
                case 16: {
                    if (this.lazyEvaluate) {
                        return new LazyEncodedSequence(definiteLengthInputStream.toByteArray());
                    }
                    return DERFactory.createSequence(this.buildDEREncodableVector(definiteLengthInputStream));
                }
                case 17: {
                    return DERFactory.createSet(this.buildDEREncodableVector(definiteLengthInputStream));
                }
                case 8: {
                    return new DERExternal(this.buildDEREncodableVector(definiteLengthInputStream));
                }
            }
            throw new IOException("unknown tag " + n5 + " encountered");
        }
        return ASN1InputStream.createPrimitiveDERObject(n5, definiteLengthInputStream, this.tmpBuffers);
    }

    ASN1EncodableVector buildEncodableVector() throws IOException {
        ASN1Primitive aSN1Primitive;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((aSN1Primitive = this.readObject()) != null) {
            aSN1EncodableVector.add(aSN1Primitive);
        }
        return aSN1EncodableVector;
    }

    ASN1EncodableVector buildDEREncodableVector(DefiniteLengthInputStream definiteLengthInputStream) throws IOException {
        return new ASN1InputStream(definiteLengthInputStream).buildEncodableVector();
    }

    public ASN1Primitive readObject() throws IOException {
        int n4 = this.read();
        if (n4 <= 0) {
            if (n4 == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int n5 = ASN1InputStream.readTagNumber(this, n4);
        boolean bl = (n4 & 0x20) != 0;
        int n6 = this.readLength();
        if (n6 < 0) {
            if (!bl) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this, this.limit);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(indefiniteLengthInputStream, this.limit);
            if ((n4 & 0x40) != 0) {
                return new BERApplicationSpecificParser(n5, aSN1StreamParser).getLoadedObject();
            }
            if ((n4 & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n5, aSN1StreamParser).getLoadedObject();
            }
            switch (n5) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(aSN1StreamParser).getLoadedObject();
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        try {
            return this.buildObject(n4, n5, n6);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
        }
    }

    static int readTagNumber(InputStream inputStream, int n4) throws IOException {
        int n5 = n4 & 0x1F;
        if (n5 == 31) {
            n5 = 0;
            int n6 = inputStream.read();
            if ((n6 & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (n6 >= 0 && (n6 & 0x80) != 0) {
                n5 |= n6 & 0x7F;
                n5 <<= 7;
                n6 = inputStream.read();
            }
            if (n6 < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            n5 |= n6 & 0x7F;
        }
        return n5;
    }

    static int readLength(InputStream inputStream, int n4) throws IOException {
        int n5 = inputStream.read();
        if (n5 < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (n5 == 128) {
            return -1;
        }
        if (n5 > 127) {
            int n6 = n5 & 0x7F;
            if (n6 > 4) {
                throw new IOException("DER length more than 4 bytes: " + n6);
            }
            n5 = 0;
            for (int i4 = 0; i4 < n6; ++i4) {
                int n7 = inputStream.read();
                if (n7 < 0) {
                    throw new EOFException("EOF found reading length");
                }
                n5 = (n5 << 8) + n7;
            }
            if (n5 < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n5 >= n4) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n5;
    }

    private static byte[] getBuffer(DefiniteLengthInputStream definiteLengthInputStream, byte[][] byArray) throws IOException {
        int n4 = definiteLengthInputStream.getRemaining();
        if (definiteLengthInputStream.getRemaining() < byArray.length) {
            byte[] byArray2 = byArray[n4];
            if (byArray2 == null) {
                byArray[n4] = new byte[n4];
                byArray2 = byArray[n4];
            }
            Streams.readFully(definiteLengthInputStream, byArray2);
            return byArray2;
        }
        return definiteLengthInputStream.toByteArray();
    }

    private static char[] getBMPCharBuffer(DefiniteLengthInputStream definiteLengthInputStream) throws IOException {
        int n4;
        int n5;
        int n6 = definiteLengthInputStream.getRemaining() / 2;
        char[] cArray = new char[n6];
        int n7 = 0;
        while (n7 < n6 && (n5 = definiteLengthInputStream.read()) >= 0 && (n4 = definiteLengthInputStream.read()) >= 0) {
            cArray[n7++] = (char)(n5 << 8 | n4 & 0xFF);
        }
        return cArray;
    }

    static ASN1Primitive createPrimitiveDERObject(int n4, DefiniteLengthInputStream definiteLengthInputStream, byte[][] byArray) throws IOException {
        switch (n4) {
            case 3: {
                return ASN1BitString.fromInputStream(definiteLengthInputStream.getRemaining(), definiteLengthInputStream);
            }
            case 30: {
                return new DERBMPString(ASN1InputStream.getBMPCharBuffer(definiteLengthInputStream));
            }
            case 1: {
                return ASN1Boolean.fromOctetString(ASN1InputStream.getBuffer(definiteLengthInputStream, byArray));
            }
            case 10: {
                return ASN1Enumerated.fromOctetString(ASN1InputStream.getBuffer(definiteLengthInputStream, byArray));
            }
            case 24: {
                return new ASN1GeneralizedTime(definiteLengthInputStream.toByteArray());
            }
            case 27: {
                return new DERGeneralString(definiteLengthInputStream.toByteArray());
            }
            case 22: {
                return new DERIA5String(definiteLengthInputStream.toByteArray());
            }
            case 2: {
                return new ASN1Integer(definiteLengthInputStream.toByteArray(), false);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(definiteLengthInputStream.toByteArray());
            }
            case 6: {
                return ASN1ObjectIdentifier.fromOctetString(ASN1InputStream.getBuffer(definiteLengthInputStream, byArray));
            }
            case 4: {
                return new DEROctetString(definiteLengthInputStream.toByteArray());
            }
            case 19: {
                return new DERPrintableString(definiteLengthInputStream.toByteArray());
            }
            case 20: {
                return new DERT61String(definiteLengthInputStream.toByteArray());
            }
            case 28: {
                return new DERUniversalString(definiteLengthInputStream.toByteArray());
            }
            case 23: {
                return new ASN1UTCTime(definiteLengthInputStream.toByteArray());
            }
            case 12: {
                return new DERUTF8String(definiteLengthInputStream.toByteArray());
            }
            case 26: {
                return new DERVisibleString(definiteLengthInputStream.toByteArray());
            }
            case 25: {
                return new DERGraphicString(definiteLengthInputStream.toByteArray());
            }
            case 21: {
                return new DERVideotexString(definiteLengthInputStream.toByteArray());
            }
        }
        throw new IOException("unknown tag " + n4 + " encountered");
    }
}

