/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;

public abstract class ASN1ApplicationSpecific
extends ASN1Primitive {
    protected final boolean isConstructed;
    protected final int tag;
    protected final byte[] octets;

    ASN1ApplicationSpecific(boolean bl, int n4, byte[] byArray) {
        this.isConstructed = bl;
        this.tag = n4;
        this.octets = Arrays.clone(byArray);
    }

    public static ASN1ApplicationSpecific getInstance(Object object) {
        if (object == null || object instanceof ASN1ApplicationSpecific) {
            return (ASN1ApplicationSpecific)object;
        }
        if (object instanceof byte[]) {
            try {
                return ASN1ApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to construct object from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    protected static int getLengthOfHeader(byte[] byArray) {
        int n4 = byArray[1] & 0xFF;
        if (n4 == 128) {
            return 2;
        }
        if (n4 > 127) {
            int n5 = n4 & 0x7F;
            if (n5 > 4) {
                throw new IllegalStateException("DER length more than 4 bytes: " + n5);
            }
            return n5 + 2;
        }
        return 2;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return Arrays.clone(this.octets);
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public ASN1Primitive getObject() throws IOException {
        return ASN1Primitive.fromByteArray(this.getContents());
    }

    public ASN1Primitive getObject(int n4) throws IOException {
        if (n4 >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = this.replaceTagNumber(n4, byArray);
        if ((byArray[0] & 0x20) != 0) {
            byArray2[0] = (byte)(byArray2[0] | 0x20);
        }
        return ASN1Primitive.fromByteArray(byArray2);
    }

    int encodedLength() throws IOException {
        return StreamUtil.calculateTagLength(this.tag) + StreamUtil.calculateBodyLength(this.octets.length) + this.octets.length;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        int n4 = 64;
        if (this.isConstructed) {
            n4 |= 0x20;
        }
        aSN1OutputStream.writeEncoded(n4, this.tag, this.octets);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1ApplicationSpecific)) {
            return false;
        }
        ASN1ApplicationSpecific aSN1ApplicationSpecific = (ASN1ApplicationSpecific)aSN1Primitive;
        return this.isConstructed == aSN1ApplicationSpecific.isConstructed && this.tag == aSN1ApplicationSpecific.tag && Arrays.areEqual(this.octets, aSN1ApplicationSpecific.octets);
    }

    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ Arrays.hashCode(this.octets);
    }

    private byte[] replaceTagNumber(int n4, byte[] byArray) throws IOException {
        int n5 = byArray[0] & 0x1F;
        int n6 = 1;
        if (n5 == 31) {
            int n7;
            n5 = 0;
            if (((n7 = byArray[n6++] & 0xFF) & 0x7F) == 0) {
                throw new ASN1ParsingException("corrupted stream - invalid high tag number found");
            }
            while (n7 >= 0 && (n7 & 0x80) != 0) {
                n5 |= n7 & 0x7F;
                n5 <<= 7;
                n7 = byArray[n6++] & 0xFF;
            }
        }
        byte[] byArray2 = new byte[byArray.length - n6 + 1];
        System.arraycopy(byArray, n6, byArray2, 1, byArray2.length - 1);
        byArray2[0] = (byte)n4;
        return byArray2;
    }
}

