/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@CanIgnoreReturnValue
abstract class AbstractByteHasher
extends AbstractHasher {
    private final ByteBuffer scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    AbstractByteHasher() {
    }

    protected abstract void update(byte var1);

    protected void update(byte[] b4) {
        this.update(b4, 0, b4.length);
    }

    protected void update(byte[] b4, int off, int len) {
        for (int i4 = off; i4 < off + len; ++i4) {
            this.update(b4[i4]);
        }
    }

    protected void update(ByteBuffer b4) {
        if (b4.hasArray()) {
            this.update(b4.array(), b4.arrayOffset() + b4.position(), b4.remaining());
            Java8Compatibility.position(b4, b4.limit());
        } else {
            for (int remaining = b4.remaining(); remaining > 0; --remaining) {
                this.update(b4.get());
            }
        }
    }

    private Hasher update(int bytes) {
        try {
            this.update(this.scratch.array(), 0, bytes);
        }
        finally {
            Java8Compatibility.clear(this.scratch);
        }
        return this;
    }

    @Override
    public Hasher putByte(byte b4) {
        this.update(b4);
        return this;
    }

    @Override
    public Hasher putBytes(byte[] bytes) {
        Preconditions.checkNotNull(bytes);
        this.update(bytes);
        return this;
    }

    @Override
    public Hasher putBytes(byte[] bytes, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        this.update(bytes, off, len);
        return this;
    }

    @Override
    public Hasher putBytes(ByteBuffer bytes) {
        this.update(bytes);
        return this;
    }

    @Override
    public Hasher putShort(short s4) {
        this.scratch.putShort(s4);
        return this.update(2);
    }

    @Override
    public Hasher putInt(int i4) {
        this.scratch.putInt(i4);
        return this.update(4);
    }

    @Override
    public Hasher putLong(long l4) {
        this.scratch.putLong(l4);
        return this.update(8);
    }

    @Override
    public Hasher putChar(char c4) {
        this.scratch.putChar(c4);
        return this.update(2);
    }
}

