/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedEscaperMap;
import com.google.common.escape.CharEscaper;
import java.util.Map;

@Beta
@GwtCompatible
public abstract class ArrayBasedCharEscaper
extends CharEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final char safeMin;
    private final char safeMax;

    protected ArrayBasedCharEscaper(Map<Character, String> replacementMap, char safeMin, char safeMax) {
        this(ArrayBasedEscaperMap.create(replacementMap), safeMin, safeMax);
    }

    protected ArrayBasedCharEscaper(ArrayBasedEscaperMap escaperMap, char safeMin, char safeMax) {
        Preconditions.checkNotNull(escaperMap);
        this.replacements = escaperMap.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        if (safeMax < safeMin) {
            safeMax = '\u0000';
            safeMin = (char)65535;
        }
        this.safeMin = safeMin;
        this.safeMax = safeMax;
    }

    @Override
    public final String escape(String s4) {
        Preconditions.checkNotNull(s4);
        for (int i4 = 0; i4 < s4.length(); ++i4) {
            char c4 = s4.charAt(i4);
            if ((c4 >= this.replacementsLength || this.replacements[c4] == null) && c4 <= this.safeMax && c4 >= this.safeMin) continue;
            return this.escapeSlow(s4, i4);
        }
        return s4;
    }

    @Override
    protected final char[] escape(char c4) {
        char[] chars;
        if (c4 < this.replacementsLength && (chars = this.replacements[c4]) != null) {
            return chars;
        }
        if (c4 >= this.safeMin && c4 <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe(c4);
    }

    protected abstract char[] escapeUnsafe(char var1);
}

