/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.TokenizedCommandLineKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0007J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0007J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020\u0007J \u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00072\b\b\u0002\u0010(\u001a\u00020\u0005J\b\u0010)\u001a\u00020\u0003H\u0016J\u000e\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,J \u0010-\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0005H\u0007J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010/\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/utils/TokenizedCommandLine;", "", "commandLine", "", "raw", "", "platform", "", "indexes", "", "(Ljava/lang/String;ZI[I)V", "getCommandLine", "()Ljava/lang/String;", "generation", "getPlatform", "()I", "getRaw", "()Z", "toStringValue", "charAt", "", "i", "(I)Ljava/lang/Character;", "checkGeneration", "", "computeNormalizedCommandLineHashCode", "invalidate", "isEndOfCommand", "isEndOfToken", "isStartOfToken", "nextTokenAfter", "offset", "normalizedCommandLineEquals", "other", "normalizedCommandLineLength", "removeNth", "n", "removeTokenGroup", "token", "extra", "matchPrefix", "toString", "separator", "toTokenList", "", "tokenMatches", "zeroAllocTokenizePOSIX", "zeroAllocTokenizeWindows", "common"})
public final class TokenizedCommandLine {
    @NotNull
    private final String commandLine;
    private final boolean raw;
    private final int platform;
    @NotNull
    private int[] indexes;
    private final int generation;
    @Nullable
    private String toStringValue;

    public TokenizedCommandLine(@NotNull String commandLine, boolean raw, int platform, @NotNull int[] indexes) {
        Intrinsics.checkParameterIsNotNull(commandLine, "commandLine");
        Intrinsics.checkParameterIsNotNull(indexes, "indexes");
        this.commandLine = commandLine;
        this.raw = raw;
        this.platform = platform;
        int[] nArray = this.indexes = indexes;
        nArray[0] = nArray[0] + 1;
        this.generation = nArray[0];
        this.checkGeneration();
        if (this.platform == 2) {
            this.zeroAllocTokenizeWindows(this.raw);
        } else {
            this.zeroAllocTokenizePOSIX(this.raw);
        }
    }

    public /* synthetic */ TokenizedCommandLine(String string, boolean bl, int n4, int[] nArray, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n4 = SdkConstants.currentPlatform();
        }
        if ((n5 & 8) != 0) {
            nArray = TokenizedCommandLineKt.allocateTokenizeCommandLineBuffer(string);
        }
        this(string, bl, n4, nArray);
    }

    @NotNull
    public final String getCommandLine() {
        return this.commandLine;
    }

    public final boolean getRaw() {
        return this.raw;
    }

    public final int getPlatform() {
        return this.platform;
    }

    public final void removeTokenGroup(@NotNull String token, int extra, boolean matchPrefix) {
        Intrinsics.checkParameterIsNotNull(token, "token");
        this.checkGeneration();
        this.invalidate();
        int read = 1;
        int write = 1;
        do {
            int n4 = read >= write ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            if (_Assertions.ENABLED && n4 == 0) {
                boolean bl3 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n4 = this.isStartOfToken(read);
            bl = false;
            bl2 = false;
            if (_Assertions.ENABLED && n4 == 0) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n4 = this.isStartOfToken(write);
            bl = false;
            bl2 = false;
            if (_Assertions.ENABLED && n4 == 0) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (this.tokenMatches(token, read, matchPrefix)) {
                for (int count = 0; count != extra + 1 && !this.isEndOfCommand(read); ++count) {
                    read = this.nextTokenAfter(read);
                }
            } else {
                if (this.isEndOfCommand(read) || this.isEndOfCommand(write)) continue;
                do {
                    n4 = write;
                    write = n4 + 1;
                    int n5 = n4;
                    n4 = read;
                    read = n4 + 1;
                    this.indexes[n5] = this.indexes[n4];
                } while (!this.isEndOfToken(read - 1));
            }
        } while (!this.isEndOfCommand(read));
        this.indexes[write] = Integer.MIN_VALUE;
    }

    public static /* synthetic */ void removeTokenGroup$default(TokenizedCommandLine tokenizedCommandLine, String string, int n4, boolean bl, int n5, Object object) {
        if ((n5 & 4) != 0) {
            bl = false;
        }
        tokenizedCommandLine.removeTokenGroup(string, n4, bl);
    }

    @Nullable
    public final String removeNth(int n4) {
        this.checkGeneration();
        this.invalidate();
        StringBuilder token = new StringBuilder();
        int tokenNumber = 0;
        int write = 1;
        int n5 = 1;
        int n6 = this.indexes.length;
        if (n5 < n6) {
            block4: do {
                int read = n5++;
                if (tokenNumber != n4) {
                    int n7 = write;
                    write = n7 + 1;
                    this.indexes[n7] = this.indexes[read];
                }
                int offset = this.indexes[read];
                switch (offset) {
                    case -2147483648: {
                        CharSequence charSequence = token;
                        boolean bl = false;
                        if (charSequence.length() == 0) {
                            return null;
                        }
                        return token.toString();
                    }
                    case 0x7FFFFFFF: {
                        int n8 = tokenNumber;
                        tokenNumber = n8 + 1;
                        break;
                    }
                    default: {
                        if (tokenNumber != n4) continue block4;
                        token.append(this.commandLine.charAt(offset));
                    }
                }
            } while (n5 < n6);
        }
        return null;
    }

    @NotNull
    public final List<String> toTokenList() {
        this.checkGeneration();
        boolean bl = false;
        List result = new ArrayList();
        StringBuilder token = new StringBuilder();
        int i4 = 1;
        while (!this.isEndOfCommand(i4)) {
            Character c4 = this.charAt(i4);
            if (c4 == null) {
                CharSequence charSequence = token;
                boolean bl2 = false;
                if (charSequence.length() > 0) {
                    charSequence = token.toString();
                    Intrinsics.checkExpressionValueIsNotNull(charSequence, "token.toString()");
                    result.add(charSequence);
                    token.setLength(0);
                }
            } else {
                token.append(c4.charValue());
            }
            ++i4;
        }
        return result;
    }

    private final TokenizedCommandLine zeroAllocTokenizeWindows(boolean raw) {
        int n4;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        int i4 = 0;
        int length = this.commandLine.length();
        Character c4 = null;
        int offset = 0;
        offset = 1;
        while (i4 < length && Character.isWhitespace(this.commandLine.charAt(i4))) {
            n4 = i4;
            i4 = n4 + 1;
        }
        block1: while (i4 < length) {
            c4 = Character.valueOf(this.commandLine.charAt(i4));
            n4 = 34;
            if (c4.charValue() == n4) {
                if (raw) {
                    n4 = offset;
                    offset = n4 + 1;
                    this.indexes[n4] = i4;
                }
                quoting = !quoting;
                ++i4;
                continue;
            }
            n4 = 92;
            if (c4.charValue() == n4) {
                boolean quote;
                int forward = i4 + 1;
                int slashCount = 1;
                c4 = StringsKt.getOrNull(this.commandLine, forward);
                while (true) {
                    Character c5 = c4;
                    char c6 = '\\';
                    if (c5 == null || c5.charValue() != c6) break;
                    ++slashCount;
                    c4 = StringsKt.getOrNull(this.commandLine, ++forward);
                }
                boolean odd = slashCount % 2 == 1;
                Character c7 = c4;
                int n5 = 34;
                boolean bl = quote = c7 != null && c7.charValue() == n5;
                if (!raw && quote) {
                    slashCount /= 2;
                }
                n5 = 0;
                int n6 = 0;
                n6 = 0;
                int n7 = slashCount;
                while (n6 < n7) {
                    int j4 = n6++;
                    boolean bl2 = false;
                    int n8 = offset;
                    offset = n8 + 1;
                    this.indexes[n8] = i4 + j4;
                }
                if (odd && quote) {
                    n5 = offset;
                    offset = n5 + 1;
                    int n9 = n5;
                    n5 = forward;
                    forward = n5 + 1;
                    this.indexes[n9] = n5;
                }
                i4 = forward;
                continue;
            }
            if (!quoting) {
                n4 = 94;
                if (c4.charValue() == n4) {
                    c4 = StringsKt.getOrNull(this.commandLine, ++i4);
                    if (raw || c4 == null) {
                        n4 = offset;
                        offset = n4 + 1;
                        this.indexes[n4] = i4 - 1;
                    }
                    Character c8 = c4;
                    n4 = 94;
                    if (c8 != null && c8.charValue() == n4) {
                        n4 = offset;
                        offset = n4 + 1;
                        int n10 = n4;
                        n4 = i4;
                        i4 = n4 + 1;
                        this.indexes[n10] = n4;
                    }
                    while (true) {
                        Character c9 = c4;
                        n4 = 13;
                        if (c9 == null || c9.charValue() != n4) {
                            Character c10 = c4;
                            n4 = 10;
                            if (c10 == null || c10.charValue() != n4) continue block1;
                        }
                        c4 = StringsKt.getOrNull(this.commandLine, ++i4);
                    }
                }
            }
            if (!quoting && Character.isWhitespace(c4.charValue())) {
                n4 = offset;
                offset = n4 + 1;
                this.indexes[n4] = Integer.MAX_VALUE;
                c4 = StringsKt.getOrNull(this.commandLine, ++i4);
                while (c4 != null && Character.isWhitespace(c4.charValue())) {
                    c4 = StringsKt.getOrNull(this.commandLine, ++i4);
                }
                continue;
            }
            n4 = offset;
            offset = n4 + 1;
            int n11 = n4;
            n4 = i4;
            i4 = n4 + 1;
            this.indexes[n11] = n4;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n4 = offset;
            offset = n4 + 1;
            this.indexes[n4] = Integer.MAX_VALUE;
        }
        n4 = offset;
        offset = n4 + 1;
        this.indexes[n4] = Integer.MIN_VALUE;
        return this;
    }

    private final TokenizedCommandLine zeroAllocTokenizePOSIX(boolean raw) {
        int n4;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        boolean skipping = true;
        int i4 = 0;
        char c4 = '\u0000';
        int length = this.commandLine.length();
        int offset = 1;
        while (i4 < length) {
            n4 = i4;
            i4 = n4 + 1;
            c4 = this.commandLine.charAt(n4);
            if (skipping) {
                if (Character.isWhitespace(c4)) continue;
                skipping = false;
            }
            if ((quoting || !Character.isWhitespace(c4)) && raw) {
                n4 = offset;
                offset = n4 + 1;
                this.indexes[n4] = i4 - 1;
            }
            if (escaping) {
                escaping = false;
                if (c4 == '\n' || raw) continue;
                n4 = offset;
                offset = n4 + 1;
                this.indexes[n4] = i4 - 1;
                continue;
            }
            if (!(c4 != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c4 != '\"' && c4 != '\'')) {
                quoting = true;
                quote = c4;
                continue;
            }
            if (quoting && c4 == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (!quoting && Character.isWhitespace(c4)) {
                skipping = true;
                n4 = offset;
                offset = n4 + 1;
                this.indexes[n4] = Integer.MAX_VALUE;
                continue;
            }
            if (raw) continue;
            n4 = offset;
            offset = n4 + 1;
            this.indexes[n4] = i4 - 1;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n4 = offset;
            offset = n4 + 1;
            this.indexes[n4] = Integer.MAX_VALUE;
        }
        this.indexes[offset] = Integer.MIN_VALUE;
        return this;
    }

    @VisibleForTesting
    public final boolean tokenMatches(@NotNull String token, int offset, boolean matchPrefix) {
        Intrinsics.checkParameterIsNotNull(token, "token");
        this.checkGeneration();
        int i4 = 0;
        int index = this.indexes[offset];
        while (index != Integer.MIN_VALUE) {
            boolean endOfToken;
            boolean bl = endOfToken = index == Integer.MAX_VALUE;
            if (i4 == token.length()) {
                return endOfToken || matchPrefix;
            }
            if (endOfToken) {
                return false;
            }
            if (token.charAt(i4) != this.commandLine.charAt(index)) {
                return false;
            }
            index = this.indexes[offset + ++i4];
        }
        return false;
    }

    @VisibleForTesting
    public final int nextTokenAfter(int offset) {
        this.checkGeneration();
        int result = offset;
        while (!this.isEndOfToken(result) && !this.isEndOfCommand(result)) {
            ++result;
        }
        return result + 1;
    }

    private final boolean isEndOfToken(int i4) {
        return i4 < this.indexes.length && this.indexes[i4] == Integer.MAX_VALUE;
    }

    private final boolean isEndOfCommand(int i4) {
        return i4 >= this.indexes.length || this.indexes[i4] == Integer.MIN_VALUE;
    }

    private final boolean isStartOfToken(int i4) {
        return i4 == 1 || this.isEndOfToken(i4 - 1);
    }

    private final Character charAt(int i4) {
        return this.isEndOfToken(i4) ? null : Character.valueOf(this.commandLine.charAt(this.indexes[i4]));
    }

    public final int normalizedCommandLineLength() {
        int n4;
        if (this.isEndOfCommand(1)) {
            n4 = 0;
        } else {
            int i4 = 1;
            while (!this.isEndOfCommand(i4 + 1)) {
                ++i4;
            }
            n4 = i4 - 1;
        }
        return n4;
    }

    public final int computeNormalizedCommandLineHashCode() {
        this.checkGeneration();
        long hash = 1469598103934665603L;
        int i4 = 1;
        while (!this.isEndOfCommand(i4) && !this.isEndOfCommand(i4 + 1)) {
            Character c4 = this.charAt(i4);
            hash ^= (long)(c4 == null ? 32 : (int)c4.charValue());
            hash *= 1099511628211L;
            ++i4;
        }
        return (int)hash;
    }

    public final boolean normalizedCommandLineEquals(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        int length1 = this.normalizedCommandLineLength();
        int length2 = other.length();
        if (length1 == 0 && length2 == 0) {
            return true;
        }
        if (length1 != length2) {
            return false;
        }
        int n4 = 1;
        if (n4 < length1) {
            do {
                int i4;
                Character c4;
                if (((c4 = this.charAt(i4 = n4++)) == null ? (char)' ' : (char)c4.charValue()) == other.charAt(i4 - 1)) continue;
                return false;
            } while (n4 < length1);
        }
        return true;
    }

    @NotNull
    public final String toString(@NotNull String separator) {
        Object object;
        Intrinsics.checkParameterIsNotNull(separator, "separator");
        this.checkGeneration();
        int i4 = 1;
        if (this.isEndOfCommand(i4)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (!this.isEndOfCommand(i4 + 1)) {
            object = this.charAt(i4);
            sb.append(object == null ? separator : object);
            ++i4;
        }
        object = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(object, "sb.toString()");
        return object;
    }

    @NotNull
    public String toString() {
        if (this.toStringValue != null) {
            String string = this.toStringValue;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }
        this.toStringValue = this.toString(" ");
        String string = this.toStringValue;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    private final void invalidate() {
        this.toStringValue = null;
    }

    private final void checkGeneration() {
        int n4 = this.indexes[0];
        boolean bl = false;
        if (this.generation != Math.abs(n4)) {
            throw new Exception("Buffer indexes was shared with another TokenizedCommandLine after this one");
        }
    }
}

