/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.TokenizedCommandLine;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/android/utils/StringHelperWindows;", "", "()V", "splitCommandLine", "", "", "commandLine", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "common"})
public final class StringHelperWindows {
    @NotNull
    public static final StringHelperWindows INSTANCE = new StringHelperWindows();

    private StringHelperWindows() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitCommandLine(@NotNull String commandLine) {
        int n4;
        Intrinsics.checkParameterIsNotNull(commandLine, "commandLine");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "newArrayList()");
        List commands = arrayList;
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        int commandStart = 0;
        int length = commandLine.length();
        int i4 = 0;
        while (i4 < length) {
            char c4 = commandLine.charAt(i4);
            if (c4 == '\"' && !escapingQuotes) {
                quoting = !quoting;
                ++i4;
                continue;
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c4 == '\\') {
                escapingQuotes = true;
                ++i4;
                continue;
            }
            if (escapingOthers) {
                escapingOthers = false;
                ++i4;
                continue;
            }
            if (c4 == '^') {
                escapingOthers = true;
                ++i4;
                continue;
            }
            if (!quoting && commandLine.charAt(i4) == '&') {
                String string = commandLine;
                boolean bl = false;
                String string2 = string.substring(commandStart, i4);
                Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                commands.add(string2);
                n4 = i4;
                i4 = n4 + 1;
                if (commandLine.length() > i4 && commandLine.charAt(i4) == '&') {
                    n4 = i4;
                    i4 = n4 + 1;
                }
                commandStart = i4;
            }
            ++i4;
        }
        if (commandStart < length) {
            String string = commandLine;
            n4 = 0;
            String string3 = string.substring(commandStart);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
            commands.add(string3);
        }
        return commands;
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull(commandLine, "commandLine");
        return new TokenizedCommandLine(commandLine, false, 2, null, 8, null).toTokenList();
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull(commandLine, "commandLine");
        return new TokenizedCommandLine(commandLine, true, 2, null, 8, null).toTokenList();
    }
}

