/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.CharSequenceReader;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CharSequences {
    public static int indexOf(CharSequence sequence, char c4) {
        return CharSequences.indexOf(sequence, c4, 0);
    }

    public static int indexOf(CharSequence sequence, char c4, int start) {
        for (int i4 = start; i4 < sequence.length(); ++i4) {
            if (sequence.charAt(i4) != c4) continue;
            return i4;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle, int start) {
        int length = haystack.length();
        int needleLength = needle.length();
        if (needleLength <= length && start >= 0) {
            if (needleLength > 0) {
                if (start > length - needleLength) {
                    start = length - needleLength;
                }
                char firstChar = needle.charAt(0);
                while (true) {
                    int i4;
                    if ((i4 = CharSequences.lastIndexOf(haystack, firstChar, start)) == -1) {
                        return -1;
                    }
                    int o12 = i4;
                    int o22 = 0;
                    while (++o22 < needleLength && haystack.charAt(++o12) == needle.charAt(o22)) {
                    }
                    if (o22 == needleLength) {
                        return i4;
                    }
                    start = i4 - 1;
                }
            }
            return start < length ? start : length;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence sequence, char c4) {
        return CharSequences.lastIndexOf(sequence, c4, sequence.length());
    }

    public static int lastIndexOf(CharSequence sequence, int c4, int start) {
        int length = sequence.length();
        if (start >= 0) {
            if (start >= length) {
                start = length - 1;
            }
            for (int i4 = start; i4 >= 0; --i4) {
                if (sequence.charAt(i4) != c4) continue;
                return i4;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle) {
        return CharSequences.lastIndexOf(haystack, needle, haystack.length());
    }

    public static boolean regionMatches(CharSequence sequence, int thisStart, CharSequence string, int start, int length) {
        if (start < 0 || string.length() - start < length) {
            return false;
        }
        if (thisStart < 0 || sequence.length() - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        for (int i4 = 0; i4 < length; ++i4) {
            if (sequence.charAt(thisStart + i4) == string.charAt(start + i4)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence sequence, boolean ignoreCase, int thisStart, CharSequence string, int start, int length) {
        if (!ignoreCase) {
            return CharSequences.regionMatches(sequence, thisStart, string, start, length);
        }
        if (thisStart < 0 || length > sequence.length() - thisStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int end = thisStart + length;
        while (thisStart < end) {
            char c22;
            char c12;
            if ((c12 = sequence.charAt(thisStart++)) == (c22 = string.charAt(start++)) || CharSequences.foldCase(c12) == CharSequences.foldCase(c22)) continue;
            return false;
        }
        return true;
    }

    private static char foldCase(char ch) {
        if (ch < '\u0080') {
            if ('A' <= ch && ch <= 'Z') {
                return (char)(ch + 32);
            }
            return ch;
        }
        return Character.toLowerCase(Character.toUpperCase(ch));
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix) {
        return CharSequences.startsWith(sequence, prefix, 0);
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix, int start) {
        int prefixLength;
        int sequenceLength = sequence.length();
        if (sequenceLength < start + (prefixLength = prefix.length())) {
            return false;
        }
        int i4 = start;
        for (int j4 = 0; j4 < prefixLength; ++j4) {
            if (sequence.charAt(i4) != prefix.charAt(j4)) {
                return false;
            }
            ++i4;
        }
        return true;
    }

    public static boolean endsWith(CharSequence sequence, CharSequence suffix, boolean caseSensitive) {
        if (suffix.length() > sequence.length()) {
            return false;
        }
        int suffixLength = suffix.length();
        int sequenceLength = sequence.length();
        int i4 = sequenceLength - suffixLength;
        int j4 = 0;
        while (i4 < sequenceLength) {
            char c22;
            char c12 = sequence.charAt(i4);
            if (c12 != (c22 = suffix.charAt(j4))) {
                if (caseSensitive) {
                    return false;
                }
                if (Character.toLowerCase(c12) != Character.toLowerCase(c22)) {
                    return false;
                }
            }
            ++i4;
            ++j4;
        }
        return true;
    }

    public static boolean containsUpperCase(CharSequence s4) {
        if (s4 != null) {
            int n4 = s4.length();
            for (int i4 = 0; i4 < n4; ++i4) {
                if (!Character.isUpperCase(s4.charAt(i4))) continue;
                return true;
            }
        }
        return false;
    }

    public static int indexOf(CharSequence haystack, CharSequence needle) {
        return CharSequences.indexOf(haystack, needle, 0);
    }

    public static int indexOf(CharSequence haystack, CharSequence needle, int start) {
        int needleLength = needle.length();
        if (needleLength == 0) {
            return start;
        }
        char first = needle.charAt(0);
        if (needleLength == 1) {
            return CharSequences.indexOf(haystack, first, start);
        }
        int max = haystack.length() - needleLength;
        block0: for (int i4 = start; i4 <= max; ++i4) {
            if (haystack.charAt(i4) != first) continue;
            int h4 = i4 + 1;
            for (int n4 = 1; n4 < needleLength; ++n4) {
                if (haystack.charAt(h4) != needle.charAt(n4)) continue block0;
                ++h4;
            }
            return i4;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence where, CharSequence what, int fromIndex) {
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i4 = fromIndex; i4 <= max; ++i4) {
            if (!CharSequences.charsEqualIgnoreCase(where.charAt(i4), first)) {
                while (++i4 <= max && !CharSequences.charsEqualIgnoreCase(where.charAt(i4), first)) {
                }
            }
            if (i4 > max) continue;
            int j4 = i4 + 1;
            int end = j4 + targetCount - 1;
            int k4 = 1;
            while (j4 < end && CharSequences.charsEqualIgnoreCase(where.charAt(j4), what.charAt(k4))) {
                ++j4;
                ++k4;
            }
            if (j4 != end) continue;
            return i4;
        }
        return -1;
    }

    private static boolean charsEqualIgnoreCase(char c12, char c22) {
        return CharSequences.toUpperCase(c12) == CharSequences.toUpperCase(c22) || CharSequences.toLowerCase(c12) == CharSequences.toLowerCase(c22);
    }

    public static char toUpperCase(char c4) {
        if (c4 < 'a') {
            return c4;
        }
        if (c4 <= 'z') {
            return (char)(c4 + -32);
        }
        return Character.toUpperCase(c4);
    }

    public static char toLowerCase(char c4) {
        if (c4 < 'A' || c4 >= 'a' && c4 <= 'z') {
            return c4;
        }
        if (c4 <= 'Z') {
            return (char)(c4 + 32);
        }
        return Character.toLowerCase(c4);
    }

    public static CharSequence createSequence(char[] data) {
        return new ArrayBackedCharSequence(data);
    }

    public static CharSequence createSequence(char[] data, int offset, int length) {
        return new ArrayBackedCharSequence(data, offset, length);
    }

    public static char[] getCharArray(CharSequence sequence) {
        if (sequence instanceof ArrayBackedCharSequence) {
            return ((ArrayBackedCharSequence)sequence).getCharArray();
        }
        return sequence.toString().toCharArray();
    }

    public static CharSequenceReader getReader(CharSequence data, boolean stripBom) {
        CharSequenceReader reader = new CharSequenceReader(data);
        if (stripBom && data.length() > 0 && data.charAt(0) == '\ufeff') {
            reader.read();
        }
        return reader;
    }

    public static Document parseDocumentSilently(CharSequence xml, boolean namespaceAware) {
        try {
            CharSequenceReader reader = CharSequences.getReader(xml, true);
            return XmlUtils.parseDocument(reader, namespaceAware);
        }
        catch (IOException | SAXException exception) {
            return null;
        }
    }

    public static InputStream getInputStream(CharSequence text) {
        return new ByteArrayInputStream(text.toString().getBytes(Charsets.UTF_8));
    }

    private static class ArrayBackedCharSequence
    implements CharSequence {
        public final char[] data;
        private final int offset;
        private final int length;

        public ArrayBackedCharSequence(char[] data) {
            this(data, 0, data.length);
        }

        public ArrayBackedCharSequence(char[] data, int offset, int length) {
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public char[] getCharArray() {
            if (this.offset == 0 && this.length == this.data.length) {
                return this.data;
            }
            return Arrays.copyOfRange(this.data, this.offset, this.offset + this.length);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.data[this.offset + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ArrayBackedCharSequence(this.data, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            return new String(this.data, this.offset, this.length);
        }
    }
}

