/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.shards;

import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.mergers.SameTargetingMerger;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.shards.SuffixStripper;
import com.android.tools.build.bundletool.splitters.AbiApexImagesSplitter;
import com.android.tools.build.bundletool.splitters.AbiNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.LanguageAssetsSplitter;
import com.android.tools.build.bundletool.splitters.LanguageResourcesSplitter;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.SanitizerNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.ScreenDensityResourcesSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import javax.inject.Inject;

public class ModuleSplitterForShards {
    private static final ImmutableSet<Config.SplitDimension.Value> SUFFIX_STRIPPING_DIMENSIONS = ImmutableSet.of(Config.SplitDimension.Value.TEXTURE_COMPRESSION_FORMAT, Config.SplitDimension.Value.DEVICE_TIER);
    private final Version bundleVersion;
    private final Config.BundleConfig bundleConfig;
    private final Optional<Devices.DeviceSpec> deviceSpec;

    @Inject
    public ModuleSplitterForShards(Version bundleVersion, Config.BundleConfig bundleConfig, Optional<Devices.DeviceSpec> deviceSpec) {
        this.bundleVersion = bundleVersion;
        this.bundleConfig = bundleConfig;
        this.deviceSpec = deviceSpec;
    }

    public ImmutableList<ModuleSplit> generateSplits(BundleModule module, ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder rawSplits = ImmutableList.builder();
        SplittingPipeline nativePipeline = ModuleSplitterForShards.createNativeLibrariesSplittingPipeline(shardingDimensions);
        rawSplits.addAll(nativePipeline.split(ModuleSplit.forNativeLibraries(module)));
        SplittingPipeline resourcesPipeline = this.createResourcesSplittingPipeline(shardingDimensions);
        rawSplits.addAll(resourcesPipeline.split(ModuleSplit.forResources(module)));
        SplittingPipeline apexPipeline = ModuleSplitterForShards.createApexImagesSplittingPipeline();
        rawSplits.addAll(apexPipeline.split(ModuleSplit.forApex(module)));
        SplittingPipeline assetsPipeline = this.createAssetsSplittingPipeline(shardingDimensions);
        rawSplits.addAll(assetsPipeline.split(ModuleSplit.forAssets(module)));
        rawSplits.add(ModuleSplit.forDex(module));
        rawSplits.add(ModuleSplit.forRoot(module));
        ImmutableCollection unmergedSplits = rawSplits.build();
        ImmutableList<ModuleSplit> unmergedStrippedSplits = this.stripAssetsWithTargeting((ImmutableList<ModuleSplit>)unmergedSplits);
        ImmutableList<ModuleSplit> mergedSplits = new SameTargetingMerger().merge(unmergedStrippedSplits);
        mergedSplits = mergedSplits.stream().map(ModuleSplit::removeSplitName).collect(ImmutableList.toImmutableList());
        long masterSplitCount = mergedSplits.stream().filter(ModuleSplit::isMasterSplit).count();
        Preconditions.checkState(masterSplitCount == 1L, "Expected one master split, got %s.", masterSplitCount);
        return mergedSplits;
    }

    private ImmutableList<ModuleSplit> stripAssetsWithTargeting(ImmutableList<ModuleSplit> splits) {
        ImmutableList dimensionsToStrip = this.bundleConfig.getOptimizations().getSplitsConfig().getSplitDimensionList().stream().filter(dimension -> SUFFIX_STRIPPING_DIMENSIONS.contains(dimension.getValue())).collect(ImmutableList.toImmutableList());
        if (dimensionsToStrip.isEmpty()) {
            return splits;
        }
        return splits.stream().map(split -> ModuleSplitterForShards.stripAssetsWithTargeting(split, dimensionsToStrip)).collect(ImmutableList.toImmutableList());
    }

    private static ModuleSplit stripAssetsWithTargeting(ModuleSplit split, ImmutableList<Config.SplitDimension> dimensionsToStrip) {
        for (Config.SplitDimension dimension : dimensionsToStrip) {
            Preconditions.checkArgument(SUFFIX_STRIPPING_DIMENSIONS.contains(dimension.getValue()));
            split = SuffixStripper.createForDimension(dimension.getValue()).applySuffixStripping(split, dimension.getSuffixStripping());
        }
        return split;
    }

    private static SplittingPipeline createNativeLibrariesSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder nativeSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.ABI)) {
            nativeSplitters.add(new AbiNativeLibrariesSplitter());
        }
        nativeSplitters.add(new SanitizerNativeLibrariesSplitter());
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)nativeSplitters.build());
    }

    private SplittingPipeline createResourcesSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder resourceSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.SCREEN_DENSITY)) {
            resourceSplitters.add(new ScreenDensityResourcesSplitter(this.bundleVersion, Predicates.alwaysFalse(), Predicates.alwaysFalse(), false));
        }
        if (shardingDimensions.contains((Object)OptimizationDimension.LANGUAGE) && this.shouldSplitByLanguage()) {
            resourceSplitters.add(new LanguageResourcesSplitter());
        }
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)resourceSplitters.build());
    }

    private SplittingPipeline createAssetsSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder assetsSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.LANGUAGE) && this.shouldSplitByLanguage()) {
            assetsSplitters.add(LanguageAssetsSplitter.create());
        }
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)assetsSplitters.build());
    }

    private boolean shouldSplitByLanguage() {
        return this.deviceSpec.map(spec -> !spec.getSupportedLocalesList().isEmpty()).orElse(false);
    }

    private static SplittingPipeline createApexImagesSplittingPipeline() {
        return new SplittingPipeline(ImmutableList.of(new AbiApexImagesSplitter()));
    }
}

