/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils.files;

import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.OsPlatform;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileUtils {
    private static final Pattern HOME_DIRECTORY_ALIAS = Pattern.compile("^~");

    public static void createParentDirectories(Path path) {
        FileUtils.createDirectories(path.getParent());
    }

    public static void createDirectories(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e4) {
            throw new UncheckedIOException(String.format("Error creating directories '%s'.", dir), e4);
        }
    }

    public static ImmutableList<Path> getDistinctParentPaths(Collection<Path> paths) {
        return paths.stream().map(Path::getParent).distinct().collect(ImmutableList.toImmutableList());
    }

    public static String getFileExtension(ZipPath path) {
        if (path.getNameCount() == 0) {
            return "";
        }
        ZipPath name = path.getFileName();
        if (name == null) {
            return "";
        }
        String fileName = name.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static List<ZipPath> toPathWalkingOrder(Collection<ZipPath> paths) {
        ImmutableSortedSet.Builder walkOrderedSet = ImmutableSortedSet.naturalOrder();
        for (ZipPath path : paths) {
            for (int i4 = 0; i4 < path.getNameCount(); ++i4) {
                walkOrderedSet.add(path.subpath(0, i4 + 1));
            }
        }
        return walkOrderedSet.build().asList();
    }

    public static Path getPath(String path) {
        if (!OsPlatform.getCurrentPlatform().equals((Object)OsPlatform.WINDOWS)) {
            path = HOME_DIRECTORY_ALIAS.matcher(path).replaceFirst(Matcher.quoteReplacement(StandardSystemProperty.USER_HOME.value()));
        }
        return Paths.get(path, new String[0]);
    }

    private FileUtils() {
    }
}

