/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.google.common.collect.ImmutableSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class PathMatcher {
    private static final ImmutableSet<Character> REGEXP_SPECIAL_CHARS = "<([{\\^-=$!|]})?*+.>".chars().mapToObj(c4 -> Character.valueOf((char)c4)).collect(ImmutableSet.toImmutableSet());
    private final Pattern regexpPattern;

    private PathMatcher(Pattern regexpPattern) {
        this.regexpPattern = regexpPattern;
    }

    public static PathMatcher createFromGlob(String globPattern) {
        try {
            Pattern regexpPattern = Pattern.compile(PathMatcher.convertGlobToRegexp(globPattern));
            return new PathMatcher(regexpPattern);
        }
        catch (PatternSyntaxException e4) {
            throw new GlobPatternSyntaxException(globPattern, e4);
        }
    }

    public boolean matches(String input) {
        return this.regexpPattern.matcher(input).matches();
    }

    private static String convertGlobToRegexp(String globPattern) {
        StringBuilder regexpBuilder = new StringBuilder().append('^');
        boolean inGroup = false;
        int openingGroupIdx = 0;
        block10: for (int i4 = 0; i4 < globPattern.length(); ++i4) {
            switch (globPattern.charAt(i4)) {
                case '\\': {
                    if (i4 == globPattern.length() - 1) {
                        throw new GlobPatternSyntaxException("No character to escape.", globPattern, i4);
                    }
                    regexpBuilder.append('\\').append(globPattern.charAt(i4 + 1));
                    ++i4;
                    continue block10;
                }
                case '*': {
                    if (i4 + 1 < globPattern.length() && globPattern.charAt(i4 + 1) == '*') {
                        ++i4;
                        regexpBuilder.append(".*?");
                        continue block10;
                    }
                    regexpBuilder.append("[^/]*");
                    continue block10;
                }
                case '?': {
                    regexpBuilder.append(".");
                    continue block10;
                }
                case '[': {
                    char currentChar;
                    char nextChar;
                    int openBracketIdx = i4++;
                    regexpBuilder.append('[');
                    char c4 = nextChar = i4 < globPattern.length() ? globPattern.charAt(i4) : (char)'\u0000';
                    if (nextChar == '^') {
                        regexpBuilder.append('\\');
                    } else if (nextChar == '!') {
                        regexpBuilder.append('^');
                    }
                    while (i4 < globPattern.length() && globPattern.charAt(i4) != ']') {
                        currentChar = globPattern.charAt(i4);
                        if (currentChar == '/') {
                            throw new GlobPatternSyntaxException("Character '/' is not allowed within a character set", globPattern, i4);
                        }
                        regexpBuilder.append(globPattern.charAt(i4));
                        ++i4;
                    }
                    if (i4 == globPattern.length()) {
                        throw new GlobPatternSyntaxException("No matching ']' found.", globPattern, openBracketIdx);
                    }
                    if (i4 == openBracketIdx + 1) {
                        throw new GlobPatternSyntaxException("Empty characters set.", globPattern, openBracketIdx);
                    }
                    regexpBuilder.append(globPattern.charAt(i4));
                    continue block10;
                }
                case '{': {
                    if (inGroup) {
                        throw new GlobPatternSyntaxException("Cannot nest groups.", globPattern, i4);
                    }
                    openingGroupIdx = i4;
                    inGroup = true;
                    regexpBuilder.append("(?:");
                    continue block10;
                }
                case '}': {
                    if (!inGroup) {
                        throw new GlobPatternSyntaxException("No matching '{' found.", globPattern, i4);
                    }
                    regexpBuilder.append(')');
                    inGroup = false;
                    continue block10;
                }
                case ']': {
                    throw new GlobPatternSyntaxException("No matching '[' found.", globPattern, i4);
                }
                case ',': {
                    if (inGroup) {
                        regexpBuilder.append('|');
                        continue block10;
                    }
                    regexpBuilder.append(',');
                    continue block10;
                }
                default: {
                    char currentChar = globPattern.charAt(i4);
                    if (REGEXP_SPECIAL_CHARS.contains(Character.valueOf(currentChar))) {
                        regexpBuilder.append('\\');
                    }
                    regexpBuilder.append(currentChar);
                }
            }
        }
        if (inGroup) {
            throw new GlobPatternSyntaxException("No matching '}' found.", globPattern, openingGroupIdx);
        }
        return regexpBuilder.append('$').toString();
    }

    public static class GlobPatternSyntaxException
    extends RuntimeException {
        private GlobPatternSyntaxException(String message2, String globPattern, int index) {
            super(String.format("Unable to parse glob pattern '%s' at character %d. Error: %s", globPattern, index + 1, message2));
        }

        private GlobPatternSyntaxException(String globPattern, Throwable cause) {
            super(String.format("Unable to parse glob pattern '%s'.", globPattern), cause);
        }
    }
}

