/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_ModuleEntry;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.auto.value.AutoValue;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.errorprone.annotations.Immutable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class ModuleEntry {
    public abstract ZipPath getPath();

    public abstract Optional<ZipPath> getBundlePath();

    public abstract boolean getForceUncompressed();

    public abstract boolean getShouldSign();

    public abstract ByteSource getContent();

    public final boolean equals(Object obj2) {
        if (!(obj2 instanceof ModuleEntry)) {
            return false;
        }
        ModuleEntry entry1 = this;
        ModuleEntry entry2 = (ModuleEntry)obj2;
        if (entry1 == entry2) {
            return true;
        }
        if (!entry1.getPath().equals(entry2.getPath())) {
            return false;
        }
        if (entry1.getForceUncompressed() != entry2.getForceUncompressed()) {
            return false;
        }
        if (entry1.getShouldSign() != entry2.getShouldSign()) {
            return false;
        }
        try {
            return entry1.getContent().contentEquals(entry2.getContent());
        }
        catch (IOException e4) {
            throw new UncheckedIOException(String.format("Failed to compare contents of module entries '%s' and '%s'.", entry1, entry2), e4);
        }
    }

    public final int hashCode() {
        return Objects.hash(this.getPath(), this.getForceUncompressed());
    }

    public boolean isSpecialEntry() {
        return BundleModule.SpecialModuleEntry.getSpecialEntry(this.getPath()).isPresent();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ModuleEntry.Builder().setForceUncompressed(false).setShouldSign(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setPath(ZipPath var1);

        public abstract Builder setBundlePath(ZipPath var1);

        public abstract Builder setBundlePath(Optional<ZipPath> var1);

        public abstract Builder setForceUncompressed(boolean var1);

        public abstract Builder setShouldSign(boolean var1);

        public abstract Builder setContent(ByteSource var1);

        public Builder setContent(Path path) {
            this.setBundlePath(Optional.empty());
            return this.setContent(MoreFiles.asByteSource(path, new OpenOption[0]));
        }

        public Builder setContent(File file) {
            this.setBundlePath(Optional.empty());
            return this.setContent(Files.asByteSource(file));
        }

        public abstract ModuleEntry build();
    }
}

