/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Commands;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.AbstractSizeAggregator;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.model.ConfigurationSizes;
import com.android.tools.build.bundletool.model.GetSizeRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;

public class AssetModuleSizeAggregator
extends AbstractSizeAggregator {
    private final Collection<Commands.AssetSliceSet> assetModules;
    private final Targeting.VariantTargeting variantTargeting;

    public AssetModuleSizeAggregator(Collection<Commands.AssetSliceSet> assetModules, Targeting.VariantTargeting variantTargeting, ImmutableMap<String, Long> sizeByApkPaths, GetSizeRequest getSizeRequest) {
        super(sizeByApkPaths, getSizeRequest);
        this.assetModules = assetModules;
        this.variantTargeting = variantTargeting;
    }

    @Override
    public ConfigurationSizes getSize() {
        ImmutableList<Commands.ApkDescription> apkDescriptions = this.assetModules.stream().flatMap(assetModule -> assetModule.getApkDescriptionList().stream()).collect(ImmutableList.toImmutableList());
        ImmutableSet<Targeting.SdkVersionTargeting> sdkVersionTargetingOptions = this.variantTargeting.hasSdkVersionTargeting() ? ImmutableSet.of(this.variantTargeting.getSdkVersionTargeting()) : this.getAllSdkVersionTargetings(apkDescriptions);
        ImmutableSet<Targeting.AbiTargeting> abiTargetingOptions = this.variantTargeting.hasAbiTargeting() ? ImmutableSet.of(this.variantTargeting.getAbiTargeting()) : this.getAllAbiTargetings(apkDescriptions);
        ImmutableSet<Targeting.LanguageTargeting> languageTargetingOptions = this.getAllLanguageTargetings(apkDescriptions);
        ImmutableSet<Targeting.ScreenDensityTargeting> screenDensityTargetingOptions = this.variantTargeting.hasScreenDensityTargeting() ? ImmutableSet.of(this.variantTargeting.getScreenDensityTargeting()) : this.getAllScreenDensityTargetings(apkDescriptions);
        ImmutableSet<Targeting.TextureCompressionFormatTargeting> textureCompressionFormatTargetingOptions = this.variantTargeting.hasTextureCompressionFormatTargeting() ? ImmutableSet.of(this.variantTargeting.getTextureCompressionFormatTargeting()) : this.getAllTextureCompressionFormatTargetings(apkDescriptions);
        ImmutableSet<Targeting.DeviceTierTargeting> devicetierTargetingOptions = this.getAllDeviceTierTargetings(apkDescriptions);
        return this.getSizesPerConfiguration(sdkVersionTargetingOptions, abiTargetingOptions, languageTargetingOptions, screenDensityTargetingOptions, textureCompressionFormatTargetingOptions, devicetierTargetingOptions);
    }

    @Override
    protected ImmutableList<ApkMatcher.GeneratedApk> getMatchingApks(Targeting.SdkVersionTargeting sdkVersionTargeting, Targeting.AbiTargeting abiTargeting, Targeting.ScreenDensityTargeting screenDensityTargeting, Targeting.LanguageTargeting languageTargeting, Targeting.TextureCompressionFormatTargeting textureTargeting, Targeting.DeviceTierTargeting deviceTierTargeting) {
        return new ApkMatcher(this.getDeviceSpec(this.getSizeRequest.getDeviceSpec(), sdkVersionTargeting, abiTargeting, screenDensityTargeting, languageTargeting, textureTargeting, deviceTierTargeting), this.getSizeRequest.getModules(), this.getSizeRequest.getInstant(), false).getMatchingApksFromAssetModules(this.assetModules);
    }
}

