/*
 * Decompiled with CFR 0.152.
 */
package com.android.multidex;

import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.multidex.ArchivePathElement;
import com.android.multidex.ClassPathElement;
import com.android.multidex.FolderPathElement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReferenceListBuilder {
    private static final String CLASS_EXTENSION = ".class";
    private static final int STATUS_ERROR = 1;
    private static final String EOL = System.getProperty("line.separator");
    private static String USAGE_MESSAGE = "Usage:" + EOL + EOL + "Short version: Don't use this." + EOL + EOL + "Slightly longer version: This tool is used by mainDexClasses script to find direct" + EOL + "references of some classes." + EOL;
    private Path path;
    private Set<String> toKeep = new HashSet<String>();

    private ClassReferenceListBuilder(Path path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        ZipFile zipFile;
        if (stringArray.length != 2) {
            ClassReferenceListBuilder.printUsage();
            System.exit(1);
        }
        try {
            zipFile = new ZipFile(stringArray[0]);
        }
        catch (IOException iOException) {
            System.err.println("\"" + stringArray[0] + "\" can not be read as a zip archive. (" + iOException.getMessage() + ")");
            System.exit(1);
            return;
        }
        Path path = null;
        try {
            path = new Path(stringArray[1]);
            ClassReferenceListBuilder classReferenceListBuilder = new ClassReferenceListBuilder(path);
            classReferenceListBuilder.addRoots(zipFile);
            ClassReferenceListBuilder.printList(classReferenceListBuilder.toKeep);
        }
        catch (IOException iOException) {
            System.err.println("A fatal error occured: " + iOException.getMessage());
            System.exit(1);
            return;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
            if (path != null) {
                for (ClassPathElement classPathElement : path.elements) {
                    try {
                        classPathElement.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void printUsage() {
        System.err.print(USAGE_MESSAGE);
    }

    private static ClassPathElement getClassPathElement(File file) throws ZipException, IOException {
        if (file.isDirectory()) {
            return new FolderPathElement(file);
        }
        if (file.isFile()) {
            return new ArchivePathElement(new ZipFile(file));
        }
        if (file.exists()) {
            throw new IOException(file.getAbsolutePath() + " is not a directory neither a zip file");
        }
        throw new FileNotFoundException(file.getAbsolutePath());
    }

    private static void printList(Set<String> set) {
        for (String string : set) {
            System.out.print(string);
            System.out.println(CLASS_EXTENSION);
        }
    }

    private void addRoots(ZipFile zipFile) throws IOException {
        String string;
        ZipEntry zipEntry;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            string = zipEntry.getName();
            if (!string.endsWith(CLASS_EXTENSION)) continue;
            this.toKeep.add(string.substring(0, string.length() - CLASS_EXTENSION.length()));
        }
        enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            DirectClassFile directClassFile;
            zipEntry = enumeration.nextElement();
            string = zipEntry.getName();
            if (!string.endsWith(CLASS_EXTENSION)) continue;
            try {
                directClassFile = this.path.getClass(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException("Class " + string + " is missing form original class path " + this.path, fileNotFoundException);
            }
            this.addDependencies(directClassFile.getConstantPool());
        }
    }

    private void addDependencies(ConstantPool constantPool) {
        int n = constantPool.size();
        for (Constant constant : constantPool.getEntries()) {
            Type type;
            String string;
            if (!(constant instanceof CstType) || !(string = (type = ((CstType)constant).getClassType()).getDescriptor()).endsWith(";")) continue;
            int n2 = string.lastIndexOf(91);
            if (n2 < 0) {
                this.addClassWithHierachy(string.substring(1, string.length() - 1));
                continue;
            }
            assert (string.length() > n2 + 3 && string.charAt(n2 + 1) == 'L');
            this.addClassWithHierachy(string.substring(n2 + 2, string.length() - 1));
        }
    }

    private void addClassWithHierachy(String string) {
        if (this.toKeep.contains(string)) {
            return;
        }
        String string2 = string + CLASS_EXTENSION;
        try {
            DirectClassFile directClassFile = this.path.getClass(string2);
            this.toKeep.add(string);
            CstType cstType = directClassFile.getSuperclass();
            if (cstType != null) {
                this.addClassWithHierachy(cstType.getClassType().getClassName());
            }
            TypeList typeList = directClassFile.getInterfaces();
            int n = typeList.size();
            for (int i = 0; i < n; ++i) {
                this.addClassWithHierachy(typeList.getType(i).getClassName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static class Path {
        private List<ClassPathElement> elements = new ArrayList<ClassPathElement>();
        private String definition;
        private ByteArrayOutputStream baos = new ByteArrayOutputStream(40960);
        private byte[] readBuffer = new byte[20480];

        public Path(String string) throws IOException {
            this.definition = string;
            for (String string2 : string.split(Pattern.quote(File.pathSeparator))) {
                try {
                    this.addElement(ClassReferenceListBuilder.getClassPathElement(new File(string2)));
                }
                catch (IOException iOException) {
                    throw new IOException("\"" + string2 + "\" can not be used as a classpath" + " element. (" + iOException.getMessage() + ")", iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] readStream(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) throws IOException {
            try {
                int n;
                while ((n = inputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            return byteArrayOutputStream.toByteArray();
        }

        public String toString() {
            return this.definition;
        }

        private void addElement(ClassPathElement classPathElement) {
            assert (classPathElement != null);
            this.elements.add(classPathElement);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DirectClassFile getClass(String string) throws FileNotFoundException {
            DirectClassFile directClassFile = null;
            for (ClassPathElement classPathElement : this.elements) {
                try {
                    InputStream inputStream = classPathElement.open(string);
                    try {
                        byte[] byArray = Path.readStream(inputStream, this.baos, this.readBuffer);
                        this.baos.reset();
                        directClassFile = new DirectClassFile(byArray, string, false);
                        directClassFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
                        break;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                }
            }
            if (directClassFile == null) {
                throw new FileNotFoundException(string);
            }
            return directClassFile;
        }
    }
}

