/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;

public class DeadCodeRemover {
    private final SsaMethod ssaMeth;
    private final int regCount;
    private final BitSet worklist;
    private final ArrayList<SsaInsn>[] useList;

    public static void process(SsaMethod ssaMethod) {
        DeadCodeRemover deadCodeRemover = new DeadCodeRemover(ssaMethod);
        deadCodeRemover.run();
    }

    private DeadCodeRemover(SsaMethod ssaMethod) {
        this.ssaMeth = ssaMethod;
        this.regCount = ssaMethod.getRegCount();
        this.worklist = new BitSet(this.regCount);
        this.useList = this.ssaMeth.getUseListCopy();
    }

    private void run() {
        int n;
        this.pruneDeadInstructions();
        HashSet<SsaInsn> hashSet = new HashSet<SsaInsn>();
        this.ssaMeth.forEachInsn(new NoSideEffectVisitor(this.worklist));
        while (0 <= (n = this.worklist.nextSetBit(0))) {
            SsaInsn ssaInsn;
            this.worklist.clear(n);
            if (this.useList[n].size() != 0 && !this.isCircularNoSideEffect(n, null) || hashSet.contains(ssaInsn = this.ssaMeth.getDefinitionForRegister(n))) continue;
            RegisterSpecList registerSpecList = ssaInsn.getSources();
            int n2 = registerSpecList.size();
            for (int i = 0; i < n2; ++i) {
                RegisterSpec registerSpec = registerSpecList.get(i);
                this.useList[registerSpec.getReg()].remove(ssaInsn);
                if (DeadCodeRemover.hasSideEffect(this.ssaMeth.getDefinitionForRegister(registerSpec.getReg()))) continue;
                this.worklist.set(registerSpec.getReg());
            }
            hashSet.add(ssaInsn);
        }
        this.ssaMeth.deleteInsns(hashSet);
    }

    private void pruneDeadInstructions() {
        HashSet<SsaInsn> hashSet = new HashSet<SsaInsn>();
        this.ssaMeth.computeReachability();
        for (SsaBasicBlock ssaBasicBlock : this.ssaMeth.getBlocks()) {
            if (ssaBasicBlock.isReachable()) continue;
            for (int i = 0; i < ssaBasicBlock.getInsns().size(); ++i) {
                SsaInsn ssaInsn = ssaBasicBlock.getInsns().get(i);
                RegisterSpecList registerSpecList = ssaInsn.getSources();
                int n = registerSpecList.size();
                if (n != 0) {
                    hashSet.add(ssaInsn);
                }
                for (int j = 0; j < n; ++j) {
                    RegisterSpec registerSpec = registerSpecList.get(j);
                    this.useList[registerSpec.getReg()].remove(ssaInsn);
                }
                RegisterSpec registerSpec = ssaInsn.getResult();
                if (registerSpec == null) continue;
                for (SsaInsn ssaInsn2 : this.useList[registerSpec.getReg()]) {
                    if (!(ssaInsn2 instanceof PhiInsn)) continue;
                    PhiInsn phiInsn = (PhiInsn)ssaInsn2;
                    phiInsn.removePhiRegister(registerSpec);
                }
            }
        }
        this.ssaMeth.deleteInsns(hashSet);
    }

    private boolean isCircularNoSideEffect(int n, BitSet bitSet) {
        if (bitSet != null && bitSet.get(n)) {
            return true;
        }
        for (SsaInsn ssaInsn : this.useList[n]) {
            if (!DeadCodeRemover.hasSideEffect(ssaInsn)) continue;
            return false;
        }
        if (bitSet == null) {
            bitSet = new BitSet(this.regCount);
        }
        bitSet.set(n);
        for (SsaInsn ssaInsn : this.useList[n]) {
            RegisterSpec registerSpec = ssaInsn.getResult();
            if (registerSpec != null && this.isCircularNoSideEffect(registerSpec.getReg(), bitSet)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSideEffect(SsaInsn ssaInsn) {
        if (ssaInsn == null) {
            return true;
        }
        return ssaInsn.hasSideEffect();
    }

    private static class NoSideEffectVisitor
    implements SsaInsn.Visitor {
        BitSet noSideEffectRegs;

        public NoSideEffectVisitor(BitSet bitSet) {
            this.noSideEffectRegs = bitSet;
        }

        public void visitMoveInsn(NormalSsaInsn normalSsaInsn) {
            if (!DeadCodeRemover.hasSideEffect(normalSsaInsn)) {
                this.noSideEffectRegs.set(normalSsaInsn.getResult().getReg());
            }
        }

        public void visitPhiInsn(PhiInsn phiInsn) {
            if (!DeadCodeRemover.hasSideEffect(phiInsn)) {
                this.noSideEffectRegs.set(phiInsn.getResult().getReg());
            }
        }

        public void visitNonMoveInsn(NormalSsaInsn normalSsaInsn) {
            RegisterSpec registerSpec = normalSsaInsn.getResult();
            if (!DeadCodeRemover.hasSideEffect(normalSsaInsn) && registerSpec != null) {
                this.noSideEffectRegs.set(registerSpec.getReg());
            }
        }
    }
}

