/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.util.MutabilityControl;

public final class RegisterSpecSet
extends MutabilityControl {
    public static final RegisterSpecSet EMPTY = new RegisterSpecSet(0);
    private final RegisterSpec[] specs;
    private int size;

    public RegisterSpecSet(int n) {
        super(n != 0);
        this.specs = new RegisterSpec[n];
        this.size = 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RegisterSpecSet)) {
            return false;
        }
        RegisterSpecSet registerSpecSet = (RegisterSpecSet)object;
        int n = this.specs.length;
        RegisterSpec[] registerSpecArray = registerSpecSet.specs;
        if (n != registerSpecArray.length || this.size() != registerSpecSet.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            RegisterSpec registerSpec = this.specs[i];
            RegisterSpec registerSpec2 = registerSpecArray[i];
            if (registerSpec == registerSpec2 || registerSpec != null && registerSpec.equals(registerSpec2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.specs.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            RegisterSpec registerSpec = this.specs[i];
            int n3 = registerSpec == null ? 0 : registerSpec.hashCode();
            n2 = n2 * 31 + n3;
        }
        return n2;
    }

    public String toString() {
        int n = this.specs.length;
        StringBuffer stringBuffer = new StringBuffer(n * 25);
        stringBuffer.append('{');
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            RegisterSpec registerSpec = this.specs[i];
            if (registerSpec == null) continue;
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(registerSpec);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public int getMaxSize() {
        return this.specs.length;
    }

    public int size() {
        int n = this.size;
        if (n < 0) {
            int n2 = this.specs.length;
            n = 0;
            for (int i = 0; i < n2; ++i) {
                if (this.specs[i] == null) continue;
                ++n;
            }
            this.size = n;
        }
        return n;
    }

    public RegisterSpec get(int n) {
        try {
            return this.specs[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("bogus reg");
        }
    }

    public RegisterSpec get(RegisterSpec registerSpec) {
        return this.get(registerSpec.getReg());
    }

    public RegisterSpec findMatchingLocal(RegisterSpec registerSpec) {
        for (RegisterSpec registerSpec2 : this.specs) {
            if (registerSpec2 == null || !registerSpec.matchesVariable(registerSpec2)) continue;
            return registerSpec2;
        }
        return null;
    }

    public RegisterSpec localItemToSpec(LocalItem localItem) {
        for (RegisterSpec registerSpec : this.specs) {
            if (registerSpec == null || !localItem.equals(registerSpec.getLocalItem())) continue;
            return registerSpec;
        }
        return null;
    }

    public void remove(RegisterSpec registerSpec) {
        try {
            this.specs[registerSpec.getReg()] = null;
            this.size = -1;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("bogus reg");
        }
    }

    public void put(RegisterSpec registerSpec) {
        this.throwIfImmutable();
        if (registerSpec == null) {
            throw new NullPointerException("spec == null");
        }
        this.size = -1;
        try {
            int n;
            RegisterSpec registerSpec2;
            int n2 = registerSpec.getReg();
            this.specs[n2] = registerSpec;
            if (n2 > 0 && (registerSpec2 = this.specs[n = n2 - 1]) != null && registerSpec2.getCategory() == 2) {
                this.specs[n] = null;
            }
            if (registerSpec.getCategory() == 2) {
                this.specs[n2 + 1] = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("spec.getReg() out of range");
        }
    }

    public void putAll(RegisterSpecSet registerSpecSet) {
        int n = registerSpecSet.getMaxSize();
        for (int i = 0; i < n; ++i) {
            RegisterSpec registerSpec = registerSpecSet.get(i);
            if (registerSpec == null) continue;
            this.put(registerSpec);
        }
    }

    public void intersect(RegisterSpecSet registerSpecSet, boolean bl) {
        int n;
        this.throwIfImmutable();
        RegisterSpec[] registerSpecArray = registerSpecSet.specs;
        int n2 = this.specs.length;
        int n3 = Math.min(n2, registerSpecArray.length);
        this.size = -1;
        for (n = 0; n < n3; ++n) {
            RegisterSpec registerSpec;
            RegisterSpec registerSpec2 = this.specs[n];
            if (registerSpec2 == null || (registerSpec = registerSpec2.intersect(registerSpecArray[n], bl)) == registerSpec2) continue;
            this.specs[n] = registerSpec;
        }
        for (n = n3; n < n2; ++n) {
            this.specs[n] = null;
        }
    }

    public RegisterSpecSet withOffset(int n) {
        int n2 = this.specs.length;
        RegisterSpecSet registerSpecSet = new RegisterSpecSet(n2 + n);
        for (int i = 0; i < n2; ++i) {
            RegisterSpec registerSpec = this.specs[i];
            if (registerSpec == null) continue;
            registerSpecSet.put(registerSpec.withOffset(n));
        }
        registerSpecSet.size = this.size;
        if (this.isImmutable()) {
            registerSpecSet.setImmutable();
        }
        return registerSpecSet;
    }

    public RegisterSpecSet mutableCopy() {
        int n = this.specs.length;
        RegisterSpecSet registerSpecSet = new RegisterSpecSet(n);
        for (int i = 0; i < n; ++i) {
            RegisterSpec registerSpec = this.specs[i];
            if (registerSpec == null) continue;
            registerSpecSet.put(registerSpec);
        }
        registerSpecSet.size = this.size;
        return registerSpecSet;
    }
}

