/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.merge;

import com.android.dex.ClassDef;
import com.android.dex.Dex;
import java.util.Comparator;

final class SortableType {
    public static final Comparator<SortableType> NULLS_LAST_ORDER = new Comparator<SortableType>(){

        @Override
        public int compare(SortableType sortableType, SortableType sortableType2) {
            if (sortableType == sortableType2) {
                return 0;
            }
            if (sortableType2 == null) {
                return -1;
            }
            if (sortableType == null) {
                return 1;
            }
            if (sortableType.depth != sortableType2.depth) {
                return sortableType.depth - sortableType2.depth;
            }
            return sortableType.getTypeIndex() - sortableType2.getTypeIndex();
        }
    };
    private final Dex dex;
    private ClassDef classDef;
    private int depth = -1;

    public SortableType(Dex dex, ClassDef classDef) {
        this.dex = dex;
        this.classDef = classDef;
    }

    public Dex getDex() {
        return this.dex;
    }

    public ClassDef getClassDef() {
        return this.classDef;
    }

    public int getTypeIndex() {
        return this.classDef.getTypeIndex();
    }

    public boolean tryAssignDepth(SortableType[] sortableTypeArray) {
        int n;
        if (this.classDef.getSupertypeIndex() == -1) {
            n = 0;
        } else {
            SortableType sortableType = sortableTypeArray[this.classDef.getSupertypeIndex()];
            if (sortableType == null) {
                n = 1;
            } else {
                if (sortableType.depth == -1) {
                    return false;
                }
                n = sortableType.depth;
            }
        }
        for (Object object : (SortableType)this.classDef.getInterfaces()) {
            SortableType sortableType = sortableTypeArray[object];
            if (sortableType == null) {
                n = Math.max(n, 1);
                continue;
            }
            if (sortableType.depth == -1) {
                return false;
            }
            n = Math.max(n, sortableType.depth);
        }
        this.depth = n + 1;
        return true;
    }

    public boolean isDepthAssigned() {
        return this.depth != -1;
    }
}

