/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.merge;

import com.android.dex.DexException;
import com.android.dx.io.CodeReader;
import com.android.dx.io.instructions.DecodedInstruction;
import com.android.dx.io.instructions.ShortArrayCodeOutput;
import com.android.dx.merge.IndexMap;

final class InstructionTransformer {
    private final IndexMap indexMap;
    private final CodeReader reader;
    private DecodedInstruction[] mappedInstructions;
    private int mappedAt;

    public InstructionTransformer(IndexMap indexMap) {
        this.indexMap = indexMap;
        this.reader = new CodeReader();
        this.reader.setAllVisitors(new GenericVisitor());
        this.reader.setStringVisitor(new StringVisitor());
        this.reader.setTypeVisitor(new TypeVisitor());
        this.reader.setFieldVisitor(new FieldVisitor());
        this.reader.setMethodVisitor(new MethodVisitor());
    }

    public short[] transform(short[] sArray) throws DexException {
        DecodedInstruction[] decodedInstructionArray = DecodedInstruction.decodeAll(sArray);
        int n = decodedInstructionArray.length;
        this.mappedInstructions = new DecodedInstruction[n];
        this.mappedAt = 0;
        this.reader.visitAll(decodedInstructionArray);
        ShortArrayCodeOutput shortArrayCodeOutput = new ShortArrayCodeOutput(n);
        for (DecodedInstruction decodedInstruction : this.mappedInstructions) {
            if (decodedInstruction == null) continue;
            decodedInstruction.encode(shortArrayCodeOutput);
        }
        return shortArrayCodeOutput.getArray();
    }

    private static void jumboCheck(boolean bl, int n) {
        if (!bl && n > 65535) {
            throw new DexException("Cannot merge new index " + n + " into a non-jumbo instruction!");
        }
    }

    private class MethodVisitor
    implements CodeReader.Visitor {
        private MethodVisitor() {
        }

        public void visit(DecodedInstruction[] decodedInstructionArray, DecodedInstruction decodedInstruction) {
            int n = decodedInstruction.getIndex();
            int n2 = InstructionTransformer.this.indexMap.adjustMethod(n);
            boolean bl = decodedInstruction.getOpcode() == 27;
            InstructionTransformer.jumboCheck(bl, n2);
            ((InstructionTransformer)InstructionTransformer.this).mappedInstructions[((InstructionTransformer)InstructionTransformer.this).mappedAt++] = decodedInstruction.withIndex(n2);
        }
    }

    private class TypeVisitor
    implements CodeReader.Visitor {
        private TypeVisitor() {
        }

        public void visit(DecodedInstruction[] decodedInstructionArray, DecodedInstruction decodedInstruction) {
            int n = decodedInstruction.getIndex();
            int n2 = InstructionTransformer.this.indexMap.adjustType(n);
            boolean bl = decodedInstruction.getOpcode() == 27;
            InstructionTransformer.jumboCheck(bl, n2);
            ((InstructionTransformer)InstructionTransformer.this).mappedInstructions[((InstructionTransformer)InstructionTransformer.this).mappedAt++] = decodedInstruction.withIndex(n2);
        }
    }

    private class FieldVisitor
    implements CodeReader.Visitor {
        private FieldVisitor() {
        }

        public void visit(DecodedInstruction[] decodedInstructionArray, DecodedInstruction decodedInstruction) {
            int n = decodedInstruction.getIndex();
            int n2 = InstructionTransformer.this.indexMap.adjustField(n);
            boolean bl = decodedInstruction.getOpcode() == 27;
            InstructionTransformer.jumboCheck(bl, n2);
            ((InstructionTransformer)InstructionTransformer.this).mappedInstructions[((InstructionTransformer)InstructionTransformer.this).mappedAt++] = decodedInstruction.withIndex(n2);
        }
    }

    private class StringVisitor
    implements CodeReader.Visitor {
        private StringVisitor() {
        }

        public void visit(DecodedInstruction[] decodedInstructionArray, DecodedInstruction decodedInstruction) {
            int n = decodedInstruction.getIndex();
            int n2 = InstructionTransformer.this.indexMap.adjustString(n);
            boolean bl = decodedInstruction.getOpcode() == 27;
            InstructionTransformer.jumboCheck(bl, n2);
            ((InstructionTransformer)InstructionTransformer.this).mappedInstructions[((InstructionTransformer)InstructionTransformer.this).mappedAt++] = decodedInstruction.withIndex(n2);
        }
    }

    private class GenericVisitor
    implements CodeReader.Visitor {
        private GenericVisitor() {
        }

        public void visit(DecodedInstruction[] decodedInstructionArray, DecodedInstruction decodedInstruction) {
            ((InstructionTransformer)InstructionTransformer.this).mappedInstructions[((InstructionTransformer)InstructionTransformer.this).mappedAt++] = decodedInstruction;
        }
    }
}

