/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.merge;

import com.android.dex.Annotation;
import com.android.dex.ClassData;
import com.android.dex.ClassDef;
import com.android.dex.Code;
import com.android.dex.Dex;
import com.android.dex.DexException;
import com.android.dex.FieldId;
import com.android.dex.MethodId;
import com.android.dex.ProtoId;
import com.android.dex.TableOfContents;
import com.android.dex.TypeList;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.IndexMap;
import com.android.dx.merge.InstructionTransformer;
import com.android.dx.merge.SortableType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DexMerger {
    private final Dex dexA;
    private final Dex dexB;
    private final CollisionPolicy collisionPolicy;
    private final WriterSizes writerSizes;
    private final Dex dexOut;
    private final Dex.Section headerOut;
    private final Dex.Section idsDefsOut;
    private final Dex.Section mapListOut;
    private final Dex.Section typeListOut;
    private final Dex.Section classDataOut;
    private final Dex.Section codeOut;
    private final Dex.Section stringDataOut;
    private final Dex.Section debugInfoOut;
    private final Dex.Section encodedArrayOut;
    private final Dex.Section annotationsDirectoryOut;
    private final Dex.Section annotationSetOut;
    private final Dex.Section annotationSetRefListOut;
    private final Dex.Section annotationOut;
    private final TableOfContents contentsOut;
    private final IndexMap aIndexMap;
    private final IndexMap bIndexMap;
    private final InstructionTransformer aInstructionTransformer;
    private final InstructionTransformer bInstructionTransformer;
    private int compactWasteThreshold = 0x100000;
    private static final byte DBG_END_SEQUENCE = 0;
    private static final byte DBG_ADVANCE_PC = 1;
    private static final byte DBG_ADVANCE_LINE = 2;
    private static final byte DBG_START_LOCAL = 3;
    private static final byte DBG_START_LOCAL_EXTENDED = 4;
    private static final byte DBG_END_LOCAL = 5;
    private static final byte DBG_RESTART_LOCAL = 6;
    private static final byte DBG_SET_PROLOGUE_END = 7;
    private static final byte DBG_SET_EPILOGUE_BEGIN = 8;
    private static final byte DBG_SET_FILE = 9;

    public DexMerger(Dex dex, Dex dex2, CollisionPolicy collisionPolicy) throws IOException {
        this(dex, dex2, collisionPolicy, new WriterSizes(dex, dex2));
    }

    private DexMerger(Dex dex, Dex dex2, CollisionPolicy collisionPolicy, WriterSizes writerSizes) throws IOException {
        this.dexA = dex;
        this.dexB = dex2;
        this.collisionPolicy = collisionPolicy;
        this.writerSizes = writerSizes;
        this.dexOut = new Dex(writerSizes.size());
        TableOfContents tableOfContents = dex.getTableOfContents();
        TableOfContents tableOfContents2 = dex2.getTableOfContents();
        this.aIndexMap = new IndexMap(this.dexOut, tableOfContents);
        this.bIndexMap = new IndexMap(this.dexOut, tableOfContents2);
        this.aInstructionTransformer = new InstructionTransformer(this.aIndexMap);
        this.bInstructionTransformer = new InstructionTransformer(this.bIndexMap);
        this.headerOut = this.dexOut.appendSection(writerSizes.header, "header");
        this.idsDefsOut = this.dexOut.appendSection(writerSizes.idsDefs, "ids defs");
        this.contentsOut = this.dexOut.getTableOfContents();
        this.contentsOut.dataOff = this.dexOut.getNextSectionStart();
        this.contentsOut.mapList.off = this.dexOut.getNextSectionStart();
        this.contentsOut.mapList.size = 1;
        this.mapListOut = this.dexOut.appendSection(writerSizes.mapList, "map list");
        this.contentsOut.typeLists.off = this.dexOut.getNextSectionStart();
        this.typeListOut = this.dexOut.appendSection(writerSizes.typeList, "type list");
        this.contentsOut.annotationSetRefLists.off = this.dexOut.getNextSectionStart();
        this.annotationSetRefListOut = this.dexOut.appendSection(writerSizes.annotationsSetRefList, "annotation set ref list");
        this.contentsOut.annotationSets.off = this.dexOut.getNextSectionStart();
        this.annotationSetOut = this.dexOut.appendSection(writerSizes.annotationsSet, "annotation sets");
        this.contentsOut.classDatas.off = this.dexOut.getNextSectionStart();
        this.classDataOut = this.dexOut.appendSection(writerSizes.classData, "class data");
        this.contentsOut.codes.off = this.dexOut.getNextSectionStart();
        this.codeOut = this.dexOut.appendSection(writerSizes.code, "code");
        this.contentsOut.stringDatas.off = this.dexOut.getNextSectionStart();
        this.stringDataOut = this.dexOut.appendSection(writerSizes.stringData, "string data");
        this.contentsOut.debugInfos.off = this.dexOut.getNextSectionStart();
        this.debugInfoOut = this.dexOut.appendSection(writerSizes.debugInfo, "debug info");
        this.contentsOut.annotations.off = this.dexOut.getNextSectionStart();
        this.annotationOut = this.dexOut.appendSection(writerSizes.annotation, "annotation");
        this.contentsOut.encodedArrays.off = this.dexOut.getNextSectionStart();
        this.encodedArrayOut = this.dexOut.appendSection(writerSizes.encodedArray, "encoded array");
        this.contentsOut.annotationsDirectories.off = this.dexOut.getNextSectionStart();
        this.annotationsDirectoryOut = this.dexOut.appendSection(writerSizes.annotationsDirectory, "annotations directory");
        this.contentsOut.dataSize = this.dexOut.getNextSectionStart() - this.contentsOut.dataOff;
    }

    public void setCompactWasteThreshold(int n) {
        this.compactWasteThreshold = n;
    }

    private Dex mergeDexes() throws IOException {
        this.mergeStringIds();
        this.mergeTypeIds();
        this.mergeTypeLists();
        this.mergeProtoIds();
        this.mergeFieldIds();
        this.mergeMethodIds();
        this.mergeAnnotations();
        this.unionAnnotationSetsAndDirectories();
        this.mergeClassDefs();
        this.contentsOut.header.off = 0;
        this.contentsOut.header.size = 1;
        this.contentsOut.fileSize = this.dexOut.getLength();
        this.contentsOut.computeSizesFromOffsets();
        this.contentsOut.writeHeader(this.headerOut);
        this.contentsOut.writeMap(this.mapListOut);
        this.dexOut.writeHashes();
        return this.dexOut;
    }

    public Dex merge() throws IOException {
        long l = System.nanoTime();
        Dex dex = this.mergeDexes();
        WriterSizes writerSizes = new WriterSizes(this);
        int n = this.writerSizes.size() - writerSizes.size();
        if (n > this.compactWasteThreshold) {
            DexMerger dexMerger = new DexMerger(this.dexOut, new Dex(0), CollisionPolicy.FAIL, writerSizes);
            dex = dexMerger.mergeDexes();
            System.out.printf("Result compacted from %.1fKiB to %.1fKiB to save %.1fKiB%n", Float.valueOf((float)this.dexOut.getLength() / 1024.0f), Float.valueOf((float)dex.getLength() / 1024.0f), Float.valueOf((float)n / 1024.0f));
        }
        long l2 = System.nanoTime() - l;
        System.out.printf("Merged dex A (%d defs/%.1fKiB) with dex B (%d defs/%.1fKiB). Result is %d defs/%.1fKiB. Took %.1fs%n", this.dexA.getTableOfContents().classDefs.size, Float.valueOf((float)this.dexA.getLength() / 1024.0f), this.dexB.getTableOfContents().classDefs.size, Float.valueOf((float)this.dexB.getLength() / 1024.0f), dex.getTableOfContents().classDefs.size, Float.valueOf((float)dex.getLength() / 1024.0f), Float.valueOf((float)l2 / 1.0E9f));
        return dex;
    }

    private IndexMap getIndexMap(Dex dex) {
        if (dex == this.dexA) {
            return this.aIndexMap;
        }
        if (dex == this.dexB) {
            return this.bIndexMap;
        }
        throw new IllegalArgumentException();
    }

    private void mergeStringIds() {
        new IdMerger<String>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.stringIds;
            }

            @Override
            String read(Dex.Section section, IndexMap indexMap, int n) {
                return section.readString();
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                indexMap.stringIds[n2] = n3;
            }

            @Override
            void write(String string) {
                ++((DexMerger)DexMerger.this).contentsOut.stringDatas.size;
                DexMerger.this.idsDefsOut.writeInt(DexMerger.this.stringDataOut.getPosition());
                DexMerger.this.stringDataOut.writeStringData(string);
            }
        }.mergeSorted();
    }

    private void mergeTypeIds() {
        new IdMerger<Integer>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.typeIds;
            }

            @Override
            Integer read(Dex.Section section, IndexMap indexMap, int n) {
                int n2 = section.readInt();
                return indexMap.adjustString(n2);
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                if (n3 < 0 || n3 > 65535) {
                    throw new IllegalArgumentException("type ID not in [0, 0xffff]: " + n3);
                }
                indexMap.typeIds[n2] = (short)n3;
            }

            @Override
            void write(Integer n) {
                DexMerger.this.idsDefsOut.writeInt(n);
            }
        }.mergeSorted();
    }

    private void mergeTypeLists() {
        new IdMerger<TypeList>(this.typeListOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.typeLists;
            }

            @Override
            TypeList read(Dex.Section section, IndexMap indexMap, int n) {
                return indexMap.adjustTypeList(section.readTypeList());
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                indexMap.putTypeListOffset(n, DexMerger.this.typeListOut.getPosition());
            }

            @Override
            void write(TypeList typeList) {
                DexMerger.this.typeListOut.writeTypeList(typeList);
            }
        }.mergeUnsorted();
    }

    private void mergeProtoIds() {
        new IdMerger<ProtoId>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.protoIds;
            }

            @Override
            ProtoId read(Dex.Section section, IndexMap indexMap, int n) {
                return indexMap.adjust(section.readProtoId());
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                if (n3 < 0 || n3 > 65535) {
                    throw new IllegalArgumentException("proto ID not in [0, 0xffff]: " + n3);
                }
                indexMap.protoIds[n2] = (short)n3;
            }

            @Override
            void write(ProtoId protoId) {
                protoId.writeTo(DexMerger.this.idsDefsOut);
            }
        }.mergeSorted();
    }

    private void mergeFieldIds() {
        new IdMerger<FieldId>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.fieldIds;
            }

            @Override
            FieldId read(Dex.Section section, IndexMap indexMap, int n) {
                return indexMap.adjust(section.readFieldId());
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                if (n3 < 0 || n3 > 65535) {
                    throw new IllegalArgumentException("field ID not in [0, 0xffff]: " + n3);
                }
                indexMap.fieldIds[n2] = (short)n3;
            }

            @Override
            void write(FieldId fieldId) {
                fieldId.writeTo(DexMerger.this.idsDefsOut);
            }
        }.mergeSorted();
    }

    private void mergeMethodIds() {
        new IdMerger<MethodId>(this.idsDefsOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.methodIds;
            }

            @Override
            MethodId read(Dex.Section section, IndexMap indexMap, int n) {
                return indexMap.adjust(section.readMethodId());
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                if (n3 < 0 || n3 > 65535) {
                    throw new IllegalArgumentException("method ID not in [0, 0xffff]: " + n3);
                }
                indexMap.methodIds[n2] = (short)n3;
            }

            @Override
            void write(MethodId methodId) {
                methodId.writeTo(DexMerger.this.idsDefsOut);
            }
        }.mergeSorted();
    }

    private void mergeAnnotations() {
        new IdMerger<Annotation>(this.annotationOut){

            @Override
            TableOfContents.Section getSection(TableOfContents tableOfContents) {
                return tableOfContents.annotations;
            }

            @Override
            Annotation read(Dex.Section section, IndexMap indexMap, int n) {
                return indexMap.adjust(section.readAnnotation());
            }

            @Override
            void updateIndex(int n, IndexMap indexMap, int n2, int n3) {
                indexMap.putAnnotationOffset(n, DexMerger.this.annotationOut.getPosition());
            }

            @Override
            void write(Annotation annotation) {
                annotation.writeTo(DexMerger.this.annotationOut);
            }
        }.mergeUnsorted();
    }

    private void mergeClassDefs() {
        SortableType[] sortableTypeArray = this.getSortedTypes();
        this.contentsOut.classDefs.off = this.idsDefsOut.getPosition();
        this.contentsOut.classDefs.size = sortableTypeArray.length;
        for (SortableType sortableType : sortableTypeArray) {
            Dex dex = sortableType.getDex();
            IndexMap indexMap = dex == this.dexA ? this.aIndexMap : this.bIndexMap;
            this.transformClassDef(dex, sortableType.getClassDef(), indexMap);
        }
    }

    private SortableType[] getSortedTypes() {
        int n;
        SortableType[] sortableTypeArray = new SortableType[this.contentsOut.typeIds.size];
        this.readSortableTypes(sortableTypeArray, this.dexA, this.aIndexMap);
        this.readSortableTypes(sortableTypeArray, this.dexB, this.bIndexMap);
        do {
            n = 1;
            for (SortableType sortableType : sortableTypeArray) {
                if (sortableType == null || sortableType.isDepthAssigned()) continue;
                n &= sortableType.tryAssignDepth(sortableTypeArray);
            }
        } while (n == 0);
        Arrays.sort(sortableTypeArray, SortableType.NULLS_LAST_ORDER);
        n = Arrays.asList(sortableTypeArray).indexOf(null);
        return n != -1 ? Arrays.copyOfRange(sortableTypeArray, 0, n) : sortableTypeArray;
    }

    private void readSortableTypes(SortableType[] sortableTypeArray, Dex dex, IndexMap indexMap) {
        for (ClassDef classDef : dex.classDefs()) {
            SortableType sortableType = indexMap.adjust(new SortableType(dex, classDef));
            int n = sortableType.getTypeIndex();
            if (sortableTypeArray[n] == null) {
                sortableTypeArray[n] = sortableType;
                continue;
            }
            if (this.collisionPolicy == CollisionPolicy.KEEP_FIRST) continue;
            throw new DexException("Multiple dex files define " + dex.typeNames().get(classDef.getTypeIndex()));
        }
    }

    private void unionAnnotationSetsAndDirectories() {
        this.transformAnnotationSets(this.dexA, this.aIndexMap);
        this.transformAnnotationSets(this.dexB, this.bIndexMap);
        this.transformAnnotationSetRefLists(this.dexA, this.aIndexMap);
        this.transformAnnotationSetRefLists(this.dexB, this.bIndexMap);
        this.transformAnnotationDirectories(this.dexA, this.aIndexMap);
        this.transformAnnotationDirectories(this.dexB, this.bIndexMap);
        this.transformStaticValues(this.dexA, this.aIndexMap);
        this.transformStaticValues(this.dexB, this.bIndexMap);
    }

    private void transformAnnotationSets(Dex dex, IndexMap indexMap) {
        TableOfContents.Section section = dex.getTableOfContents().annotationSets;
        if (section.exists()) {
            Dex.Section section2 = dex.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                this.transformAnnotationSet(indexMap, section2);
            }
        }
    }

    private void transformAnnotationSetRefLists(Dex dex, IndexMap indexMap) {
        TableOfContents.Section section = dex.getTableOfContents().annotationSetRefLists;
        if (section.exists()) {
            Dex.Section section2 = dex.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                this.transformAnnotationSetRefList(indexMap, section2);
            }
        }
    }

    private void transformAnnotationDirectories(Dex dex, IndexMap indexMap) {
        TableOfContents.Section section = dex.getTableOfContents().annotationsDirectories;
        if (section.exists()) {
            Dex.Section section2 = dex.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                this.transformAnnotationDirectory(section2, indexMap);
            }
        }
    }

    private void transformStaticValues(Dex dex, IndexMap indexMap) {
        TableOfContents.Section section = dex.getTableOfContents().encodedArrays;
        if (section.exists()) {
            Dex.Section section2 = dex.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                this.transformStaticValues(section2, indexMap);
            }
        }
    }

    private void transformClassDef(Dex dex, ClassDef classDef, IndexMap indexMap) {
        this.idsDefsOut.assertFourByteAligned();
        this.idsDefsOut.writeInt(classDef.getTypeIndex());
        this.idsDefsOut.writeInt(classDef.getAccessFlags());
        this.idsDefsOut.writeInt(classDef.getSupertypeIndex());
        this.idsDefsOut.writeInt(classDef.getInterfacesOffset());
        int n = indexMap.adjustString(classDef.getSourceFileIndex());
        this.idsDefsOut.writeInt(n);
        int n2 = classDef.getAnnotationsOffset();
        this.idsDefsOut.writeInt(indexMap.adjustAnnotationDirectory(n2));
        int n3 = classDef.getClassDataOffset();
        if (n3 == 0) {
            this.idsDefsOut.writeInt(0);
        } else {
            this.idsDefsOut.writeInt(this.classDataOut.getPosition());
            ClassData classData = dex.readClassData(classDef);
            this.transformClassData(dex, classData, indexMap);
        }
        int n4 = classDef.getStaticValuesOffset();
        this.idsDefsOut.writeInt(indexMap.adjustStaticValues(n4));
    }

    private void transformAnnotationDirectory(Dex.Section section, IndexMap indexMap) {
        int n;
        ++this.contentsOut.annotationsDirectories.size;
        this.annotationsDirectoryOut.assertFourByteAligned();
        indexMap.putAnnotationDirectoryOffset(section.getPosition(), this.annotationsDirectoryOut.getPosition());
        int n2 = indexMap.adjustAnnotationSet(section.readInt());
        this.annotationsDirectoryOut.writeInt(n2);
        int n3 = section.readInt();
        this.annotationsDirectoryOut.writeInt(n3);
        int n4 = section.readInt();
        this.annotationsDirectoryOut.writeInt(n4);
        int n5 = section.readInt();
        this.annotationsDirectoryOut.writeInt(n5);
        for (n = 0; n < n3; ++n) {
            this.annotationsDirectoryOut.writeInt(indexMap.adjustField(section.readInt()));
            this.annotationsDirectoryOut.writeInt(indexMap.adjustAnnotationSet(section.readInt()));
        }
        for (n = 0; n < n4; ++n) {
            this.annotationsDirectoryOut.writeInt(indexMap.adjustMethod(section.readInt()));
            this.annotationsDirectoryOut.writeInt(indexMap.adjustAnnotationSet(section.readInt()));
        }
        for (n = 0; n < n5; ++n) {
            this.annotationsDirectoryOut.writeInt(indexMap.adjustMethod(section.readInt()));
            this.annotationsDirectoryOut.writeInt(indexMap.adjustAnnotationSetRefList(section.readInt()));
        }
    }

    private void transformAnnotationSet(IndexMap indexMap, Dex.Section section) {
        ++this.contentsOut.annotationSets.size;
        this.annotationSetOut.assertFourByteAligned();
        indexMap.putAnnotationSetOffset(section.getPosition(), this.annotationSetOut.getPosition());
        int n = section.readInt();
        this.annotationSetOut.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.annotationSetOut.writeInt(indexMap.adjustAnnotation(section.readInt()));
        }
    }

    private void transformAnnotationSetRefList(IndexMap indexMap, Dex.Section section) {
        ++this.contentsOut.annotationSetRefLists.size;
        this.annotationSetRefListOut.assertFourByteAligned();
        indexMap.putAnnotationSetRefListOffset(section.getPosition(), this.annotationSetRefListOut.getPosition());
        int n = section.readInt();
        this.annotationSetRefListOut.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.annotationSetRefListOut.writeInt(indexMap.adjustAnnotationSet(section.readInt()));
        }
    }

    private void transformClassData(Dex dex, ClassData classData, IndexMap indexMap) {
        ++this.contentsOut.classDatas.size;
        ClassData.Field[] fieldArray = classData.getStaticFields();
        ClassData.Field[] fieldArray2 = classData.getInstanceFields();
        ClassData.Method[] methodArray = classData.getDirectMethods();
        ClassData.Method[] methodArray2 = classData.getVirtualMethods();
        this.classDataOut.writeUleb128(fieldArray.length);
        this.classDataOut.writeUleb128(fieldArray2.length);
        this.classDataOut.writeUleb128(methodArray.length);
        this.classDataOut.writeUleb128(methodArray2.length);
        this.transformFields(indexMap, fieldArray);
        this.transformFields(indexMap, fieldArray2);
        this.transformMethods(dex, indexMap, methodArray);
        this.transformMethods(dex, indexMap, methodArray2);
    }

    private void transformFields(IndexMap indexMap, ClassData.Field[] fieldArray) {
        int n = 0;
        for (ClassData.Field field : fieldArray) {
            int n2 = indexMap.adjustField(field.getFieldIndex());
            this.classDataOut.writeUleb128(n2 - n);
            n = n2;
            this.classDataOut.writeUleb128(field.getAccessFlags());
        }
    }

    private void transformMethods(Dex dex, IndexMap indexMap, ClassData.Method[] methodArray) {
        int n = 0;
        for (ClassData.Method method : methodArray) {
            int n2 = indexMap.adjustMethod(method.getMethodIndex());
            this.classDataOut.writeUleb128(n2 - n);
            n = n2;
            this.classDataOut.writeUleb128(method.getAccessFlags());
            if (method.getCodeOffset() == 0) {
                this.classDataOut.writeUleb128(0);
                continue;
            }
            this.codeOut.alignToFourBytesWithZeroFill();
            this.classDataOut.writeUleb128(this.codeOut.getPosition());
            this.transformCode(dex, dex.readCode(method), indexMap);
        }
    }

    private void transformCode(Dex dex, Code code, IndexMap indexMap) {
        ++this.contentsOut.codes.size;
        this.codeOut.assertFourByteAligned();
        this.codeOut.writeUnsignedShort(code.getRegistersSize());
        this.codeOut.writeUnsignedShort(code.getInsSize());
        this.codeOut.writeUnsignedShort(code.getOutsSize());
        Code.Try[] tryArray = code.getTries();
        Code.CatchHandler[] catchHandlerArray = code.getCatchHandlers();
        this.codeOut.writeUnsignedShort(tryArray.length);
        int n = code.getDebugInfoOffset();
        if (n != 0) {
            this.codeOut.writeInt(this.debugInfoOut.getPosition());
            this.transformDebugInfoItem(dex.open(n), indexMap);
        } else {
            this.codeOut.writeInt(0);
        }
        short[] sArray = code.getInstructions();
        InstructionTransformer instructionTransformer = dex == this.dexA ? this.aInstructionTransformer : this.bInstructionTransformer;
        short[] sArray2 = instructionTransformer.transform(sArray);
        this.codeOut.writeInt(sArray2.length);
        this.codeOut.write(sArray2);
        if (tryArray.length > 0) {
            if (sArray2.length % 2 == 1) {
                this.codeOut.writeShort((short)0);
            }
            Dex.Section section = this.dexOut.open(this.codeOut.getPosition());
            this.codeOut.skip(tryArray.length * 8);
            int[] nArray = this.transformCatchHandlers(indexMap, catchHandlerArray);
            this.transformTries(section, tryArray, nArray);
        }
    }

    private int[] transformCatchHandlers(IndexMap indexMap, Code.CatchHandler[] catchHandlerArray) {
        int n = this.codeOut.getPosition();
        this.codeOut.writeUleb128(catchHandlerArray.length);
        int[] nArray = new int[catchHandlerArray.length];
        for (int i = 0; i < catchHandlerArray.length; ++i) {
            nArray[i] = this.codeOut.getPosition() - n;
            this.transformEncodedCatchHandler(catchHandlerArray[i], indexMap);
        }
        return nArray;
    }

    private void transformTries(Dex.Section section, Code.Try[] tryArray, int[] nArray) {
        for (Code.Try try_ : tryArray) {
            section.writeInt(try_.getStartAddress());
            section.writeUnsignedShort(try_.getInstructionCount());
            section.writeUnsignedShort(nArray[try_.getCatchHandlerIndex()]);
        }
    }

    private void transformDebugInfoItem(Dex.Section section, IndexMap indexMap) {
        int n;
        int n2;
        ++this.contentsOut.debugInfos.size;
        int n3 = section.readUleb128();
        this.debugInfoOut.writeUleb128(n3);
        int n4 = section.readUleb128();
        this.debugInfoOut.writeUleb128(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            n = section.readUleb128p1();
            this.debugInfoOut.writeUleb128p1(indexMap.adjustString(n));
        }
        while (true) {
            byte by = section.readByte();
            this.debugInfoOut.writeByte(by);
            switch (by) {
                case 0: {
                    return;
                }
                case 1: {
                    n2 = section.readUleb128();
                    this.debugInfoOut.writeUleb128(n2);
                    break;
                }
                case 2: {
                    n = section.readSleb128();
                    this.debugInfoOut.writeSleb128(n);
                    break;
                }
                case 3: 
                case 4: {
                    int n5 = section.readUleb128();
                    this.debugInfoOut.writeUleb128(n5);
                    int n6 = section.readUleb128p1();
                    this.debugInfoOut.writeUleb128p1(indexMap.adjustString(n6));
                    int n7 = section.readUleb128p1();
                    this.debugInfoOut.writeUleb128p1(indexMap.adjustType(n7));
                    if (by != 4) break;
                    int n8 = section.readUleb128p1();
                    this.debugInfoOut.writeUleb128p1(indexMap.adjustString(n8));
                    break;
                }
                case 5: 
                case 6: {
                    int n5 = section.readUleb128();
                    this.debugInfoOut.writeUleb128(n5);
                    break;
                }
                case 9: {
                    int n6 = section.readUleb128p1();
                    this.debugInfoOut.writeUleb128p1(indexMap.adjustString(n6));
                    break;
                }
            }
        }
    }

    private void transformEncodedCatchHandler(Code.CatchHandler catchHandler, IndexMap indexMap) {
        int n = catchHandler.getCatchAllAddress();
        int[] nArray = catchHandler.getTypeIndexes();
        int[] nArray2 = catchHandler.getAddresses();
        if (n != -1) {
            this.codeOut.writeSleb128(-nArray.length);
        } else {
            this.codeOut.writeSleb128(nArray.length);
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.codeOut.writeUleb128(indexMap.adjustType(nArray[i]));
            this.codeOut.writeUleb128(nArray2[i]);
        }
        if (n != -1) {
            this.codeOut.writeUleb128(n);
        }
    }

    private void transformStaticValues(Dex.Section section, IndexMap indexMap) {
        ++this.contentsOut.encodedArrays.size;
        indexMap.putStaticValuesOffset(section.getPosition(), this.encodedArrayOut.getPosition());
        indexMap.adjustEncodedArray(section.readEncodedArray()).writeTo(this.encodedArrayOut);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2) {
            DexMerger.printUsage();
            return;
        }
        Dex dex = new Dex(new File(stringArray[1]));
        for (int i = 2; i < stringArray.length; ++i) {
            Dex dex2 = new Dex(new File(stringArray[i]));
            dex = new DexMerger(dex, dex2, CollisionPolicy.KEEP_FIRST).merge();
        }
        dex.writeTo(new File(stringArray[0]));
    }

    private static void printUsage() {
        System.out.println("Usage: DexMerger <out.dex> <a.dex> <b.dex> ...");
        System.out.println();
        System.out.println("If a class is defined in several dex, the class found in the first dex will be used.");
    }

    private static class WriterSizes {
        private int header = 112;
        private int idsDefs;
        private int mapList;
        private int typeList;
        private int classData;
        private int code;
        private int stringData;
        private int debugInfo;
        private int encodedArray;
        private int annotationsDirectory;
        private int annotationsSet;
        private int annotationsSetRefList;
        private int annotation;

        public WriterSizes(Dex dex, Dex dex2) {
            this.plus(dex.getTableOfContents(), false);
            this.plus(dex2.getTableOfContents(), false);
            this.fourByteAlign();
        }

        public WriterSizes(DexMerger dexMerger) {
            this.header = dexMerger.headerOut.used();
            this.idsDefs = dexMerger.idsDefsOut.used();
            this.mapList = dexMerger.mapListOut.used();
            this.typeList = dexMerger.typeListOut.used();
            this.classData = dexMerger.classDataOut.used();
            this.code = dexMerger.codeOut.used();
            this.stringData = dexMerger.stringDataOut.used();
            this.debugInfo = dexMerger.debugInfoOut.used();
            this.encodedArray = dexMerger.encodedArrayOut.used();
            this.annotationsDirectory = dexMerger.annotationsDirectoryOut.used();
            this.annotationsSet = dexMerger.annotationSetOut.used();
            this.annotationsSetRefList = dexMerger.annotationSetRefListOut.used();
            this.annotation = dexMerger.annotationOut.used();
            this.fourByteAlign();
        }

        private void plus(TableOfContents tableOfContents, boolean bl) {
            this.idsDefs += tableOfContents.stringIds.size * 4 + tableOfContents.typeIds.size * 4 + tableOfContents.protoIds.size * 12 + tableOfContents.fieldIds.size * 8 + tableOfContents.methodIds.size * 8 + tableOfContents.classDefs.size * 32;
            this.mapList = 4 + tableOfContents.sections.length * 12;
            this.typeList += WriterSizes.fourByteAlign(tableOfContents.typeLists.byteCount);
            this.stringData += tableOfContents.stringDatas.byteCount;
            this.annotationsDirectory += tableOfContents.annotationsDirectories.byteCount;
            this.annotationsSet += tableOfContents.annotationSets.byteCount;
            this.annotationsSetRefList += tableOfContents.annotationSetRefLists.byteCount;
            if (bl) {
                this.code += tableOfContents.codes.byteCount;
                this.classData += tableOfContents.classDatas.byteCount;
                this.encodedArray += tableOfContents.encodedArrays.byteCount;
                this.annotation += tableOfContents.annotations.byteCount;
                this.debugInfo += tableOfContents.debugInfos.byteCount;
            } else {
                this.code += (int)Math.ceil((double)tableOfContents.codes.byteCount * 1.25);
                this.classData += (int)Math.ceil((double)tableOfContents.classDatas.byteCount * 1.34);
                this.encodedArray += tableOfContents.encodedArrays.byteCount * 2;
                this.annotation += (int)Math.ceil(tableOfContents.annotations.byteCount * 2);
                this.debugInfo += tableOfContents.debugInfos.byteCount * 2;
            }
        }

        private void fourByteAlign() {
            this.header = WriterSizes.fourByteAlign(this.header);
            this.idsDefs = WriterSizes.fourByteAlign(this.idsDefs);
            this.mapList = WriterSizes.fourByteAlign(this.mapList);
            this.typeList = WriterSizes.fourByteAlign(this.typeList);
            this.classData = WriterSizes.fourByteAlign(this.classData);
            this.code = WriterSizes.fourByteAlign(this.code);
            this.stringData = WriterSizes.fourByteAlign(this.stringData);
            this.debugInfo = WriterSizes.fourByteAlign(this.debugInfo);
            this.encodedArray = WriterSizes.fourByteAlign(this.encodedArray);
            this.annotationsDirectory = WriterSizes.fourByteAlign(this.annotationsDirectory);
            this.annotationsSet = WriterSizes.fourByteAlign(this.annotationsSet);
            this.annotationsSetRefList = WriterSizes.fourByteAlign(this.annotationsSetRefList);
            this.annotation = WriterSizes.fourByteAlign(this.annotation);
        }

        private static int fourByteAlign(int n) {
            return n + 3 & 0xFFFFFFFC;
        }

        public int size() {
            return this.header + this.idsDefs + this.mapList + this.typeList + this.classData + this.code + this.stringData + this.debugInfo + this.encodedArray + this.annotationsDirectory + this.annotationsSet + this.annotationsSetRefList + this.annotation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class IdMerger<T extends Comparable<T>> {
        private final Dex.Section out;

        protected IdMerger(Dex.Section section) {
            this.out = section;
        }

        public final void mergeSorted() {
            TableOfContents.Section section = this.getSection(DexMerger.this.dexA.getTableOfContents());
            TableOfContents.Section section2 = this.getSection(DexMerger.this.dexB.getTableOfContents());
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).off = this.out.getPosition();
            Dex.Section section3 = section.exists() ? DexMerger.this.dexA.open(section.off) : null;
            Dex.Section section4 = section2.exists() ? DexMerger.this.dexB.open(section2.off) : null;
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Comparable comparable = null;
            Object var11_11 = null;
            while (true) {
                boolean bl;
                boolean bl2;
                if (comparable == null && n3 < section.size) {
                    n = section3.getPosition();
                    comparable = this.read(section3, DexMerger.this.aIndexMap, n3);
                }
                if (var11_11 == null && n4 < section2.size) {
                    n2 = section4.getPosition();
                    var11_11 = this.read(section4, DexMerger.this.bIndexMap, n4);
                }
                if (comparable != null && var11_11 != null) {
                    int n6 = comparable.compareTo(var11_11);
                    bl2 = n6 <= 0;
                    bl = n6 >= 0;
                } else {
                    bl2 = comparable != null;
                    bl = var11_11 != null;
                }
                Comparable comparable2 = null;
                if (bl2) {
                    comparable2 = comparable;
                    this.updateIndex(n, DexMerger.this.aIndexMap, n3++, n5);
                    comparable = null;
                    n = -1;
                }
                if (bl) {
                    comparable2 = var11_11;
                    this.updateIndex(n2, DexMerger.this.bIndexMap, n4++, n5);
                    var11_11 = null;
                    n2 = -1;
                }
                if (comparable2 == null) break;
                this.write(comparable2);
                ++n5;
            }
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).size = n5;
        }

        public final void mergeUnsorted() {
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).off = this.out.getPosition();
            ArrayList<UnsortedValue> arrayList = new ArrayList<UnsortedValue>();
            arrayList.addAll(this.readUnsortedValues(DexMerger.this.dexA, DexMerger.this.aIndexMap));
            arrayList.addAll(this.readUnsortedValues(DexMerger.this.dexB, DexMerger.this.bIndexMap));
            Collections.sort(arrayList);
            int n = 0;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                UnsortedValue unsortedValue = (UnsortedValue)arrayList.get(n2++);
                this.updateIndex(unsortedValue.offset, DexMerger.this.getIndexMap(unsortedValue.source), unsortedValue.index, n - 1);
                while (n2 < arrayList.size() && unsortedValue.compareTo((UnsortedValue)arrayList.get(n2)) == 0) {
                    UnsortedValue unsortedValue2 = (UnsortedValue)arrayList.get(n2++);
                    this.updateIndex(unsortedValue2.offset, DexMerger.this.getIndexMap(unsortedValue2.source), unsortedValue2.index, n - 1);
                }
                this.write(unsortedValue.value);
                ++n;
            }
            this.getSection((TableOfContents)((DexMerger)DexMerger.this).contentsOut).size = n;
        }

        private List<UnsortedValue> readUnsortedValues(Dex dex, IndexMap indexMap) {
            TableOfContents.Section section = this.getSection(dex.getTableOfContents());
            if (!section.exists()) {
                return Collections.emptyList();
            }
            ArrayList<UnsortedValue> arrayList = new ArrayList<UnsortedValue>();
            Dex.Section section2 = dex.open(section.off);
            for (int i = 0; i < section.size; ++i) {
                int n = section2.getPosition();
                T t = this.read(section2, indexMap, 0);
                arrayList.add(new UnsortedValue(this, dex, indexMap, t, i, n));
            }
            return arrayList;
        }

        abstract TableOfContents.Section getSection(TableOfContents var1);

        abstract T read(Dex.Section var1, IndexMap var2, int var3);

        abstract void updateIndex(int var1, IndexMap var2, int var3, int var4);

        abstract void write(T var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UnsortedValue
        implements Comparable<UnsortedValue> {
            final Dex source;
            final IndexMap indexMap;
            final T value;
            final int index;
            final int offset;
            final /* synthetic */ IdMerger this$1;

            /*
             * WARNING - Possible parameter corruption
             */
            UnsortedValue(Dex dex, IndexMap indexMap, T t, int n2, int n3) {
                this.this$1 = (IdMerger)n;
                this.source = dex;
                this.indexMap = indexMap;
                this.value = t;
                this.index = n2;
                this.offset = n3;
            }

            @Override
            public int compareTo(UnsortedValue unsortedValue) {
                return this.value.compareTo(unsortedValue.value);
            }
        }
    }
}

