/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.Section;
import com.android.dx.util.AnnotatedOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OffsettedItem
extends Item
implements Comparable<OffsettedItem> {
    private final int alignment;
    private int writeSize;
    private Section addedTo;
    private int offset;

    public static int getAbsoluteOffsetOr0(OffsettedItem offsettedItem) {
        if (offsettedItem == null) {
            return 0;
        }
        return offsettedItem.getAbsoluteOffset();
    }

    public OffsettedItem(int n, int n2) {
        Section.validateAlignment(n);
        if (n2 < -1) {
            throw new IllegalArgumentException("writeSize < -1");
        }
        this.alignment = n;
        this.writeSize = n2;
        this.addedTo = null;
        this.offset = -1;
    }

    public final boolean equals(Object object) {
        ItemType itemType;
        if (this == object) {
            return true;
        }
        OffsettedItem offsettedItem = (OffsettedItem)object;
        ItemType itemType2 = this.itemType();
        if (itemType2 != (itemType = offsettedItem.itemType())) {
            return false;
        }
        return this.compareTo0(offsettedItem) == 0;
    }

    @Override
    public final int compareTo(OffsettedItem offsettedItem) {
        ItemType itemType;
        if (this == offsettedItem) {
            return 0;
        }
        ItemType itemType2 = this.itemType();
        if (itemType2 != (itemType = offsettedItem.itemType())) {
            return itemType2.compareTo(itemType);
        }
        return this.compareTo0(offsettedItem);
    }

    public final void setWriteSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("writeSize < 0");
        }
        if (this.writeSize >= 0) {
            throw new UnsupportedOperationException("writeSize already set");
        }
        this.writeSize = n;
    }

    @Override
    public final int writeSize() {
        if (this.writeSize < 0) {
            throw new UnsupportedOperationException("writeSize is unknown");
        }
        return this.writeSize;
    }

    @Override
    public final void writeTo(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        annotatedOutput.alignTo(this.alignment);
        try {
            if (this.writeSize < 0) {
                throw new UnsupportedOperationException("writeSize is unknown");
            }
            annotatedOutput.assertCursor(this.getAbsoluteOffset());
        }
        catch (RuntimeException runtimeException) {
            throw ExceptionWithContext.withContext(runtimeException, "...while writing " + this);
        }
        this.writeTo0(dexFile, annotatedOutput);
    }

    public final int getRelativeOffset() {
        if (this.offset < 0) {
            throw new RuntimeException("offset not yet known");
        }
        return this.offset;
    }

    public final int getAbsoluteOffset() {
        if (this.offset < 0) {
            throw new RuntimeException("offset not yet known");
        }
        return this.addedTo.getAbsoluteOffset(this.offset);
    }

    public final int place(Section section, int n) {
        if (section == null) {
            throw new NullPointerException("addedTo == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (this.addedTo != null) {
            throw new RuntimeException("already written");
        }
        int n2 = this.alignment - 1;
        n = n + n2 & ~n2;
        this.addedTo = section;
        this.offset = n;
        this.place0(section, n);
        return n;
    }

    public final int getAlignment() {
        return this.alignment;
    }

    public final String offsetString() {
        return '[' + Integer.toHexString(this.getAbsoluteOffset()) + ']';
    }

    public abstract String toHuman();

    protected int compareTo0(OffsettedItem offsettedItem) {
        throw new UnsupportedOperationException("unsupported");
    }

    protected void place0(Section section, int n) {
    }

    protected abstract void writeTo0(DexFile var1, AnnotatedOutput var2);
}

