/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.DexException;
import com.android.dx.command.dexer.Main;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.MemberIdItem;
import com.android.dx.dex.file.MethodIdsSection;
import com.android.dx.dex.file.UniformItemSection;
import java.util.Formatter;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MemberIdsSection
extends UniformItemSection {
    public MemberIdsSection(String string, DexFile dexFile) {
        super(string, dexFile, 4);
    }

    protected void orderItems() {
        int n = 0;
        if (this.items().size() > 65536) {
            throw new DexException(this.getTooManyMembersMessage());
        }
        for (Item item : this.items()) {
            ((MemberIdItem)item).setIndex(n);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String getTooManyMembersMessage() {
        Object object;
        TreeMap<String, AtomicInteger> treeMap = new TreeMap<String, AtomicInteger>();
        for (Item object2 : this.items()) {
            void var5_6;
            object = ((MemberIdItem)object2).getDefiningClass().getPackageName();
            AtomicInteger atomicInteger = (AtomicInteger)treeMap.get(object);
            if (atomicInteger == null) {
                AtomicInteger atomicInteger2 = new AtomicInteger();
                treeMap.put((String)object, atomicInteger2);
            }
            var5_6.incrementAndGet();
        }
        Formatter formatter = new Formatter();
        try {
            String string = this instanceof MethodIdsSection ? "method" : "field";
            formatter.format("Too many %s references: %d; max is %d.%n" + Main.getTooManyIdsErrorMessage() + "%n" + "References by package:", string, this.items().size(), 65536);
            for (Map.Entry entry : treeMap.entrySet()) {
                formatter.format("%n%6d %s", ((AtomicInteger)entry.getValue()).get(), entry.getKey());
            }
            object = formatter.toString();
            return object;
        }
        finally {
            formatter.close();
        }
    }
}

