/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.Leb128;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedMember;
import com.android.dx.dex.file.FieldIdsSection;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstString;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.io.PrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncodedField
extends EncodedMember
implements Comparable<EncodedField> {
    private final CstFieldRef field;

    public EncodedField(CstFieldRef cstFieldRef, int n) {
        super(n);
        if (cstFieldRef == null) {
            throw new NullPointerException("field == null");
        }
        this.field = cstFieldRef;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof EncodedField)) {
            return false;
        }
        return this.compareTo((EncodedField)object) == 0;
    }

    @Override
    public int compareTo(EncodedField encodedField) {
        return this.field.compareTo(encodedField.field);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('{');
        stringBuffer.append(Hex.u2(this.getAccessFlags()));
        stringBuffer.append(' ');
        stringBuffer.append(this.field);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public void addContents(DexFile dexFile) {
        FieldIdsSection fieldIdsSection = dexFile.getFieldIds();
        fieldIdsSection.intern(this.field);
    }

    @Override
    public CstString getName() {
        return this.field.getNat().getName();
    }

    @Override
    public String toHuman() {
        return this.field.toHuman();
    }

    @Override
    public void debugPrint(PrintWriter printWriter, boolean bl) {
        printWriter.println(this.toString());
    }

    public CstFieldRef getRef() {
        return this.field;
    }

    @Override
    public int encode(DexFile dexFile, AnnotatedOutput annotatedOutput, int n, int n2) {
        int n3 = dexFile.getFieldIds().indexOf(this.field);
        int n4 = n3 - n;
        int n5 = this.getAccessFlags();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(0, String.format("  [%x] %s", n2, this.field.toHuman()));
            annotatedOutput.annotate(Leb128.unsignedLeb128Size(n4), "    field_idx:    " + Hex.u4(n3));
            annotatedOutput.annotate(Leb128.unsignedLeb128Size(n5), "    access_flags: " + AccessFlags.fieldString(n5));
        }
        annotatedOutput.writeUleb128(n4);
        annotatedOutput.writeUleb128(n5);
        return n3;
    }
}

