/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.ClassDefsSection;
import com.android.dx.dex.file.FieldIdsSection;
import com.android.dx.dex.file.HeaderSection;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.MapItem;
import com.android.dx.dex.file.MethodIdsSection;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.dex.file.ProtoIdsSection;
import com.android.dx.dex.file.Section;
import com.android.dx.dex.file.Statistics;
import com.android.dx.dex.file.StringIdsSection;
import com.android.dx.dex.file.TypeIdsSection;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstBaseMethodRef;
import com.android.dx.rop.cst.CstEnumRef;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.ByteArrayAnnotatedOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;

public final class DexFile {
    private DexOptions dexOptions;
    private final MixedItemSection wordData;
    private final MixedItemSection typeLists;
    private final MixedItemSection map;
    private final MixedItemSection stringData;
    private final StringIdsSection stringIds;
    private final TypeIdsSection typeIds;
    private final ProtoIdsSection protoIds;
    private final FieldIdsSection fieldIds;
    private final MethodIdsSection methodIds;
    private final ClassDefsSection classDefs;
    private final MixedItemSection classData;
    private final MixedItemSection byteData;
    private final HeaderSection header;
    private final Section[] sections;
    private int fileSize;
    private int dumpWidth;

    public DexFile(DexOptions dexOptions) {
        this.dexOptions = dexOptions;
        this.header = new HeaderSection(this);
        this.typeLists = new MixedItemSection(null, this, 4, MixedItemSection.SortType.NONE);
        this.wordData = new MixedItemSection("word_data", this, 4, MixedItemSection.SortType.TYPE);
        this.stringData = new MixedItemSection("string_data", this, 1, MixedItemSection.SortType.INSTANCE);
        this.classData = new MixedItemSection(null, this, 1, MixedItemSection.SortType.NONE);
        this.byteData = new MixedItemSection("byte_data", this, 1, MixedItemSection.SortType.TYPE);
        this.stringIds = new StringIdsSection(this);
        this.typeIds = new TypeIdsSection(this);
        this.protoIds = new ProtoIdsSection(this);
        this.fieldIds = new FieldIdsSection(this);
        this.methodIds = new MethodIdsSection(this);
        this.classDefs = new ClassDefsSection(this);
        this.map = new MixedItemSection("map", this, 4, MixedItemSection.SortType.NONE);
        this.sections = new Section[]{this.header, this.stringIds, this.typeIds, this.protoIds, this.fieldIds, this.methodIds, this.classDefs, this.wordData, this.typeLists, this.stringData, this.byteData, this.classData, this.map};
        this.fileSize = -1;
        this.dumpWidth = 79;
    }

    public boolean isEmpty() {
        return this.classDefs.items().isEmpty();
    }

    public DexOptions getDexOptions() {
        return this.dexOptions;
    }

    public void add(ClassDefItem classDefItem) {
        this.classDefs.add(classDefItem);
    }

    public ClassDefItem getClassOrNull(String string) {
        try {
            Type type = Type.internClassName(string);
            return (ClassDefItem)this.classDefs.get(new CstType(type));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public void writeTo(OutputStream outputStream, Writer writer, boolean bl) throws IOException {
        boolean bl2 = writer != null;
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = this.toDex0(bl2, bl);
        if (outputStream != null) {
            outputStream.write(byteArrayAnnotatedOutput.getArray());
        }
        if (bl2) {
            byteArrayAnnotatedOutput.writeAnnotationsTo(writer);
        }
    }

    public byte[] toDex(Writer writer, boolean bl) throws IOException {
        boolean bl2 = writer != null;
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = this.toDex0(bl2, bl);
        if (bl2) {
            byteArrayAnnotatedOutput.writeAnnotationsTo(writer);
        }
        return byteArrayAnnotatedOutput.getArray();
    }

    public void setDumpWidth(int n) {
        if (n < 40) {
            throw new IllegalArgumentException("dumpWidth < 40");
        }
        this.dumpWidth = n;
    }

    public int getFileSize() {
        if (this.fileSize < 0) {
            throw new RuntimeException("file size not yet known");
        }
        return this.fileSize;
    }

    MixedItemSection getStringData() {
        return this.stringData;
    }

    MixedItemSection getWordData() {
        return this.wordData;
    }

    MixedItemSection getTypeLists() {
        return this.typeLists;
    }

    MixedItemSection getMap() {
        return this.map;
    }

    StringIdsSection getStringIds() {
        return this.stringIds;
    }

    ClassDefsSection getClassDefs() {
        return this.classDefs;
    }

    MixedItemSection getClassData() {
        return this.classData;
    }

    public TypeIdsSection getTypeIds() {
        return this.typeIds;
    }

    ProtoIdsSection getProtoIds() {
        return this.protoIds;
    }

    public FieldIdsSection getFieldIds() {
        return this.fieldIds;
    }

    public MethodIdsSection getMethodIds() {
        return this.methodIds;
    }

    MixedItemSection getByteData() {
        return this.byteData;
    }

    Section getFirstDataSection() {
        return this.wordData;
    }

    Section getLastDataSection() {
        return this.map;
    }

    void internIfAppropriate(Constant constant) {
        if (constant instanceof CstString) {
            this.stringIds.intern((CstString)constant);
        } else if (constant instanceof CstType) {
            this.typeIds.intern((CstType)constant);
        } else if (constant instanceof CstBaseMethodRef) {
            this.methodIds.intern((CstBaseMethodRef)constant);
        } else if (constant instanceof CstFieldRef) {
            this.fieldIds.intern((CstFieldRef)constant);
        } else if (constant instanceof CstEnumRef) {
            this.fieldIds.intern(((CstEnumRef)constant).getFieldRef());
        } else if (constant == null) {
            throw new NullPointerException("cst == null");
        }
    }

    IndexedItem findItemOrNull(Constant constant) {
        if (constant instanceof CstString) {
            return this.stringIds.get(constant);
        }
        if (constant instanceof CstType) {
            return this.typeIds.get(constant);
        }
        if (constant instanceof CstBaseMethodRef) {
            return this.methodIds.get(constant);
        }
        if (constant instanceof CstFieldRef) {
            return this.fieldIds.get(constant);
        }
        return null;
    }

    private ByteArrayAnnotatedOutput toDex0(boolean bl, boolean bl2) {
        int n;
        Object object;
        this.classDefs.prepare();
        this.classData.prepare();
        this.wordData.prepare();
        this.byteData.prepare();
        this.methodIds.prepare();
        this.fieldIds.prepare();
        this.protoIds.prepare();
        this.typeLists.prepare();
        this.typeIds.prepare();
        this.stringIds.prepare();
        this.stringData.prepare();
        this.header.prepare();
        int n2 = this.sections.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            object = this.sections[i];
            n = ((Section)object).setFileOffset(n3);
            if (n < n3) {
                throw new RuntimeException("bogus placement for section " + i);
            }
            try {
                if (object == this.map) {
                    MapItem.addMap(this.sections, this.map);
                    this.map.prepare();
                }
                if (object instanceof MixedItemSection) {
                    ((MixedItemSection)object).placeItems();
                }
                n3 = n + ((Section)object).writeSize();
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw ExceptionWithContext.withContext(runtimeException, "...while writing section " + i);
            }
        }
        this.fileSize = n3;
        byte[] byArray = new byte[this.fileSize];
        object = new ByteArrayAnnotatedOutput(byArray);
        if (bl) {
            ((ByteArrayAnnotatedOutput)object).enableAnnotations(this.dumpWidth, bl2);
        }
        for (n = 0; n < n2; ++n) {
            try {
                Section section = this.sections[n];
                int n4 = section.getFileOffset() - ((ByteArrayAnnotatedOutput)object).getCursor();
                if (n4 < 0) {
                    throw new ExceptionWithContext("excess write of " + -n4);
                }
                ((ByteArrayAnnotatedOutput)object).writeZeroes(section.getFileOffset() - ((ByteArrayAnnotatedOutput)object).getCursor());
                section.writeTo((AnnotatedOutput)object);
                continue;
            }
            catch (RuntimeException runtimeException) {
                ExceptionWithContext exceptionWithContext = runtimeException instanceof ExceptionWithContext ? (ExceptionWithContext)runtimeException : new ExceptionWithContext(runtimeException);
                exceptionWithContext.addContext("...while writing section " + n);
                throw exceptionWithContext;
            }
        }
        if (((ByteArrayAnnotatedOutput)object).getCursor() != this.fileSize) {
            throw new RuntimeException("foreshortened write");
        }
        DexFile.calcSignature(byArray);
        DexFile.calcChecksum(byArray);
        if (bl) {
            this.wordData.writeIndexAnnotation((AnnotatedOutput)object, ItemType.TYPE_CODE_ITEM, "\nmethod code index:\n\n");
            this.getStatistics().writeAnnotation((AnnotatedOutput)object);
            ((ByteArrayAnnotatedOutput)object).finishAnnotating();
        }
        return object;
    }

    public Statistics getStatistics() {
        Statistics statistics = new Statistics();
        for (Section section : this.sections) {
            statistics.addAll(section);
        }
        return statistics;
    }

    private static void calcSignature(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        messageDigest.update(byArray, 32, byArray.length - 32);
        try {
            int n = messageDigest.digest(byArray, 12, 20);
            if (n != 20) {
                throw new RuntimeException("unexpected digest write: " + n + " bytes");
            }
        }
        catch (DigestException digestException) {
            throw new RuntimeException(digestException);
        }
    }

    private static void calcChecksum(byte[] byArray) {
        Adler32 adler32 = new Adler32();
        adler32.update(byArray, 12, byArray.length - 12);
        int n = (int)adler32.getValue();
        byArray[8] = (byte)n;
        byArray[9] = (byte)(n >> 8);
        byArray[10] = (byte)(n >> 16);
        byArray[11] = (byte)(n >> 24);
    }
}

