/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.Leb128;
import com.android.dex.util.ByteArrayByteInput;
import com.android.dex.util.ByteInput;
import com.android.dex.util.ExceptionWithContext;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.DalvInsnList;
import com.android.dx.dex.code.LocalList;
import com.android.dx.dex.code.PositionList;
import com.android.dx.dex.file.DexFile;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugInfoDecoder {
    private final byte[] encoded;
    private final ArrayList<PositionEntry> positions;
    private final ArrayList<LocalEntry> locals;
    private final int codesize;
    private final LocalEntry[] lastEntryForReg;
    private final Prototype desc;
    private final boolean isStatic;
    private final DexFile file;
    private final int regSize;
    private int line = 1;
    private int address = 0;
    private final int thisStringIdx;

    DebugInfoDecoder(byte[] byArray, int n, int n2, boolean bl, CstMethodRef cstMethodRef, DexFile dexFile) {
        if (byArray == null) {
            throw new NullPointerException("encoded == null");
        }
        this.encoded = byArray;
        this.isStatic = bl;
        this.desc = cstMethodRef.getPrototype();
        this.file = dexFile;
        this.regSize = n2;
        this.positions = new ArrayList();
        this.locals = new ArrayList();
        this.codesize = n;
        this.lastEntryForReg = new LocalEntry[n2];
        int n3 = -1;
        try {
            n3 = dexFile.getStringIds().indexOf(new CstString("this"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.thisStringIdx = n3;
    }

    public List<PositionEntry> getPositionList() {
        return this.positions;
    }

    public List<LocalEntry> getLocals() {
        return this.locals;
    }

    public void decode() {
        try {
            this.decode0();
        }
        catch (Exception exception) {
            throw ExceptionWithContext.withContext(exception, "...while decoding debug info");
        }
    }

    private int readStringIndex(ByteInput byteInput) throws IOException {
        int n = Leb128.readUnsignedLeb128(byteInput);
        return n - 1;
    }

    private int getParamBase() {
        return this.regSize - this.desc.getParameterTypes().getWordCount() - (this.isStatic ? 0 : 1);
    }

    private void decode0() throws IOException {
        int n;
        ByteArrayByteInput byteArrayByteInput = new ByteArrayByteInput(this.encoded);
        this.line = Leb128.readUnsignedLeb128(byteArrayByteInput);
        int n2 = Leb128.readUnsignedLeb128(byteArrayByteInput);
        StdTypeList stdTypeList = this.desc.getParameterTypes();
        int n3 = this.getParamBase();
        if (n2 != stdTypeList.size()) {
            throw new RuntimeException("Mismatch between parameters_size and prototype");
        }
        if (!this.isStatic) {
            LocalEntry localEntry = new LocalEntry(0, true, n3, this.thisStringIdx, 0, 0);
            this.locals.add(localEntry);
            this.lastEntryForReg[n3] = localEntry;
            ++n3;
        }
        for (n = 0; n < n2; ++n) {
            Type type = stdTypeList.getType(n);
            int n4 = this.readStringIndex(byteArrayByteInput);
            LocalEntry localEntry = n4 == -1 ? new LocalEntry(0, true, n3, -1, 0, 0) : new LocalEntry(0, true, n3, n4, 0, 0);
            this.locals.add(localEntry);
            this.lastEntryForReg[n3] = localEntry;
            n3 += type.getCategory();
        }
        block17: while (true) {
            int n5;
            n = byteArrayByteInput.readByte() & 0xFF;
            switch (n) {
                case 3: {
                    n5 = Leb128.readUnsignedLeb128(byteArrayByteInput);
                    int n6 = this.readStringIndex(byteArrayByteInput);
                    int n7 = this.readStringIndex(byteArrayByteInput);
                    LocalEntry localEntry = new LocalEntry(this.address, true, n5, n6, n7, 0);
                    this.locals.add(localEntry);
                    this.lastEntryForReg[n5] = localEntry;
                    continue block17;
                }
                case 4: {
                    n5 = Leb128.readUnsignedLeb128(byteArrayByteInput);
                    int n8 = this.readStringIndex(byteArrayByteInput);
                    int n9 = this.readStringIndex(byteArrayByteInput);
                    int n10 = this.readStringIndex(byteArrayByteInput);
                    LocalEntry localEntry = new LocalEntry(this.address, true, n5, n8, n9, n10);
                    this.locals.add(localEntry);
                    this.lastEntryForReg[n5] = localEntry;
                    continue block17;
                }
                case 6: {
                    LocalEntry localEntry;
                    int n11 = Leb128.readUnsignedLeb128(byteArrayByteInput);
                    try {
                        LocalEntry localEntry2 = this.lastEntryForReg[n11];
                        if (localEntry2.isStart) {
                            throw new RuntimeException("nonsensical RESTART_LOCAL on live register v" + n11);
                        }
                        localEntry = new LocalEntry(this.address, true, n11, localEntry2.nameIndex, localEntry2.typeIndex, 0);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new RuntimeException("Encountered RESTART_LOCAL on new v" + n11);
                    }
                    this.locals.add(localEntry);
                    this.lastEntryForReg[n11] = localEntry;
                    continue block17;
                }
                case 5: {
                    LocalEntry localEntry;
                    int n12 = Leb128.readUnsignedLeb128(byteArrayByteInput);
                    try {
                        LocalEntry localEntry3 = this.lastEntryForReg[n12];
                        if (!localEntry3.isStart) {
                            throw new RuntimeException("nonsensical END_LOCAL on dead register v" + n12);
                        }
                        localEntry = new LocalEntry(this.address, false, n12, localEntry3.nameIndex, localEntry3.typeIndex, localEntry3.signatureIndex);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new RuntimeException("Encountered END_LOCAL on new v" + n12);
                    }
                    this.locals.add(localEntry);
                    this.lastEntryForReg[n12] = localEntry;
                    continue block17;
                }
                case 0: {
                    return;
                }
                case 1: {
                    this.address += Leb128.readUnsignedLeb128(byteArrayByteInput);
                    continue block17;
                }
                case 2: {
                    this.line += Leb128.readSignedLeb128(byteArrayByteInput);
                    continue block17;
                }
                case 7: {
                    continue block17;
                }
                case 8: {
                    continue block17;
                }
                case 9: {
                    continue block17;
                }
            }
            if (n < 10) {
                throw new RuntimeException("Invalid extended opcode encountered " + n);
            }
            n5 = n - 10;
            this.address += n5 / 15;
            this.line += -4 + n5 % 15;
            this.positions.add(new PositionEntry(this.address, this.line));
        }
    }

    public static void validateEncode(byte[] byArray, DexFile dexFile, CstMethodRef cstMethodRef, DalvCode dalvCode, boolean bl) {
        PositionList positionList = dalvCode.getPositions();
        LocalList localList = dalvCode.getLocals();
        DalvInsnList dalvInsnList = dalvCode.getInsns();
        int n = dalvInsnList.codeSize();
        int n2 = dalvInsnList.getRegistersSize();
        try {
            DebugInfoDecoder.validateEncode0(byArray, n, n2, bl, cstMethodRef, dexFile, positionList, localList);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("instructions:");
            dalvInsnList.debugPrint(System.err, "  ", true);
            System.err.println("local list:");
            localList.debugPrint(System.err, "  ");
            throw ExceptionWithContext.withContext(runtimeException, "while processing " + cstMethodRef.toHuman());
        }
    }

    private static void validateEncode0(byte[] byArray, int n, int n2, boolean bl, CstMethodRef cstMethodRef, DexFile dexFile, PositionList positionList, LocalList localList) {
        Object object;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        DebugInfoDecoder debugInfoDecoder = new DebugInfoDecoder(byArray, n, n2, bl, cstMethodRef, dexFile);
        debugInfoDecoder.decode();
        List<PositionEntry> list = debugInfoDecoder.getPositionList();
        if (list.size() != positionList.size()) {
            throw new RuntimeException("Decoded positions table not same size was " + list.size() + " expected " + positionList.size());
        }
        for (PositionEntry positionEntry : list) {
            n7 = 0;
            for (n6 = positionList.size() - 1; n6 >= 0; --n6) {
                PositionList.Entry entry = positionList.get(n6);
                if (positionEntry.line != entry.getPosition().getLine() || positionEntry.address != entry.getAddress()) continue;
                n7 = 1;
                break;
            }
            if (n7 != 0) continue;
            throw new RuntimeException("Could not match position entry: " + positionEntry.address + ", " + positionEntry.line);
        }
        List<LocalEntry> list2 = debugInfoDecoder.getLocals();
        int n8 = debugInfoDecoder.thisStringIdx;
        n7 = list2.size();
        n6 = debugInfoDecoder.getParamBase();
        block2: for (n5 = 0; n5 < n7; ++n5) {
            LocalEntry localEntry = (LocalEntry)list2.get(n5);
            n4 = localEntry.nameIndex;
            if (n4 >= 0 && n4 != n8) continue;
            for (n3 = n5 + 1; n3 < n7; ++n3) {
                object = (LocalEntry)list2.get(n3);
                if (((LocalEntry)object).address != 0) continue block2;
                if (localEntry.reg != ((LocalEntry)object).reg || !((LocalEntry)object).isStart) continue;
                list2.set(n5, (LocalEntry)object);
                list2.remove(n3);
                --n7;
                continue block2;
            }
        }
        n5 = localList.size();
        int n9 = 0;
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            LocalEntry localEntry;
            object = localList.get(n3);
            if (((LocalList.Entry)object).getDisposition() == LocalList.Disposition.END_REPLACED) continue;
            do {
                localEntry = (LocalEntry)list2.get(n9);
            } while (localEntry.nameIndex < 0 && ++n9 < n7);
            int n10 = localEntry.address;
            if (localEntry.reg != ((LocalList.Entry)object).getRegister()) {
                System.err.println("local register mismatch at orig " + n3 + " / decoded " + n9);
                n4 = 1;
                break;
            }
            if (localEntry.isStart != ((LocalList.Entry)object).isStart()) {
                System.err.println("local start/end mismatch at orig " + n3 + " / decoded " + n9);
                n4 = 1;
                break;
            }
            if (n10 != ((LocalList.Entry)object).getAddress() && (n10 != 0 || localEntry.reg < n6)) {
                System.err.println("local address mismatch at orig " + n3 + " / decoded " + n9);
                n4 = 1;
                break;
            }
            ++n9;
        }
        if (n4 != 0) {
            System.err.println("decoded locals:");
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object = (LocalEntry)iterator.next();
                System.err.println("  " + object);
            }
            throw new RuntimeException("local table problem");
        }
    }

    private static class LocalEntry {
        public int address;
        public boolean isStart;
        public int reg;
        public int nameIndex;
        public int typeIndex;
        public int signatureIndex;

        public LocalEntry(int n, boolean bl, int n2, int n3, int n4, int n5) {
            this.address = n;
            this.isStart = bl;
            this.reg = n2;
            this.nameIndex = n3;
            this.typeIndex = n4;
            this.signatureIndex = n5;
        }

        public String toString() {
            return String.format("[%x %s v%d %04x %04x %04x]", this.address, this.isStart ? "start" : "end", this.reg, this.nameIndex, this.typeIndex, this.signatureIndex);
        }
    }

    private static class PositionEntry {
        public int address;
        public int line;

        public PositionEntry(int n, int n2) {
            this.address = n;
            this.line = n2;
        }
    }
}

