/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.DalvInsnList;
import com.android.dx.dex.file.CatchStructs;
import com.android.dx.dex.file.DebugInfoItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.Section;
import com.android.dx.dex.file.TypeIdsSection;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.io.PrintWriter;

public final class CodeItem
extends OffsettedItem {
    private static final int ALIGNMENT = 4;
    private static final int HEADER_SIZE = 16;
    private final CstMethodRef ref;
    private final DalvCode code;
    private CatchStructs catches;
    private final boolean isStatic;
    private final TypeList throwsList;
    private DebugInfoItem debugInfo;

    public CodeItem(CstMethodRef cstMethodRef, DalvCode dalvCode, boolean bl, TypeList typeList) {
        super(4, -1);
        if (cstMethodRef == null) {
            throw new NullPointerException("ref == null");
        }
        if (dalvCode == null) {
            throw new NullPointerException("code == null");
        }
        if (typeList == null) {
            throw new NullPointerException("throwsList == null");
        }
        this.ref = cstMethodRef;
        this.code = dalvCode;
        this.isStatic = bl;
        this.throwsList = typeList;
        this.catches = null;
        this.debugInfo = null;
    }

    public ItemType itemType() {
        return ItemType.TYPE_CODE_ITEM;
    }

    public void addContents(DexFile dexFile) {
        MixedItemSection mixedItemSection = dexFile.getByteData();
        TypeIdsSection typeIdsSection = dexFile.getTypeIds();
        if (this.code.hasPositions() || this.code.hasLocals()) {
            this.debugInfo = new DebugInfoItem(this.code, this.isStatic, this.ref);
            mixedItemSection.add(this.debugInfo);
        }
        if (this.code.hasAnyCatches()) {
            for (Type comparable : this.code.getCatchTypes()) {
                typeIdsSection.intern(comparable);
            }
            this.catches = new CatchStructs(this.code);
        }
        for (Constant constant : this.code.getInsnConstants()) {
            dexFile.internIfAppropriate(constant);
        }
    }

    public String toString() {
        return "CodeItem{" + this.toHuman() + "}";
    }

    public String toHuman() {
        return this.ref.toHuman();
    }

    public CstMethodRef getRef() {
        return this.ref;
    }

    public void debugPrint(PrintWriter printWriter, String string, boolean bl) {
        printWriter.println(this.ref.toHuman() + ":");
        DalvInsnList dalvInsnList = this.code.getInsns();
        printWriter.println("regs: " + Hex.u2(this.getRegistersSize()) + "; ins: " + Hex.u2(this.getInsSize()) + "; outs: " + Hex.u2(this.getOutsSize()));
        dalvInsnList.debugPrint(printWriter, string, bl);
        String string2 = string + "  ";
        if (this.catches != null) {
            printWriter.print(string);
            printWriter.println("catches");
            this.catches.debugPrint(printWriter, string2);
        }
        if (this.debugInfo != null) {
            printWriter.print(string);
            printWriter.println("debug info");
            this.debugInfo.debugPrint(printWriter, string2);
        }
    }

    protected void place0(Section section, int n) {
        int n2;
        final DexFile dexFile = section.getFile();
        this.code.assignIndices(new DalvCode.AssignIndicesCallback(){

            public int getIndex(Constant constant) {
                IndexedItem indexedItem = dexFile.findItemOrNull(constant);
                if (indexedItem == null) {
                    return -1;
                }
                return indexedItem.getIndex();
            }
        });
        if (this.catches != null) {
            this.catches.encode(dexFile);
            n2 = this.catches.writeSize();
        } else {
            n2 = 0;
        }
        int n3 = this.code.getInsns().codeSize();
        if ((n3 & 1) != 0) {
            ++n3;
        }
        this.setWriteSize(16 + n3 * 2 + n2);
    }

    protected void writeTo0(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        int n;
        boolean bl = annotatedOutput.annotates();
        int n2 = this.getRegistersSize();
        int n3 = this.getOutsSize();
        int n4 = this.getInsSize();
        int n5 = this.code.getInsns().codeSize();
        boolean bl2 = (n5 & 1) != 0;
        int n6 = this.catches == null ? 0 : this.catches.triesSize();
        int n7 = n = this.debugInfo == null ? 0 : this.debugInfo.getAbsoluteOffset();
        if (bl) {
            annotatedOutput.annotate(0, this.offsetString() + ' ' + this.ref.toHuman());
            annotatedOutput.annotate(2, "  registers_size: " + Hex.u2(n2));
            annotatedOutput.annotate(2, "  ins_size:       " + Hex.u2(n4));
            annotatedOutput.annotate(2, "  outs_size:      " + Hex.u2(n3));
            annotatedOutput.annotate(2, "  tries_size:     " + Hex.u2(n6));
            annotatedOutput.annotate(4, "  debug_off:      " + Hex.u4(n));
            annotatedOutput.annotate(4, "  insns_size:     " + Hex.u4(n5));
            int n8 = this.throwsList.size();
            if (n8 != 0) {
                annotatedOutput.annotate(0, "  throws " + StdTypeList.toHuman(this.throwsList));
            }
        }
        annotatedOutput.writeShort(n2);
        annotatedOutput.writeShort(n4);
        annotatedOutput.writeShort(n3);
        annotatedOutput.writeShort(n6);
        annotatedOutput.writeInt(n);
        annotatedOutput.writeInt(n5);
        this.writeCodes(dexFile, annotatedOutput);
        if (this.catches != null) {
            if (bl2) {
                if (bl) {
                    annotatedOutput.annotate(2, "  padding: 0");
                }
                annotatedOutput.writeShort(0);
            }
            this.catches.writeTo(dexFile, annotatedOutput);
        }
        if (bl && this.debugInfo != null) {
            annotatedOutput.annotate(0, "  debug info");
            this.debugInfo.annotateTo(dexFile, annotatedOutput, "    ");
        }
    }

    private void writeCodes(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        DalvInsnList dalvInsnList = this.code.getInsns();
        try {
            dalvInsnList.writeTo(annotatedOutput);
        }
        catch (RuntimeException runtimeException) {
            throw ExceptionWithContext.withContext(runtimeException, "...while writing instructions for " + this.ref.toHuman());
        }
    }

    private int getInsSize() {
        return this.ref.getParameterWordCount(this.isStatic);
    }

    private int getOutsSize() {
        return this.code.getInsns().getOutsSize();
    }

    private int getRegistersSize() {
        return this.code.getInsns().getRegistersSize();
    }
}

