/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstBaseMethodRef;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.FixedSizeList;
import com.android.dx.util.IndentingWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DalvInsnList
extends FixedSizeList {
    private final int regCount;

    public static DalvInsnList makeImmutable(ArrayList<DalvInsn> arrayList, int n) {
        int n2 = arrayList.size();
        DalvInsnList dalvInsnList = new DalvInsnList(n2, n);
        for (int i = 0; i < n2; ++i) {
            dalvInsnList.set(i, arrayList.get(i));
        }
        dalvInsnList.setImmutable();
        return dalvInsnList;
    }

    public DalvInsnList(int n, int n2) {
        super(n);
        this.regCount = n2;
    }

    public DalvInsn get(int n) {
        return (DalvInsn)this.get0(n);
    }

    public void set(int n, DalvInsn dalvInsn) {
        this.set0(n, dalvInsn);
    }

    public int codeSize() {
        int n = this.size();
        if (n == 0) {
            return 0;
        }
        DalvInsn dalvInsn = this.get(n - 1);
        return dalvInsn.getNextAddress();
    }

    public void writeTo(AnnotatedOutput annotatedOutput) {
        int n;
        int n2 = annotatedOutput.getCursor();
        int n3 = this.size();
        if (annotatedOutput.annotates()) {
            n = annotatedOutput.isVerbose();
            for (int i = 0; i < n3; ++i) {
                DalvInsn dalvInsn = (DalvInsn)this.get0(i);
                int n4 = dalvInsn.codeSize() * 2;
                String string = n4 != 0 || n != 0 ? dalvInsn.listingString("  ", annotatedOutput.getAnnotationWidth(), true) : null;
                if (string != null) {
                    annotatedOutput.annotate(n4, string);
                    continue;
                }
                if (n4 == 0) continue;
                annotatedOutput.annotate(n4, "");
            }
        }
        for (n = 0; n < n3; ++n) {
            DalvInsn dalvInsn = (DalvInsn)this.get0(n);
            try {
                dalvInsn.writeTo(annotatedOutput);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw ExceptionWithContext.withContext(runtimeException, "...while writing " + dalvInsn);
            }
        }
        n = (annotatedOutput.getCursor() - n2) / 2;
        if (n != this.codeSize()) {
            throw new RuntimeException("write length mismatch; expected " + this.codeSize() + " but actually wrote " + n);
        }
    }

    public int getRegistersSize() {
        return this.regCount;
    }

    public int getOutsSize() {
        int n = this.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n3;
            Constant constant;
            DalvInsn dalvInsn = (DalvInsn)this.get0(i);
            if (!(dalvInsn instanceof CstInsn) || !((constant = ((CstInsn)dalvInsn).getConstant()) instanceof CstBaseMethodRef) || (n3 = ((CstBaseMethodRef)constant).getParameterWordCount(bl = dalvInsn.getOpcode().getFamily() == 113)) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public void debugPrint(Writer writer, String string, boolean bl) {
        IndentingWriter indentingWriter = new IndentingWriter(writer, 0, string);
        int n = this.size();
        try {
            for (int i = 0; i < n; ++i) {
                DalvInsn dalvInsn = (DalvInsn)this.get0(i);
                String string2 = dalvInsn.codeSize() != 0 || bl ? dalvInsn.listingString("", 0, bl) : null;
                if (string2 == null) continue;
                indentingWriter.write(string2);
            }
            indentingWriter.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void debugPrint(OutputStream outputStream, String string, boolean bl) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        this.debugPrint(outputStreamWriter, string, bl);
        try {
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

