/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CodeAddress;
import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.SourcePosition;

public final class BlockAddresses {
    private final CodeAddress[] starts;
    private final CodeAddress[] lasts;
    private final CodeAddress[] ends;

    public BlockAddresses(RopMethod ropMethod) {
        BasicBlockList basicBlockList = ropMethod.getBlocks();
        int n = basicBlockList.getMaxLabel();
        this.starts = new CodeAddress[n];
        this.lasts = new CodeAddress[n];
        this.ends = new CodeAddress[n];
        this.setupArrays(ropMethod);
    }

    public CodeAddress getStart(BasicBlock basicBlock) {
        return this.starts[basicBlock.getLabel()];
    }

    public CodeAddress getStart(int n) {
        return this.starts[n];
    }

    public CodeAddress getLast(BasicBlock basicBlock) {
        return this.lasts[basicBlock.getLabel()];
    }

    public CodeAddress getLast(int n) {
        return this.lasts[n];
    }

    public CodeAddress getEnd(BasicBlock basicBlock) {
        return this.ends[basicBlock.getLabel()];
    }

    public CodeAddress getEnd(int n) {
        return this.ends[n];
    }

    private void setupArrays(RopMethod ropMethod) {
        BasicBlockList basicBlockList = ropMethod.getBlocks();
        int n = basicBlockList.size();
        for (int i = 0; i < n; ++i) {
            BasicBlock basicBlock = basicBlockList.get(i);
            int n2 = basicBlock.getLabel();
            Insn insn = basicBlock.getInsns().get(0);
            this.starts[n2] = new CodeAddress(insn.getPosition());
            SourcePosition sourcePosition = basicBlock.getLastInsn().getPosition();
            this.lasts[n2] = new CodeAddress(sourcePosition);
            this.ends[n2] = new CodeAddress(sourcePosition);
        }
    }
}

